/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2004-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package testutil;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;

/**
 * Extends the Apache Exec task to execute a given command in a separate thread and return control.
 * Supports the same attributes and elements as the exec task.
 * This task is useful for running blocking server programs where you wish
 * the server to be spawned off in a separate thread and execution to proceed
 * without blocking for the server.
 *
 * @author <a href="mailto"nandkumar.kesavan@sun.com">Nandkumar Kesavan</a>
 * @see <a href="http://ant.apache.org/manual/CoreTasks/exec.html">Apache Exec Task</a>
 */
public class SpawnTask extends ExecTask implements Runnable{

    /**
     * Run the command in a new thread
     */
    public void execute() throws BuildException {

        //Instantiate a new thread and run the command in this thread.
        Thread taskRunner = new Thread(this);
        taskRunner.start();

    }

    public void run() {

        //Run the parent ExecTask in a separate thread
        super.execute();

    }

}
