 /* JSDebugger - a console logger for debugging JavaScript
  * Copyright (C) 2003-2007 Stefan Strigler <steve@zeank.in-berlin.de>
  *
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.
  */

var DEBUGGER_MAX_LEVEL = 4;

// fucking IE is too stupid for window names
function encWN(wName) {
  wName = wName.replace(/@/,"at");
  wName = wName.replace(/\./g,"dot");
  wName = wName.replace(/\//g,"slash");
  wName = wName.replace(/&/g,"amp");
  wName = wName.replace(/\'/g,"tick");
  wName = wName.replace(/=/g,"equals");
  wName = wName.replace(/#/g,"pound");
  wName = wName.replace(/:/g,"colon");	
  wName = wName.replace(/%/g,"percent");
  wName = wName.replace(/-/g,"dash");
  wName = wName.replace(/ /g,"blank");
  return wName;
}

function htmlEnc(str) {
  if (!str)
    return null;

  str = str.replace(/&/g,"&amp;");
  str = str.replace(/</g,"&lt;");
  str = str.replace(/>/g,"&gt;");
	str = str.replace(/\n/g,"<br>");
  return str;
}

function DebugMsg(str,lvl,caller) {
  this.str = str || '';
  this.str = htmlEnc(this.str);
  this.lvl = lvl || 0;
  this.caller = (caller&&caller.name)? caller.name : 'unknown';
}

function DebugLog(str,lvl) {
  if (!this.debug) // nothing to do
    return;

  lvl = (isNaN(lvl))? 0 : lvl;
  if (!this.debugW.oDbg || this.debugW.oDbg != this)
    this.debugW.oDbg = this;
  
  // add to queue
  this.debugMsgs = this.debugMsgs.concat(new DebugMsg(str,lvl,DebugLog.caller));
}

function DebugSetLevel(lvl) {
  if (lvl < 0)
    lvl = 0;
  if (lvl > DEBUGGER_MAX_LEVEL)
    lvl = DEBUGGER_MAX_LEVEL;
  this.lvl = lvl;
}

function DebugStart() {
  if (!this.debugW || this.debugW.closed) { // open the debugger window
    debugW = window.open('','debugW'+encWN(this.id),"width=480,height=320,scrollbars=yes,resizable=yes");
    if (!debugW)
      debugW = window.open("Debugger.html","debugW"+encWN(this.id),"width=480,height=320,scrollbars=yes,resizable=yes");
    else if (!debugW.location.href.match(/Debugger.html$/))
      debugW.location.href = "Debugger.html";
    
    this.debugW = debugW;
    
    if (!this.debugW)
      return;
    
    if (!this.debugW.oDbg)
      this.debugW.oDbg = this;
  } else {
    this.debugW.frames['DebugTop'].document.getElementById('toggleLogButton').innerHTML = 'Stop';
  }
  
  this.debug = true;

  oDbg = this;
  if (oDbg.debugW.popMsgs) // debugW already loaded - if not it sets timeout itslef upon load
    this._to = setTimeout("oDbg.debugW.popMsgs();",1);
}

function DebugStop() {
  clearTimeout(this._to);
  this.debug = false;
}

function Debugger(lvl,id) {
  this.lvl = lvl || 0;
  if (this.lvl > DEBUGGER_MAX_LEVEL)
    this.lvl = DEBUGGER_MAX_LEVEL;

  this.id = id || '';

  this.debugMsgs = new Array();

  this.log = DebugLog;
  this.setLevel = DebugSetLevel;
  this.start = DebugStart;
  this.stop = DebugStop;
}
