/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.util;

import jd.xml.util.DefaultErrorHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public abstract class SaxUtil {
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_NSPREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    public static final String PROPERTY_LEXHANDLER = "http://xml.org/sax/properties/lexical-handler";
    public static final String PROPERTY_DECLHANDLER = "http://xml.org/sax/properties/declaration-handler";

    public static XMLReader createXmlReader() throws SAXException {
        String string = null;
        try {
            string = System.getProperty("org.xml.sax.driver", string);
            if (string != null) {
                return SaxUtil.createXmlReader(string);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (SAXException sAXException) {
            System.err.println();
            System.err.println("Error: cannot create a SAX 2 XMLReader to parse XML documents");
            System.err.println("-> tried the custom parser '" + string + "'");
            System.err.println("Does the classpath contain the SAX Parser library?");
            System.err.println();
            throw sAXException;
        }
        try {
            return SaxUtil.createXmlReader("org.apache.crimson.parser.XMLReaderImpl");
        }
        catch (SAXException sAXException) {
            try {
                return SaxUtil.createXmlReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException sAXException2) {
                System.err.println();
                System.err.println("Error: cannot create a SAX 2 XMLReader to parse XML documents");
                System.err.println("-> tried the Crimson parser 'org.apache.crimson.parser.XMLReaderImpl'");
                System.err.println("-> tried the Xerces  parser 'org.apache.xerces.parsers.SAXParser'");
                System.err.println("Does the classpath contain the SAX Parser library?");
                System.err.println();
                throw sAXException2;
            }
        }
    }

    public static XMLReader createXmlReader(String string) throws SAXException {
        Object obj;
        try {
            obj = Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new SAXException("failed to instantiate an object of class '" + string + "'", exception);
        }
        if (obj instanceof XMLReader) {
            return (XMLReader)obj;
        }
        if (obj instanceof Parser) {
            return new ParserAdapter((Parser)obj);
        }
        throw new SAXException("class '" + string + "' is not a SAX XMLReader or Parser class");
    }

    public static void setFeature(XMLReader xMLReader, String string, boolean bl) {
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
    }

    public static boolean getFeature(XMLReader xMLReader, String string) {
        try {
            return xMLReader.getFeature(string);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            return false;
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            return false;
        }
    }

    public static void setValidating(XMLReader xMLReader, boolean bl) {
        SaxUtil.setFeature(xMLReader, FEATURE_VALIDATION, bl);
        if (bl && xMLReader.getErrorHandler() == null) {
            xMLReader.setErrorHandler(new DefaultErrorHandler());
        }
    }

    public static boolean isValidating(XMLReader xMLReader) {
        return SaxUtil.getFeature(xMLReader, FEATURE_VALIDATION);
    }

    public static void setProperty(XMLReader xMLReader, String string, Object object) {
        try {
            xMLReader.setProperty(string, object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
    }
}

