/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.HashSet;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DefaultDragTracker;
import org.jhotdraw.draw.DefaultHandleTracker;
import org.jhotdraw.draw.DefaultSelectAreaTracker;
import org.jhotdraw.draw.DragTracker;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleTracker;
import org.jhotdraw.draw.SelectAreaTracker;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;

public class SelectionTool
extends AbstractTool
implements ToolListener {
    private Tool tracker = this.getSelectAreaTracker();
    private HandleTracker handleTracker;
    private SelectAreaTracker selectAreaTracker;
    private DragTracker dragTracker;
    public static final String SELECT_BEHIND_ENABLED_PROPERTY = "selectBehindEnabled";
    private boolean isSelectBehindEnabled = true;

    public SelectionTool() {
        this.tracker.addToolListener(this);
    }

    public void setSelectBehindEnabled(boolean bl) {
        boolean bl2 = this.isSelectBehindEnabled;
        this.isSelectBehindEnabled = bl;
        this.firePropertyChange(SELECT_BEHIND_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isSelectBehindEnabled() {
        return this.isSelectBehindEnabled;
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.tracker.activate(drawingEditor);
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        this.tracker.deactivate(drawingEditor);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyReleased(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.keyTyped(keyEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        this.tracker.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.tracker.mouseExited(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.tracker.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.getView() != null && this.getView().isEnabled()) {
            this.tracker.mouseReleased(mouseEvent);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.tracker.draw(graphics2D);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getView() != null && this.getView().isEnabled()) {
            super.mousePressed(mouseEvent);
            DrawingView drawingView = this.getView();
            Handle handle = drawingView.findHandle(this.anchor);
            Tool tool = null;
            if (handle != null) {
                tool = this.getHandleTracker(handle);
            } else {
                Figure figure;
                Drawing drawing = drawingView.getDrawing();
                Point2D.Double double_ = drawingView.viewToDrawing(this.anchor);
                if (this.isSelectBehindEnabled() && (mouseEvent.getModifiersEx() & 0x280) != 0) {
                    figure = drawingView.findFigure(this.anchor);
                    while (figure != null && !figure.isSelectable()) {
                        figure = drawing.findFigureBehind(double_, figure);
                    }
                    HashSet<Figure> hashSet = new HashSet<Figure>(drawingView.getSelectedFigures());
                    hashSet.add(figure);
                    Figure figure2 = drawingView.getDrawing().findFigureBehind(drawingView.viewToDrawing(this.anchor), hashSet);
                    if (figure2 != null) {
                        figure = figure2;
                    }
                } else {
                    figure = null;
                    if (this.isSelectBehindEnabled()) {
                        for (Figure figure3 : drawingView.getSelectedFigures()) {
                            if (!figure3.contains(double_)) continue;
                            figure = figure3;
                            break;
                        }
                    }
                    if (figure == null) {
                        figure = drawingView.findFigure(this.anchor);
                        while (figure != null && !figure.isSelectable()) {
                            figure = drawing.findFigureBehind(double_, figure);
                        }
                    }
                }
                if (figure != null && figure.isSelectable()) {
                    tool = this.getDragTracker(figure);
                } else {
                    if (!mouseEvent.isShiftDown()) {
                        drawingView.clearSelection();
                        drawingView.setHandleDetailLevel(0);
                    }
                    tool = this.getSelectAreaTracker();
                }
            }
            if (tool != null) {
                this.setTracker(tool);
            }
            this.tracker.mousePressed(mouseEvent);
        }
    }

    protected void setTracker(Tool tool) {
        if (this.tracker != null) {
            this.tracker.deactivate(this.getEditor());
            this.tracker.removeToolListener(this);
        }
        this.tracker = tool;
        if (this.tracker != null) {
            this.tracker.activate(this.getEditor());
            this.tracker.addToolListener(this);
        }
    }

    protected HandleTracker getHandleTracker(Handle handle) {
        if (this.handleTracker == null) {
            this.handleTracker = new DefaultHandleTracker();
        }
        this.handleTracker.setHandles(handle, this.getView().getCompatibleHandles(handle));
        return this.handleTracker;
    }

    protected DragTracker getDragTracker(Figure figure) {
        if (this.dragTracker == null) {
            this.dragTracker = new DefaultDragTracker();
        }
        this.dragTracker.setDraggedFigure(figure);
        return this.dragTracker;
    }

    protected SelectAreaTracker getSelectAreaTracker() {
        if (this.selectAreaTracker == null) {
            this.selectAreaTracker = new DefaultSelectAreaTracker();
        }
        return this.selectAreaTracker;
    }

    public void setHandleTracker(HandleTracker handleTracker) {
        this.handleTracker = handleTracker;
    }

    public void setSelectAreaTracker(SelectAreaTracker selectAreaTracker) {
        this.selectAreaTracker = selectAreaTracker;
    }

    public void setDragTracker(DragTracker dragTracker) {
        this.dragTracker = dragTracker;
    }

    @Override
    public void toolStarted(ToolEvent toolEvent) {
    }

    @Override
    public void toolDone(ToolEvent toolEvent) {
        SelectAreaTracker selectAreaTracker = this.getSelectAreaTracker();
        if (selectAreaTracker != null) {
            if (this.tracker != null) {
                this.tracker.deactivate(this.getEditor());
                this.tracker.removeToolListener(this);
            }
            this.tracker = selectAreaTracker;
            this.tracker.activate(this.getEditor());
            this.tracker.addToolListener(this);
        }
        this.fireToolDone();
    }

    @Override
    public void areaInvalidated(ToolEvent toolEvent) {
        this.fireAreaInvalidated(toolEvent.getInvalidatedArea());
    }

    @Override
    public boolean supportsHandleInteraction() {
        return true;
    }
}

