# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class JobExecution(ProxyResource):
    """An execution of a job.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar job_version: The job version number.
    :vartype job_version: int
    :ivar step_name: The job step name.
    :vartype step_name: str
    :ivar step_id: The job step id.
    :vartype step_id: int
    :ivar job_execution_id: The unique identifier of the job execution.
    :vartype job_execution_id: str
    :ivar lifecycle: The detailed state of the job execution. Possible values
     include: 'Created', 'InProgress', 'WaitingForChildJobExecutions',
     'WaitingForRetry', 'Succeeded', 'SucceededWithSkipped', 'Failed',
     'TimedOut', 'Canceled', 'Skipped'
    :vartype lifecycle: str or ~azure.mgmt.sql.models.JobExecutionLifecycle
    :ivar provisioning_state: The ARM provisioning state of the job execution.
     Possible values include: 'Created', 'InProgress', 'Succeeded', 'Failed',
     'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.sql.models.ProvisioningState
    :ivar create_time: The time that the job execution was created.
    :vartype create_time: datetime
    :ivar start_time: The time that the job execution started.
    :vartype start_time: datetime
    :ivar end_time: The time that the job execution completed.
    :vartype end_time: datetime
    :param current_attempts: Number of times the job execution has been
     attempted.
    :type current_attempts: int
    :ivar current_attempt_start_time: Start time of the current attempt.
    :vartype current_attempt_start_time: datetime
    :ivar last_message: The last status or error message.
    :vartype last_message: str
    :ivar target: The target that this execution is executed on.
    :vartype target: ~azure.mgmt.sql.models.JobExecutionTarget
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'job_version': {'readonly': True},
        'step_name': {'readonly': True},
        'step_id': {'readonly': True},
        'job_execution_id': {'readonly': True},
        'lifecycle': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'create_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'current_attempt_start_time': {'readonly': True},
        'last_message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'job_version': {'key': 'properties.jobVersion', 'type': 'int'},
        'step_name': {'key': 'properties.stepName', 'type': 'str'},
        'step_id': {'key': 'properties.stepId', 'type': 'int'},
        'job_execution_id': {'key': 'properties.jobExecutionId', 'type': 'str'},
        'lifecycle': {'key': 'properties.lifecycle', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'current_attempts': {'key': 'properties.currentAttempts', 'type': 'int'},
        'current_attempt_start_time': {'key': 'properties.currentAttemptStartTime', 'type': 'iso-8601'},
        'last_message': {'key': 'properties.lastMessage', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'JobExecutionTarget'},
    }

    def __init__(self, **kwargs):
        super(JobExecution, self).__init__(**kwargs)
        self.job_version = None
        self.step_name = None
        self.step_id = None
        self.job_execution_id = None
        self.lifecycle = None
        self.provisioning_state = None
        self.create_time = None
        self.start_time = None
        self.end_time = None
        self.current_attempts = kwargs.get('current_attempts', None)
        self.current_attempt_start_time = None
        self.last_message = None
        self.target = None
