/*	otherwindow.c
	Copyright (C) 2004-2007 Mark Tyler and Dmitry Groshev

	This file is part of rgbPaint.

	rgbPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	rgbPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with rgbPaint in the file COPYING.
*/

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "global.h"

#include "memory.h"
#include "otherwindow.h"
#include "mygtk.h"
#include "png.h"
#include "mainwindow.h"
#include "viewer.h"
#include "canvas.h"
#include "toolbar.h"


///	NEW IMAGE WINDOW

GtkWidget *new_window;
GtkWidget *spinbutton_height, *spinbutton_width /*, *spinbutton_cols */;


gint delete_new( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	gtk_widget_destroy(new_window);

	return FALSE;
}

void reset_tools()
{
	float old_zoom = can_zoom;

	init_istate();
	init_pal();

	can_zoom = -1;
	align_size(old_zoom);

	update_menus();
	toolbar_palette_refresh();
}

void do_new_chores()
{
	reset_tools();
	set_new_filename( _("Untitled") );
	update_all_views();

	gtk_adjustment_value_changed( gtk_scrolled_window_get_hadjustment(
		GTK_SCROLLED_WINDOW(scrolledwindow_canvas) ) );
	gtk_adjustment_value_changed( gtk_scrolled_window_get_vadjustment(
		GTK_SCROLLED_WINDOW(scrolledwindow_canvas) ) );
			// Set up scrollbars properly
}

int do_new_one(int nw, int nh)
{
	int res;

	mem_pal_copy( mem_pal, mem_pal_def );

	mtMIN( nw, nw, MAX_WIDTH )
	mtMAX( nw, nw, MIN_WIDTH )
	mtMIN( nh, nh, MAX_HEIGHT )
	mtMAX( nh, nh, MIN_HEIGHT )

	mem_cols = 256;

	res = mem_new( nw, nh, 3, CMASK_IMAGE );
	if ( res!= 0 )			// Not enough memory!
	{
		memory_errors(1);
	}
	do_new_chores();

	return res;
}

static void create_new(GtkWidget *widget)
{
	int nw, nh, err;

	nw = read_spin(spinbutton_width);
	nh = read_spin(spinbutton_height);

	err = do_new_one( nw, nh );

	if ( err>0 )		// System was unable to allocate memory for image, using 8x8 instead
	{
		nw = mem_width;
		nh = mem_height;  
	}

	/* Lose a selection marquee */
	pressed_select_none(NULL, NULL);

	gtk_widget_destroy(new_window);
}

void generic_new_window(int type)	// 0=New image, 1=New layer
{
	int w = mem_width, h = mem_height;
	GtkWidget *vbox, *hbox, *button, *table;
	GtkAccelGroup* ag = gtk_accel_group_new();

	if ( type == 0 && check_for_changes(GTK_STOCK_NO) == 1 ) return;

	new_window = gtk_dialog_new();
	gtk_window_set_title( GTK_WINDOW(new_window), _("New Image") );
	gtk_window_set_modal(GTK_WINDOW(new_window), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(new_window), GTK_WINDOW(main_window));

	vbox = GTK_DIALOG(new_window)->vbox;

	table = add_a_table( 3, 2, 5, vbox );

	if ( type == 0 )
	{
		w = DEFAULT_WIDTH;
		h = DEFAULT_HEIGHT;
	}

	spinbutton_width = spin_to_table(table, 0, 1, 5, w, MIN_WIDTH, MAX_WIDTH);
	spinbutton_height = spin_to_table(table, 1, 1, 5, h, MIN_WIDTH, MAX_HEIGHT);

	add_to_table( _("Width"), table, 0, 0, 5 );
	add_to_table( _("Height"), table, 1, 0, 5 );

	hbox = GTK_DIALOG(new_window)->action_area;

	button = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
	gtk_widget_set_usize(button, 80, -2);
	gtk_widget_show( button );
	gtk_box_pack_start( GTK_BOX(hbox), button, TRUE, TRUE, 4 );

	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(new_window));
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_Escape, 0, (GtkAccelFlags) 0);

	button = gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_widget_set_usize(button, 80, -2);
	gtk_widget_show( button );
	gtk_box_pack_start( GTK_BOX(hbox), button, TRUE, TRUE, 4 );

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(create_new), NULL);
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_KP_Enter, 0, (GtkAccelFlags) 0);
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_Return, 0, (GtkAccelFlags) 0);

	gtk_signal_connect(GTK_OBJECT(new_window), "delete_event",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

	gtk_widget_show (new_window);
	gtk_window_add_accel_group(GTK_WINDOW (new_window), ag);
}

void pressed_new( GtkMenuItem *menu_item, gpointer user_data )
{
	generic_new_window(0);
}

void pal_refresher()
{
	update_all_views();
	init_pal();
}


///	BRIGHTNESS-CONTRAST-SATURATION WINDOW

#define BRCOSA_ITEMS 6

static GtkWidget *brcosa_window,
		*brcosa_spins[BRCOSA_ITEMS+2],	// Extra 2 used for palette limits
		*brcosa_number_labels[BRCOSA_ITEMS],
		*brcosa_buttons[5];

static int brcosa_values[BRCOSA_ITEMS], brcosa_pal_lim[2],
		brcosa_values_default[BRCOSA_ITEMS] = {0, 0, 0, 8, 100, 0};
png_color brcosa_pal[256];

static void brcosa_buttons_sensitive() // Set 4 brcosa button as sensitive if the user has assigned changes
{
	int i;
	gboolean state = FALSE;

	if ( brcosa_buttons[0] == NULL ) return;

	for ( i=0; i<BRCOSA_ITEMS; i++ )
	{
		if ( (brcosa_values[i] != brcosa_values_default[i]) )
		{
			state = TRUE;
		}
	}

	for ( i=2; i<5; i++ )
	{
		if ( brcosa_buttons[i] ) gtk_widget_set_sensitive( brcosa_buttons[i], state );
	}
}

static gint click_brcosa_preview( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	int i;

	for ( i=0; i<BRCOSA_ITEMS; i++ )
	{
		mem_prev_bcsp[i] = brcosa_values[i];
	}

	if (mem_img_bpp == 3) main_update_area(0, 0, mem_width, mem_height);

	return FALSE;
}

static void brcosa_spinslide_moved(GtkAdjustment *adj, gpointer user_data)
{
	char txt[32];

	brcosa_values[(int)user_data] = ADJ2INT(adj);
	brcosa_buttons_sensitive();
	snprintf( txt, 30, "%i", ADJ2INT(adj) );
	gtk_label_set_text( GTK_LABEL(brcosa_number_labels[(int)user_data]), txt );

	click_brcosa_preview( NULL, NULL, NULL );
}

static gint delete_brcosa( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	gtk_widget_destroy(brcosa_window);

	mem_preview = 0;		// If in RGB mode this is required to disable live preview

	return FALSE;
}

static gint click_brcosa_cancel( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	mem_pal_copy( mem_pal, brcosa_pal );
	pal_refresher();
	delete_brcosa( NULL, NULL, NULL );

	return FALSE;
}

static gint click_brcosa_apply( GtkWidget *widget, GdkEvent *event, gpointer data )
{
	unsigned char *mask, *mask0, *tmp;
	int i;

	mem_pal_copy( mem_pal, brcosa_pal );

	if ( brcosa_values[0] != 0 || /*brcosa_values[1] != 0 ||*/
		brcosa_values[2] != 0 || brcosa_values[3] != 8 || brcosa_values[4] != 100 ||
		brcosa_values[5] != 0 )
	{
		spot_undo(UNDO_DRAW);

		click_brcosa_preview( NULL, NULL, NULL );
		update_all_views();
		if ( mem_img_bpp == 3 && mem_preview == 1 )	// Only do if toggle set
		{
			mask = malloc(mem_width);
			if (mask)
			{
				mask0 = NULL;
				tmp = mem_img[CHN_IMAGE];
				for (i = 0; i < mem_height; i++)
				{
					prep_mask(0, 1, mem_width, mask, mask0, tmp);
					do_transform(0, 1, mem_width, mask, tmp, tmp);
					if (mask0) mask0 += mem_width;
					tmp += mem_width * 3;
				}
				free(mask);
			}
		}

		if (widget)	// Don't do this when clicking OK
		{
			mem_pal_copy( brcosa_pal, mem_pal );
			click_brcosa_preview(NULL, NULL, NULL);
		}
	}

	return FALSE;
}

static gint click_brcosa_ok()
{
	click_brcosa_apply( NULL, NULL, NULL );
	delete_brcosa( NULL, NULL, NULL );

	return FALSE;
}

void pressed_brcosa( GtkMenuItem *menu_item, gpointer user_data )
{
	GtkWidget *vbox, *table2, *hbox, *button;

	static int mins[] = {-255, -100, -100, 1, 20, -1529},
		maxs[] = {255, 100, 100, 8, 500, 1529},
		order[] = {1, 2, 3, 5, 0, 4};
	char	txt[32],
		*tab_txt[] = {	_("Brightness"), _("Contrast"), _("Saturation"), _("Posterize"),
				_("Gamma"), _("Hue") };
	int i;

	GtkAccelGroup* ag = gtk_accel_group_new();

	mem_pal_copy( brcosa_pal, mem_pal );		// Remember original palette

	for ( i=0; i<BRCOSA_ITEMS; i++ ) mem_prev_bcsp[i] = brcosa_values_default[i];

	for ( i=0; i<4; i++ ) brcosa_buttons[i] = NULL;
			// Enables preview_toggle code to detect an initialisation call

	mem_preview = 1;		// If in RGB mode this is required to enable live preview

	brcosa_window = gtk_dialog_new();
	gtk_window_set_title( GTK_WINDOW(brcosa_window), _("Transform Colour") );
	gtk_window_set_position( GTK_WINDOW(brcosa_window), GTK_WIN_POS_MOUSE );
	gtk_window_set_decorated( GTK_WINDOW(brcosa_window), FALSE );
	gtk_window_set_modal(GTK_WINDOW(brcosa_window), TRUE);
	gtk_window_set_transient_for( GTK_WINDOW(brcosa_window), GTK_WINDOW(main_window) );

	vbox = GTK_DIALOG(brcosa_window)->vbox;

	table2 = add_a_table(6, 3, 10, vbox );
	for (i = 0; i < BRCOSA_ITEMS; i++)
	{
		add_to_table(tab_txt[i], table2, order[i], 0, 2);
		brcosa_values[i] = brcosa_values_default[i];
		brcosa_spins[i] = mt_spinslide_new(150, -2);
		gtk_table_attach(GTK_TABLE(table2), brcosa_spins[i], 1, 2,
			order[i], order[i] + 1, GTK_EXPAND | GTK_FILL,
			GTK_FILL, 0, 0);
		mt_spinslide_set_range(brcosa_spins[i], mins[i], maxs[i]);
		mt_spinslide_set_value(brcosa_spins[i], brcosa_values_default[i]);
		mt_spinslide_connect(brcosa_spins[i],
			GTK_SIGNAL_FUNC(brcosa_spinslide_moved), (gpointer)i);

		snprintf(txt, 30, "%i", brcosa_values_default[i]);
		brcosa_number_labels[i] = add_to_table(txt, table2, order[i], 2, 2);
		gtk_widget_set_usize(brcosa_number_labels[i], 32, -2);
	}

	brcosa_pal_lim[0] = 0;
	brcosa_pal_lim[1] = mem_cols-1;

///	BOTTOM AREA

	hbox = GTK_DIALOG(brcosa_window)->action_area;

	button = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
	gtk_widget_show( button );
	gtk_box_pack_start( GTK_BOX(hbox), button, TRUE, TRUE, 4 );

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(click_brcosa_cancel), NULL);
	gtk_signal_connect_object (GTK_OBJECT (brcosa_window), "delete_event",
		GTK_SIGNAL_FUNC (click_brcosa_cancel), NULL);
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_Escape, 0, (GtkAccelFlags) 0);
	brcosa_buttons[0] = button;

	button = gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_widget_show( button );
	gtk_box_pack_start( GTK_BOX(hbox), button, TRUE, TRUE, 4 );
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(click_brcosa_ok), NULL);
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_KP_Enter, 0, (GtkAccelFlags) 0);
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_Return, 0, (GtkAccelFlags) 0);
	brcosa_buttons[4] = button;

	gtk_widget_show (brcosa_window);
	gtk_window_add_accel_group(GTK_WINDOW (brcosa_window), ag);

	brcosa_buttons_sensitive();					// Disable buttons
}



void memory_errors(int type)
{
	if ( type == 1 )
		alert_box_stock(_("Error"), _("The operating system cannot allocate the memory for this operation."), GTK_STOCK_OK, NULL, NULL);
}


///	PALETTE EDITOR WINDOW

typedef struct {
	guint16 r, g, b, a;
} RGBA16;

static GtkWidget *allcol_window;//, *allcol_list;
static RGBA16 *ctable, new_col_rgb;
//static int allcol_idx;
static colour_hook allcol_hook;


static void allcol_ok(colour_hook chook)
{
	chook(2);
	gtk_widget_destroy(allcol_window);
	free(ctable);
	mem_pal_copy( mem_pal_def, mem_pal );

	mem_col_A24.red   = mem_pal[mem_col_A].red   = new_col_rgb.r;
	mem_col_A24.green = mem_pal[mem_col_A].green = new_col_rgb.g;
	mem_col_A24.blue  = mem_pal[mem_col_A].blue  = new_col_rgb.b;

	mem_col_B24 = mem_col_A24;

	toolbar_palette_refresh();
}

static gboolean allcol_cancel(colour_hook chook)
{
	chook(0);
	gtk_widget_destroy(allcol_window);
	free(ctable);
	return (FALSE);
}

/*
static gboolean color_expose( GtkWidget *widget, GdkEventExpose *event, gpointer user_data )
{
	RGBA16 *cc = user_data;
	unsigned char r = cc->r / 257, g = cc->g / 257, b = cc->b / 257, *rgb;
	int x = event->area.x, y = event->area.y, w = event->area.width, h = event->area.height;
	int i, j = w * h * 3;

	rgb = malloc(j);
	if (rgb)
	{
		for (i = 0; i < j; i += 3)
		{
			rgb[i] = r;
			rgb[i + 1] = g;
			rgb[i + 2] = b;
		}
		gdk_draw_rgb_image( widget->window, widget->style->black_gc, x, y, w, h, GDK_RGB_DITHER_NONE, rgb, w*3 );
		free(rgb);
	}

	return FALSE;
}
*/


static void color_set( GtkColorSelection *selection, gpointer user_data )
{
	gdouble color[4];
//	GtkWidget *widget;
//	RGBA16 *cc;
//	GdkColor c;


	gtk_color_selection_get_color( selection, color );

	new_col_rgb.r = rint(color[0] * 255.0);
	new_col_rgb.g = rint(color[1] * 255.0);
	new_col_rgb.b = rint(color[2] * 255.0);

//printf("new rgb = %d %d %d\n", new_col_rgb.r, new_col_rgb.g, new_col_rgb.b );

/*
	widget = GTK_WIDGET(gtk_object_get_user_data(GTK_OBJECT(selection)));

	cc = gtk_object_get_user_data(GTK_OBJECT(widget));
	cc->r = rint(color[0] * 65535.0);
	cc->g = rint(color[1] * 65535.0);
	cc->b = rint(color[2] * 65535.0);
	cc->a = rint(color[3] * 65535.0);
	c.pixel = 0;
	c.red   = cc->r;
	c.green = cc->g;
	c.blue  = cc->b;
	gdk_colormap_alloc_color( gdk_colormap_get_system(), &c, FALSE, TRUE );
	gtk_widget_queue_draw(widget);*/
	allcol_hook(4);
}

/*
static void color_select( GtkList *list, GtkWidget *widget, gpointer user_data )
{
	GtkColorSelection *cs = GTK_COLOR_SELECTION(user_data);
	RGBA16 *cc = gtk_object_get_user_data(GTK_OBJECT(widget));
	gdouble color[4];

	gtk_object_set_user_data( GTK_OBJECT(cs), widget );
	color[0] = ((gdouble)(cc->r)) / 65535.0;
	color[1] = ((gdouble)(cc->g)) / 65535.0;
	color[2] = ((gdouble)(cc->b)) / 65535.0;
	color[3] = ((gdouble)(cc->a)) / 65535.0;

	gtk_signal_disconnect_by_func(GTK_OBJECT(cs), GTK_SIGNAL_FUNC(color_set), NULL);

	gtk_color_selection_set_color( cs, color );

	GdkColor c = {0, cc->r, cc->g, cc->b};
	gtk_color_selection_set_previous_color(cs, &c);
	gtk_color_selection_set_previous_alpha(cs, cc->a);
	allcol_idx = cc - ctable;

	gtk_signal_connect( GTK_OBJECT(cs), "color_changed", GTK_SIGNAL_FUNC(color_set), NULL );
	allcol_hook(3);
}
*/

static void colour_window(GtkWidget *win, GtkWidget *extbox, int cnt,
	char **cnames, int alpha, colour_hook chook, GtkSignalFunc lhook)
{
	GtkWidget *vbox, *hbox, *hbut, *button;
//	GtkWidget *col_list, *l_item, *hbox2, *label, *drw, *swindow, *viewport;
	GtkWidget *cs;
//	char txt[64], *tmp = txt;
//	int i;
	GdkColor c = {0, mem_col_A24.red*255, mem_col_A24.green*255, mem_col_A24.blue*255 };

	GtkAccelGroup* ag = gtk_accel_group_new();

	cs = gtk_color_selection_new();
	gtk_color_selection_set_has_opacity_control(GTK_COLOR_SELECTION(cs), alpha);
	gtk_color_selection_set_has_palette (GTK_COLOR_SELECTION(cs), FALSE);

	allcol_window = win;
	allcol_hook = chook;

	gtk_signal_connect_object(GTK_OBJECT(allcol_window), "delete_event",
		GTK_SIGNAL_FUNC(allcol_cancel), (gpointer)chook);

	vbox = GTK_DIALOG(win)->vbox;		// Get dialog vertical box area

	hbox = gtk_hbox_new( FALSE, 10 );
	gtk_widget_show( hbox );
	gtk_box_pack_start( GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

	gtk_color_selection_set_current_color(GTK_COLOR_SELECTION(cs), &c );
	gtk_color_selection_set_previous_color(GTK_COLOR_SELECTION(cs), &c);
/*
	swindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (swindow);
	gtk_box_pack_start (GTK_BOX (hbox), swindow, FALSE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swindow),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	viewport = gtk_viewport_new (NULL, NULL);
	gtk_widget_show(viewport);
	gtk_container_add (GTK_CONTAINER (swindow), viewport);

	allcol_idx = 0;
	allcol_list = col_list = gtk_list_new();
	gtk_signal_connect(GTK_OBJECT(col_list), "select_child",
		GTK_SIGNAL_FUNC(color_select), cs);
	gtk_list_set_selection_mode( GTK_LIST(col_list), GTK_SELECTION_BROWSE );
	gtk_container_add ( GTK_CONTAINER(viewport), col_list );
	gtk_widget_show( col_list );

	for (i = 0; i < TOTAL_PALETTE_BUTTONS; i++)
	{
		l_item = gtk_list_item_new();
		gtk_object_set_user_data( GTK_OBJECT(l_item), (gpointer)(&ctable[i]));
		if (lhook) gtk_signal_connect(GTK_OBJECT(l_item),
			"button_press_event", lhook, (gpointer)i);
		gtk_container_add( GTK_CONTAINER(col_list), l_item );
		gtk_widget_show( l_item );

		hbox2 = gtk_hbox_new( FALSE, 3 );
		gtk_widget_show( hbox2 );
		gtk_container_set_border_width( GTK_CONTAINER(hbox2), 3 );
		gtk_container_add( GTK_CONTAINER(l_item), hbox2 );

		drw = gtk_drawing_area_new();
		gtk_drawing_area_size( GTK_DRAWING_AREA(drw), 20, 20 );
		gtk_signal_connect(GTK_OBJECT(drw), "expose_event",
			GTK_SIGNAL_FUNC(color_expose), (gpointer)(&ctable[i]));
		gtk_box_pack_start( GTK_BOX(hbox2), drw, FALSE, FALSE, 0 );
		gtk_widget_show( drw );

		if (cnames) tmp = cnames[i];
		else sprintf(txt, "%i", i);
		label = gtk_label_new(tmp);
		gtk_widget_show( label );
		gtk_misc_set_alignment( GTK_MISC(label), 0.0, 1.0 );
		gtk_box_pack_start( GTK_BOX(hbox2), label, TRUE, TRUE, 0 );
	}
*/
	gtk_signal_connect( GTK_OBJECT(cs), "color_changed", GTK_SIGNAL_FUNC(color_set), NULL );

	gtk_box_pack_start( GTK_BOX(hbox), cs, TRUE, TRUE, 0 );

	hbut = GTK_DIALOG(win)->action_area;		// Get dialog horizontal button area

	button = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
	gtk_widget_show( button );
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_Escape, 0, (GtkAccelFlags) 0);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(allcol_cancel), (gpointer)chook);
	gtk_box_pack_end( GTK_BOX(hbut), button, FALSE, FALSE, 5 );
	gtk_widget_set_usize(button, 100, -2);

	button = gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_widget_show( button );
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_KP_Enter, 0, (GtkAccelFlags) 0);
	gtk_widget_add_accelerator (button, "clicked", ag, GDK_Return, 0, (GtkAccelFlags) 0);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(allcol_ok), (gpointer)chook);
	gtk_box_pack_end( GTK_BOX(hbut), button, FALSE, FALSE, 5 );
	gtk_widget_set_usize(button, 100, -2);

	gtk_widget_show( cs );
	gtk_window_set_transient_for( GTK_WINDOW(allcol_window), GTK_WINDOW(main_window) );
	gtk_widget_show( allcol_window );
	gtk_window_add_accel_group( GTK_WINDOW(allcol_window), ag );
}

static void do_allcol()
{
	int i;

	for (i = 0; i < mem_cols; i++)
	{
		mem_pal[i].red = (ctable[i].r + 128) / 257;
		mem_pal[i].green = (ctable[i].g + 128) / 257;
		mem_pal[i].blue = (ctable[i].b + 128) / 257;
	}

	init_pal();
	update_all_views();
}

static void select_colour(int what)
{
	switch (what)
	{
	case 0: // Cancel
		mem_pal_copy(mem_pal, brcosa_pal);
		pal_refresher();
		break;
	case 2: // OK
		mem_pal_copy(mem_pal, brcosa_pal);
		pal_refresher();
		do_allcol();
	}
}

gint pressed_allcol( GtkMenuItem *menu_item, gpointer user_data )	// Bring up GTK+ colour wheel
{
	GtkWidget *win;
	int i;

	mem_pal_copy( brcosa_pal, mem_pal );	// Remember old settings
	ctable = malloc(TOTAL_PALETTE_BUTTONS * sizeof(RGBA16));
	if (!ctable) return FALSE;
	for (i = 0; i < TOTAL_PALETTE_BUTTONS; i++)
	{
		ctable[i].r = mem_pal[i].red * 257;
		ctable[i].g = mem_pal[i].green * 257;
		ctable[i].b = mem_pal[i].blue * 257;
		ctable[i].a = 65535;
	}

	win = gtk_dialog_new();
	gtk_window_set_title( GTK_WINDOW(win), _("Colour Editor") );
	gtk_window_set_modal(GTK_WINDOW(win), TRUE);

	colour_window(win, NULL, mem_cols, NULL, FALSE, select_colour, NULL);

	return FALSE;
}

