2.2 Opciones Synth 

# Opciones Synth: Amp y Pan

Asimismo como Sonic Pi te permite controlar cuál nota tocar o cuál
sample disparar, también provee un completo rango de opciones para
pulir y controlar los sonidos. En este tutorial cubriremos muchos de estos
y exite una gran documentación para cada uno en el sistema de ayuda.
Sin embargo, por ahora introduciremos dos de los más útiles: *amplitude*
y *pan*. Miremos primero qué son las opciones.


## Opciones

Sonic Pi apoya la noción de optiones (opts, abreviando) para sus
sintetizadores. Opts son controles  que pasas a `pla` los cuales
modifican y controlan aspectos del sonido que oyes. Cada
sintetizador tiene su propio set de opts para sintonizar su sonido.
Sin embargo, hay sets comunes de opts que comparten muchos,
tales como `amp:` y opciones de envelopes (cubiertas en otra sección).

Las Opts tienen dos partes principales, su nombre (el nombre del control)
 y  su valor (el valor al que setearás el control). Por ejemplo, puedes
tener un control llamado 'cheese:' y querer setearlo con un valor de `1`.

Los opts se pasan a las llamadas a `play` por medio del uso de
una coma `,`  y después el nombre del opt, tal como `amp:` (no olvides
los dos puntos `:`) y después un espacio y el valor del opt. Ejemplo:

```
play 50, cheese: 1
```

(Nota que `cheese:` no es un opt válido, lo usamos sólo como ejemplo).

Puedes pasar múltiples opts por medio de comas que los separen:
```
play 50, cheese: 1, beans: 0.5
```

El orden de los opts no importa, el siguiente será igual al anterior:
```
play 50, beans: 0.5, cheese: 1
```

Si un Opt no es reconocido por el sintetizador, simplemente es
ignorado (como en el caso de `cheese` y `beans` ¡los cuales son
nombres ridículos, obviamente!)

Si accidentalemente utilizas el mismo opt dos veces con diferentes
valores, el último gana. Por ejemplo, `beans:` aquí tendrá el valor de
2 y no el de 0.5:

```
play 50, beans: 0.5, cheese: 3, eggs: 0.1, beans: 2
```

Muchas cosas en Sonic Pi aceptan opts, sòlo debes pasar tiempo
aprendiendo cómo usarlas e irás bien. Ejecutemos nuestro primer
opt: `amp:`.

## Amplitud

Amplitud es una representación computarizada del volumen de un sonido.
Una *alta amplitud produce un sonido de alto volumen* y *baja amplitud
produce sonido de bajo volumen*. Así como Sonic Pi utiliza números
para representar tonos y tiempos, usa números para representar la 
amplitud. Una amplitud de 0 es silencio (escucharás nada) y amplitud de 1
es volumen normal. Puedes utilizar volumen a amplitudes mayores a 2, 10,
100. Sin embargo, debes tener en cuenta que cuando la amplitud de todos
los sonidos se vuelve muy alta, Sonic Pi utiliza un compresor para asegurar
que no lleguen a tan alto que dañen tus oídos. Esto puede hacer que los 
sonidos sean extraños. Intenta con amplitudes bajas, por ejemplo en el
rango de 0 to 0.5 para evitar compresión.

## Amplifícalo!

Para cambiar la amplitud de un sonido, utiliza el opt
`amp:`. Por ejemplo, para tocar a la mitad de la amplitud, 0.5:

```
play 60, amp: 0.5
```

Para hacerlo al doble de amplitud 2:

```
play 60, amp: 2
```

El opt `amp:`  sólo modifica la llamada para el `play` al que 
está asociado. Así, en este ejemplo, la primera llamada para tocar
es a mitad de volumen y la segunda es a la predeterminada (1):

```
play 60, amp: 0.5
sleep 0.5
play 65
```

Por supuesto que puedes usar diferentes valores de `amp:` para
cada llamada a play:

```
play 50, amp: 0.1
sleep 0.25
play 55, amp: 0.2
sleep 0.25
play 57, amp: 0.4
sleep 0.25
play 62, amp: 1
```

## Paneo

Otro concepto divertido de usar es el paneo `pan:` el cual controla
el paneo de un sonido en estéreo. Paneando un sonido a la izquierda,
significa que lo escucharás en la bocina izquierda, paneándolo a la
derecha, significa que lo escucharás de la bocina derecha. Para 
nuestros valores, tenemos -1 para representar completamente a la 
izquierda, 0 para representar el centro y 1 para representar 
completamente a la derecha. Claro, eres libre de usar cualquier valor
en medio de -1 y 1 para controlar la posición exacta de tu sonido.

Toquemos un pitido desde la bocina izquierda:

```
play 60, pan: -1
```

ahora que salga de la bocina derecha:

```
play 60, pan: 1
```

Finalmente, pongámoslo de nuevo al centro (predeterminado):

```
play 60, pan: 0
```

¡Ahora diviértete cambiando las amplitudes y paneos de tus sonidos!
