3.5 Échantillons partiels

# Échantillons partiels

Cette section va conclure notre exploration du lecteur d'échantillons 
de Sonic Pi. Faisons un rapide résumé. Jusqu'à maintenant nous avons 
vu comment lire des échantillons :

```
sample :loop_amen
```

Nous avons ensuite vu comment changer la vitesse de lecture des 
échantillons en les jouant par exemple à moitié vitesse :

```
sample :loop_amen, rate: 0.5
```

Ensuite, nous avons vu comment nous pouvions obtenir une attaque 
progressive (faisons-le à moitié vitesse) :

```
sample :loop_amen, rate: 0.5, attack: 1
```

Nous avons aussi vu comment nous pouvions utiliser le début d'un 
échantillon de manière percussive en donnant à `sustain:` une valeur 
explicite et en assignant des valeurs faibles à la fois à `attack:` et 
à `release:` :

```
sample :loop_amen, rate: 2, attack: 0.01, sustain: 0, release: 0.35
```

Toutefois ne serait-il pas sympathique de ne pas avoir à toujours 
démarrer au début de l'échantillon ? Ne serait-ce pas également 
sympathique de ne pas avoir à finir toujours à la fin de l'échantillon ?

## Choix d'un point de départ

Il est possible de choisir un point arbitraire de départ dans 
l'échantillon au moyen d'une valeur comprise entre 0 et 1 où 0 est le 
début de l'échantillon et 1 la fin et 0.5 le milieu. Essayons de jouer 
seulement la dernière moitié de "Amen" :

```
sample :loop_amen, start: 0.5
```

Ou pour le dernier quart de l'échantillon :

```
sample :loop_amen, start: 0.75
```

## Choix d'un point de terminaison

De manière similaire, il est possible de choisir un point de 
terminaison arbitraire au moyen d'une valeur comprise entre 0 et 1. 
Terminons l'"Amen" à la moitié de son parcours :

```
sample :loop_amen, finish: 0.5
```

## Spécification du départ et de la terminaison

Bien sûr, nous pouvons combiner ces deux paramètres pour jouer 
des segments arbitraires. Comment jouer uniquement une petite section au 
milieu :

```
sample :loop_amen, start: 0.4, finish: 0.6
```

Que se passe-t-il si nous choisissons une position de départ 
postérieure au point de terminaison ?


```
sample :loop_amen, start: 0.6, finish: 0.4
```

Cool ! Ça joue à l'envers !

## Combinaison avec la vitesse

Nous pouvons combiner cette nouvelle possibilité avec l'ami `rate:` 
pour jouer des segments arbitraires. Par exemple, nous pouvons jouer une 
très petite section d'"Amen" très lentement :

```
sample :loop_amen, start: 0.5, finish: 0.7, rate: 0.2
```

## Combinaison avec les enveloppes

Finalement, nous pouvons combiner tout ceci avec nos enveloppes ADSR 
pour produire des résultats intéressants :

```
sample :loop_amen, start: 0.5, finish: 0.8, rate: -0.2, attack: 0.3, release: 1
```

Maintenant allez et jouez un moment en triturant les échantillons avec 
ces choses amusantes.
