8.4 Anneaux

# Anneaux

Un parcours circulaire intéressant sur les listes est fourni par les 
anneaux ("rings"). Si vous avez quelques connaissances en programmation, 
vous pourriez avoir eu affaire aux "ring buffers" ou aux "ring arrays". 
Ici, nous allons juste voir les "rings" - c'est court et simple.

Dans la section précédente sur les listes, nous avons vu comment nous 
pouvions aller en chercher des éléments en utilisant le mécanisme 
d'indexage :

```
puts [52, 55, 59][1]
```

Maintenant, qu'arrive-t-il si vous voulez l'index `100` ? Eh bien, 
c'est clair qu'il n'y a pas d'élément à l'index 100 puisque la liste 
ne contient que trois éléments. Alors Sonic Pi retournera `nil` (qui 
veut dire "rien").

Maintenant, imaginons que nous ayons un compteur tel que celui des temps 
musicaux et qui s'incrémente continuellement. Créons notre compteur 
et notre liste :

```
counter = 0
notes = [52, 55, 59]
```

Nous pouvons maintenant utiliser notre compteur pour accéder à une 
note de notre liste :

```
puts notes[counter]
```

Super, nous avons obtenu `52`. Maintenant, incrémentons notre compteur 
et obtenons une autre note :

```
counter = (inc counter)
puts notes[counter]
```

Super, nous obtenons maintenant `55` et si nous le faisons une nouvelle 
fois, nous obtenons `59`. Toutefois, si nous le faisons encore une 
nouvelle fois, nous allons nous trouver en dehors des nombres de notre 
liste et obtenir `nil`. Que faire si nous voulions juste boucler en 
revenant en arrière et recommencer au début de la liste ? C'est pour 
cela que les anneaux ("rings") sont faits.

## Création des anneaux

Nous pouvons créer des anneaux de deux façons. Ou bien nous utilisons la 
fonction `ring` avec les élements de l'anneau comme paramètres :

```
(ring 52, 55, 59)
```

Ou bien nous pouvons prendre une liste normale et la convertir en 
anneau en lui envoyant le message `.ring` :

```
[52, 55, 59].ring
```

## Indexation des anneaux

Une fois que nous avons un anneau, nous pouvons l'utiliser de la même 
manière que nous utiliserions une liste normale avec l'exception que 
nous pouvons utiliser des index négatifs ou des index qui sont plus 
grands que la taille de l'anneau, et ils vont boucler tout autour 
jusqu'à pointer sur un des éléments de l'anneau :

```
(ring 52, 55, 59)[0] #=> 52
(ring 52, 55, 59)[1] #=> 55
(ring 52, 55, 59)[2] #=> 59
(ring 52, 55, 59)[3] #=> 52
(ring 52, 55, 59)[-1] #=> 59
```

## Utilisation des anneaux

Mettons que nous utilisions une variable pour représenter le numéro de 
battement courant. Nous pouvons l'utiliser comme un index de notre 
anneau pour aller chercher les notes à jouer, ou les durées d'extinction
ou n'importe quelle chose utile que nous avons mémorisée dans notre 
anneau sans se préoccuper de la valeur du numéro de battement en cours.

## Les gammes et les accords sont des anneaux

Une chose utile à savoir est que les listes retournées par `scale` et 
`chord` sont aussi des anneaux et cela vous autorise à les accéder 
avec des valeurs d'index arbitraires.

## Constructeurs d'anneaux

En sus de `ring`, il y a un certain nombre de fonctions qui vous
construiront un anneau.

* `range` vous invite à spécifier un point de départ, un point de 
fin, et la taille du pas.
* `bools` vous permet d'utiliser des `1`s et `0`s pour représenter les 
booléens de manière condensée.
* `knit` vous permet de créer une séquence de valeurs dupliquées.
* `spread` crée un anneau de booléens avec une distribution euclidienne.

Jetez un œil à leur documentation respective pour plus d'information.

