/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHVIEWMODEL_H
#define _SC_LOGGRAPHVIEWMODEL_H

// sc
#include "sublib/TargetId.h"
#include "svn/LogEntryTypes.h"
#include "svn/svn.h"
#include "util/String.h"
class DiffViewModel;
class ScModel;
class Bookmark;
class LogGraphParam;
namespace sc {
  class Error;
}
namespace svn {
  class Revision;
}

// qt
#include <QtCore/QObject>

// sys
#include <vector>


class LogGraphSelectionItem
{
public:
  sc::String     _path;
  svn::Revision* _rev;
};

typedef std::vector<LogGraphSelectionItem> LogGraphSelection;


class LogGraphViewModel : public QObject, public TargetId
{
  typedef QObject super;
   Q_OBJECT;

public:
  LogGraphViewModel( const sc::String& name, bool dir, Bookmark* bm, ScModel* model );
  ~LogGraphViewModel();

  // QObject
  bool event( QEvent* e );

  const sc::String& getName() const;
  bool  isDir() const;

  const sc::String& getStartPath() const;
  const sc::String& getRootPath() const;
  svn::Revnumber getMaxRev() const;
  const svn::LogEntries& getLogEntries() const;
  void setSelection( const LogGraphSelection& sel );

  DiffViewModel* createDiffViewModel();

  // commands
public slots:
  void log();
  void logResult( LogGraphParam*, const sc::Error* );

signals:
  void graph();

private:
  sc::String        _name;
  bool              _dir;

  Bookmark*         _bookmark;
  ScModel*          _model;

  // state
  svn::LogEntries   _entries;
  sc::String        _startPath;
  sc::String        _rootPath;
  svn::Revnumber    _maxRev;

  LogGraphSelection _selection;
};

#endif // _SC_LOGGRAPHVIEWMODEL_H
