/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPVIEWTREEPROXYMODEL_H
#define _SC_RPVIEWTREEPROXYMODEL_H

// sc
#include "util/String.h"

// qt
#include <QtGui/QSortFilterProxyModel>

/**
 * Proxy model for WcViewTree.
 */
class RpViewTreeProxyModel : public QSortFilterProxyModel
{
  typedef QSortFilterProxyModel super;
  Q_OBJECT

public:
  RpViewTreeProxyModel();
  virtual ~RpViewTreeProxyModel();

  QVariant data( const QModelIndex& index, int role ) const;
  Qt::ItemFlags flags( const QModelIndex &index ) const;

  /** Filter @a sourceRow based on the current filter settings. */
  bool filterAcceptsRow( int sourceRow, const QModelIndex& sourceParent ) const;

  /** Compares the content of @a left and @a right index. */
  bool lessThan(const QModelIndex &left, const QModelIndex &right) const;

  /** Set the @a current dir. This is a filter settings. Any path requested 
   *  by calling data() will have it stripped from the path. */
  void setCurrentPath( const sc::String& current );

  bool canFetchMore( const QModelIndex& parent ) const;
  void fetchMore( const QModelIndex& parent );
  bool hasChildren( const QModelIndex& parent ) const;

private:
  sc::String  _current;      ///< the current dir.
};

#endif // _SC_RPVIEWTREEROXYMODEL_H
