/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * Update to VDK 0.5.0
 * by mm 12.13.1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef TABLES_H
#define TABLES_H
#include <vdk/vdkobj.h>
#include <vdk/widcontain.h>
/*!
  \class VDKTable
  \brief Provides a table widget
  \par EXAMPLES
  In ./testvdk/entrieswin.cc
 */
class VDKTable: public VDKObjectContainer
{
   
public:
  /*!
    Sets/gets spacing between columns
   */
  __rwproperty(VDKTable,int) ColSpacing;
  /*!
    Sets/gets spacing between rows
   */
  __rwproperty(VDKTable,int) RowSpacing;
  /*!
    Constructor
    \param owner
    \param rows row number
    \param cols columns number
    \param homogeneous if all cells share the same space
   */
  VDKTable(VDKForm* owner,int rows, int cols, int homogeneous = false);
  /*!
    Destructor
   */
  virtual ~VDKTable();
  /*!
    Attach an object to table usinf default attach parameters
    \param obj obejct to be attached
    \param left_attach cell
    \param right_attach cell
    \param top_attach cell
    \param bot_attach cell
   */
  virtual void Add(VDKObject* obj, 
	      int left_attach,
	      int right_attach,
	      int top_attach,
	      int bot_attach);
  /*!
    Simplified attaching using row,col coordinates, sets options
    for both row and column
    \param obj object to be attached
    \param row row coordinate
    \param cols column coordinate
    \param opt options, can be:
    \arg \b GTK_EXPAND
    \arg \b GTK_SHRINK
    \arg \b GTK_FILL
         (can be ored togheter)
    \param padding

   */
  void AddToCell(VDKObject* obj, 
		   int row, 
		   int col, 
		   int opt = int(GTK_FILL | GTK_EXPAND), 
		   int padding = 1);
  /*
    Extended attaching mode using all arguments provided by gtk+
    \param obj object to be attached
    \param l_a left attach
    \param r_a right attach
    \param t_a top attach
    \param b_a bottom attach
    \param x_o x options
    \param y_o y options
    \param x_p x padding
    \param y_p y padding
  */
  void AddExt(VDKObject* obj, 
	   int l_a, int r_a,
	   int t_a, int b_a,
	   int x_o = int(GTK_FILL | GTK_EXPAND),
	   int y_o = int(GTK_FILL | GTK_EXPAND),
	   int x_p = 0, int y_p = 0);

 void SetRowSpacing(int row, int spacing)
   { gtk_table_set_row_spacing(GTK_TABLE(widget),row,spacing); }
 void SetColSpacing(int col, int spacing)  
   { gtk_table_set_col_spacing(GTK_TABLE(widget),col,spacing); }
 void SetRowSpacings(int spacing)
   { gtk_table_set_row_spacings(GTK_TABLE(widget),spacing); }
 void SetColSpacings(int spacing)  
   { gtk_table_set_col_spacings(GTK_TABLE(widget),spacing); }
};
#endif
