#!/usr/bin/perl
# eastasia.pl: With Unicode 3.2 Unicode Consortium made 
# ftp://ftp.unicode.org/Public/MAPPINGS/EASTASIA
# obselete. This script tries to resurrect them.
# GNU (C) Gaspar Sinai <gsinai@yudit.org>
# Changes:
# o Removed KSC5601.TXT
#   According to Jungshik Shin <jshin@mailaps.org> 4 Apr 2002:
#   KSC5601.TXT in OBSOLETE/EASTASIA is NOT the mapping 
#   between Unicode and KS C 5601-1987 but the mapping 
#   between MS CP949 and Unicode.
# o Renamed OLD5601.TXT use KSC1001.TXT instead.
# o KSX1001.TXT - created by a different script.
# o JOHAB.TXT  - created by a different script.
#   According to Jungshik Shin <jshin@mailaps.org> 4 Apr 2002:
#   You can extract two different mappings between EUC-KR
#   and Unicode from CP949.TXT (in VENDORS/MICSFT/) and KOREAN.TXT
#   (in VENDORS/APPLE).  Just filter out non-EUC portion and keep EUC
#   codepoints only (that is, 0x00-0x7E for single byte characters and
#   [0xA1-0xFE][0xA1-0xFE] for double byte characters). If you want
#   the mapping KS X 1001 and Unicode, you can subtract 0x8080 from
#   codepoints of two byte characters in EUC-KR.  I've put them up at
#
#   http://jshin.net/faq/KSX1001.TXT.gz  (extracted from CP949.TXT)
#   http://jshin.net/faq/JOHAB.TXT.gz    (for Johab)
#
#       wget http://jshin.net/faq/KSX1001.TXT.gz
#        wget http://jshin.net/faq/JOHAB.TXT.gz
#        gunzip KSX1001.TXT.gz
#        mv KSX1001.TXT MAPPINGS
#        gunzip JOHAB.TXT.gz
#        mv JOHAB.TXT MAPPINGS

$dir="";
$strict=0;
while ($#ARGV>=0) {
  if ($ARGV[0] eq "--dir" && $#ARGV>0) {
    shift; $dir = shift;
  } elsif($ARGV[0] eq "--strict") {
     $strict = 1;
  } else {
    last;
  }
}
if ($dir eq "" || $#ARGV > 0) {
  print STDERR "usage: $0 [--strict] --dir directory [Uniha.txt]\n";
  print STDERR "       --strict  - do not patch original unicode file\n";
  print STDERR "       --dir  - directory to create files\n";
  print STDERR "creates: JIS0208.TXT JIS0212.TXT JIS0213-1.TXT JIS0213-2.TXT\n";
  exit (1);
}

%ADDJIS0208=();
%IGNOREJIS0208=();

die "$0: can not write JIS0208.TXT" unless (open (JIS0208, "| sort -k2 -o $dir/JIS0208.TXT"));
die "$0: can not write JIS0212.TXT" unless (open (JIS0212, "| sort -k1 -o $dir/JIS0212.TXT"));
die "$0: can not write JIS0213-1.TXT" unless (open (JIS02131, "| sort -k1 -o $dir/JIS0213-1.TXT"));
die "$0: can not write JIS0213-2.TXT" unless (open (JIS02132, "| sort -k1 -o $dir/JIS0213-2.TXT"));
print JIS0208 "#SJIS 00JISX0208 UNICODE\n";
print JIS0212 "#JISX0212 UNICODE\n";
print JIS02131 "#JISX0213-1 UNICODE\n";
print JIS02132 "#JISX0213-2 UNICODE\n";

%JIS208MAP={};
%JIS212MAP={};
%JIS2131MAP={};
%JIS2132MAP={};

$CURRENTMAP="";

#
# Add data first - override.
#
if ($strict == 0) {
  while (<DATA>)
  {
    chomp;
    if (/START (.*)/){
      $current=$1; next;
    }
    if (/END (.*)/){
      $current=""; next;
    }
    if ($current eq "JIS0208") {
       $line = $_; split; $JIS208MAP{hex($_[2])} = $_[1];
# To test missing ones.
#       $ADDJIS0208{hex($_[1])}=hex($_[2]);
       printf (JIS0208 "%s\n", $line);
    }
    if ($current eq "JIS0212") {
       $line = $_; split; $JIS212MAP{hex($_[1])} = $_[0];
       printf (JIS0212 "%s\n", $line);
    }
    if ($current eq "JIS02131") {
       $line = $_; split; $JIS2131MAP{hex($_[1])} = $_[0];
       $IGNOREJIS0208{hex($_[0])}=hex($_[1]);
       printf (JIS02131 "%s\n", $line);
    }
    if ($current eq "JIS02132") {
       $line = $_; split; $JIS2132MAP{hex($_[1])} = $_[0];
       printf (JIS02132 "%s\n", $line);
    }
  }
}

while (<>)
{
  # JIS0208  - print SJIS 
  if (/U\+([0-9a-zA-Z]+)[ \t]+kJis0[ \t]+(\d\d)(\d\d)/) {
    $unicode = $1;
    $jis = (($2 + 0x20) << 8) + $3 + 0x20;
    $sjis = &jis2sjis($jis);
    $pjis = sprintf ("0x%04X", $jis);
    if (defined ( $JIS208MAP{hex($unicode)})) {
      $def = $JIS208MAP{hex($unicode)};
      print STDERR "JIS0208 $unicode JIS:$pjis is JIS:$def - skipping...\n"; 
      next;
    }
    $JIS208MAP{hex($unicode)} = $pjis;
    printf (JIS0208 "0x%04X\t0x%04X\t0x%s\t# <CJK>\n", $sjis, $jis, $unicode);
    next;
  }
  if (/U\+([0-9a-zA-Z]+)[ \t]+kJis1[ \t]+(\d\d)(\d\d)/) {
    $unicode = $1;
    $jis = (($2 + 0x20) << 8) + $3 + 0x20;
    $pjis = sprintf ("0x%04X", $jis);
    if (defined ( $JIS212MAP{hex($unicode)})) {
      $def = $JIS212MAP{hex($unicode)};
      print STDERR "JIS0212 $unicode JIS:$pjis is JIS:$def - skipping...\n"; 
      next;
    }
    $JIS212MAP{hex($unicode)} = $pjis;
# To test
#    $ADDJIS0208{hex($pjis)}=hex($unicode);
    printf (JIS0212 "0x%04X\t0x%s\t# <CJK>\n", $jis, $unicode);
    next;
  }
  # men,ku.ten
  if (/U\+([0-9a-zA-Z]+)[ \t]+kJIS0213[ \t]+(\d+),(\d+),(\d+)/) {
    $unicode = $1;
    $men = $2;
    $jis = (($3 + 0x20) << 8) + $4 + 0x20;
    $pjis = sprintf ("0x%04X", $jis);
    if ($men == 1 && defined ( $JIS2131MAP{hex($unicode)})) {
      $def = $JIS2131MAP{hex($unicode)};
      print STDERR "JIS02131 $unicode JIS:$pjis is JIS:$def - skipping...\n"; 
      next;
    }
    if ($men == 2 && defined ( $JIS2132MAP{hex($unicode)})) {
      $def = $JIS2132MAP{hex($unicode)};
      print STDERR "JIS02132 $unicode JIS:$pjis is JIS:$def - skipping...\n"; 
      next;
    }
    if ($men==1)
    {
      $JIS2131MAP{hex($unicode)} = $pjis;
      $IGNOREJIS0208{hex($pjis)}=hex($unicode);
      printf (JIS02131 "0x%04X\t0x%s\n", $jis, $unicode);
    }
    elsif ($men==2)
    {
      $JIS2132MAP{hex($unicode)} = $pjis;
      printf (JIS02132 "0x%04X\t0x%s\n", $jis, $unicode);
    }
    else
    {
      die "JISX0213 BAD MEN: $men at $.";
    }
    next;
  }
}

@k = keys (%ADDJIS0208);
#
# Add missing ones from JIS0208
#
for(@k) {
 if (defined $IGNOREJIS0208 {$_}) {
   printf STDERR ("REDEFINED JIS:%04X JISX0208 for JIX0213 [U+%04X -> U+%04X]\n",
        $_, $ADDJIS0208{$_}, $IGNOREJIS0208{$_});
   next;
 }
 printf (JIS02131 "0x%04X\t0x%04X\n", $_, $ADDJIS0208{$_});
}

close (JIS0208);
close (JIS0212);
close (JIS02131);
close (JIS02132);

exit (0);

sub jis2sjis
{
  my $jis = @_[0];
  my $c1 = $jis >> 8;
  my $c2 = $jis & 0xff;
  
  my $rowOffset =  ($c1 < 95) ? 112 : 176;
  my $cellOffset = $c1 % 2 ? ($c2 > 95 ? 32 : 31 ) : 126;
  $c1 = (($c1+1) >> 1) + $rowOffset;
  $c2 = $c2 + $cellOffset;
  if ( (($c1 >= 0x81 && $c1 <= 0x9f) || ($c1 >= 0xe0 &&  $c1 <= 0xef))
   && (($c2 >= 0x40 && $c2 <= 0x7e) || ($c2 >= 0x80 && $c2 <= 0xfc)) )
  {
    return (($c1 << 8) + $c2);
  }
  return 0;
}

#
# The following data should be added to the stream
#
__DATA__
START JIS0208
0x8140	0x2121	0x3000	# IDEOGRAPHIC SPACE
0x8141	0x2122	0x3001	# IDEOGRAPHIC COMMA
0x8142	0x2123	0x3002	# IDEOGRAPHIC FULL STOP
0x8143	0x2124	0xFF0C	# FULLWIDTH COMMA
0x8144	0x2125	0xFF0E	# FULLWIDTH FULL STOP
0x8145	0x2126	0x30FB	# KATAKANA MIDDLE DOT
0x8146	0x2127	0xFF1A	# FULLWIDTH COLON
0x8147	0x2128	0xFF1B	# FULLWIDTH SEMICOLON
0x8148	0x2129	0xFF1F	# FULLWIDTH QUESTION MARK
0x8149	0x212A	0xFF01	# FULLWIDTH EXCLAMATION MARK
0x814A	0x212B	0x309B	# KATAKANA-HIRAGANA VOICED SOUND MARK
0x814B	0x212C	0x309C	# KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
0x814C	0x212D	0x00B4	# ACUTE ACCENT
0x814D	0x212E	0xFF40	# FULLWIDTH GRAVE ACCENT
0x814E	0x212F	0x00A8	# DIAERESIS
0x814F	0x2130	0xFF3E	# FULLWIDTH CIRCUMFLEX ACCENT
0x8150	0x2131	0xFFE3	# FULLWIDTH MACRON
0x8151	0x2132	0xFF3F	# FULLWIDTH LOW LINE
0x8152	0x2133	0x30FD	# KATAKANA ITERATION MARK
0x8153	0x2134	0x30FE	# KATAKANA VOICED ITERATION MARK
0x8154	0x2135	0x309D	# HIRAGANA ITERATION MARK
0x8155	0x2136	0x309E	# HIRAGANA VOICED ITERATION MARK
0x8156	0x2137	0x3003	# DITTO MARK
#
0x8158	0x2139	0x3005	# IDEOGRAPHIC ITERATION MARK
0x8159	0x213A	0x3006	# IDEOGRAPHIC CLOSING MARK
0x815A	0x213B	0x3007	# IDEOGRAPHIC NUMBER ZERO
0x815B	0x213C	0x30FC	# KATAKANA-HIRAGANA PROLONGED SOUND MARK
0x815C	0x213D	0x2015	# HORIZONTAL BAR
0x815D	0x213E	0x2010	# HYPHEN
0x815E	0x213F	0xFF0F	# FULLWIDTH SOLIDUS
0x815F	0x2140	0x005C	# REVERSE SOLIDUS
0x8160	0x2141	0x301C	# WAVE DASH
0x8161	0x2142	0x2016	# DOUBLE VERTICAL LINE
0x8162	0x2143	0xFF5C	# FULLWIDTH VERTICAL LINE
0x8163	0x2144	0x2026	# HORIZONTAL ELLIPSIS
0x8164	0x2145	0x2025	# TWO DOT LEADER
0x8165	0x2146	0x2018	# LEFT SINGLE QUOTATION MARK
0x8166	0x2147	0x2019	# RIGHT SINGLE QUOTATION MARK
0x8167	0x2148	0x201C	# LEFT DOUBLE QUOTATION MARK
0x8168	0x2149	0x201D	# RIGHT DOUBLE QUOTATION MARK
0x8169	0x214A	0xFF08	# FULLWIDTH LEFT PARENTHESIS
0x816A	0x214B	0xFF09	# FULLWIDTH RIGHT PARENTHESIS
0x816B	0x214C	0x3014	# LEFT TORTOISE SHELL BRACKET
0x816C	0x214D	0x3015	# RIGHT TORTOISE SHELL BRACKET
0x816D	0x214E	0xFF3B	# FULLWIDTH LEFT SQUARE BRACKET
0x816E	0x214F	0xFF3D	# FULLWIDTH RIGHT SQUARE BRACKET
0x816F	0x2150	0xFF5B	# FULLWIDTH LEFT CURLY BRACKET
0x8170	0x2151	0xFF5D	# FULLWIDTH RIGHT CURLY BRACKET
0x8171	0x2152	0x3008	# LEFT ANGLE BRACKET
0x8172	0x2153	0x3009	# RIGHT ANGLE BRACKET
0x8173	0x2154	0x300A	# LEFT DOUBLE ANGLE BRACKET
0x8174	0x2155	0x300B	# RIGHT DOUBLE ANGLE BRACKET
0x8175	0x2156	0x300C	# LEFT CORNER BRACKET
0x8176	0x2157	0x300D	# RIGHT CORNER BRACKET
0x8177	0x2158	0x300E	# LEFT WHITE CORNER BRACKET
0x8178	0x2159	0x300F	# RIGHT WHITE CORNER BRACKET
0x8179	0x215A	0x3010	# LEFT BLACK LENTICULAR BRACKET
0x817A	0x215B	0x3011	# RIGHT BLACK LENTICULAR BRACKET
0x817B	0x215C	0xFF0B	# FULLWIDTH PLUS SIGN
0x817C	0x215D	0x2212	# MINUS SIGN
0x817D	0x215E	0x00B1	# PLUS-MINUS SIGN
0x817E	0x215F	0x00D7	# MULTIPLICATION SIGN
0x8180	0x2160	0x00F7	# DIVISION SIGN
0x8181	0x2161	0xFF1D	# FULLWIDTH EQUALS SIGN
0x8182	0x2162	0x2260	# NOT EQUAL TO
0x8183	0x2163	0xFF1C	# FULLWIDTH LESS-THAN SIGN
0x8184	0x2164	0xFF1E	# FULLWIDTH GREATER-THAN SIGN
0x8185	0x2165	0x2266	# LESS-THAN OVER EQUAL TO
0x8186	0x2166	0x2267	# GREATER-THAN OVER EQUAL TO
0x8187	0x2167	0x221E	# INFINITY
0x8188	0x2168	0x2234	# THEREFORE
0x8189	0x2169	0x2642	# MALE SIGN
0x818A	0x216A	0x2640	# FEMALE SIGN
0x818B	0x216B	0x00B0	# DEGREE SIGN
0x818C	0x216C	0x2032	# PRIME
0x818D	0x216D	0x2033	# DOUBLE PRIME
0x818E	0x216E	0x2103	# DEGREE CELSIUS
0x818F	0x216F	0xFFE5	# FULLWIDTH YEN SIGN
0x8190	0x2170	0xFF04	# FULLWIDTH DOLLAR SIGN
0x8191	0x2171	0x00A2	# CENT SIGN
0x8192	0x2172	0x00A3	# POUND SIGN
0x8193	0x2173	0xFF05	# FULLWIDTH PERCENT SIGN
0x8194	0x2174	0xFF03	# FULLWIDTH NUMBER SIGN
0x8195	0x2175	0xFF06	# FULLWIDTH AMPERSAND
0x8196	0x2176	0xFF0A	# FULLWIDTH ASTERISK
0x8197	0x2177	0xFF20	# FULLWIDTH COMMERCIAL AT
0x8198	0x2178	0x00A7	# SECTION SIGN
0x8199	0x2179	0x2606	# WHITE STAR
0x819A	0x217A	0x2605	# BLACK STAR
0x819B	0x217B	0x25CB	# WHITE CIRCLE
0x819C	0x217C	0x25CF	# BLACK CIRCLE
0x819D	0x217D	0x25CE	# BULLSEYE
0x819E	0x217E	0x25C7	# WHITE DIAMOND
0x819F	0x2221	0x25C6	# BLACK DIAMOND
0x81A0	0x2222	0x25A1	# WHITE SQUARE
0x81A1	0x2223	0x25A0	# BLACK SQUARE
0x81A2	0x2224	0x25B3	# WHITE UP-POINTING TRIANGLE
0x81A3	0x2225	0x25B2	# BLACK UP-POINTING TRIANGLE
0x81A4	0x2226	0x25BD	# WHITE DOWN-POINTING TRIANGLE
0x81A5	0x2227	0x25BC	# BLACK DOWN-POINTING TRIANGLE
0x81A6	0x2228	0x203B	# REFERENCE MARK
0x81A7	0x2229	0x3012	# POSTAL MARK
0x81A8	0x222A	0x2192	# RIGHTWARDS ARROW
0x81A9	0x222B	0x2190	# LEFTWARDS ARROW
0x81AA	0x222C	0x2191	# UPWARDS ARROW
0x81AB	0x222D	0x2193	# DOWNWARDS ARROW
0x81AC	0x222E	0x3013	# GETA MARK
0x81B8	0x223A	0x2208	# ELEMENT OF
0x81B9	0x223B	0x220B	# CONTAINS AS MEMBER
0x81BA	0x223C	0x2286	# SUBSET OF OR EQUAL TO
0x81BB	0x223D	0x2287	# SUPERSET OF OR EQUAL TO
0x81BC	0x223E	0x2282	# SUBSET OF
0x81BD	0x223F	0x2283	# SUPERSET OF
0x81BE	0x2240	0x222A	# UNION
0x81BF	0x2241	0x2229	# INTERSECTION
0x81C8	0x224A	0x2227	# LOGICAL AND
0x81C9	0x224B	0x2228	# LOGICAL OR
0x81CA	0x224C	0x00AC	# NOT SIGN
0x81CB	0x224D	0x21D2	# RIGHTWARDS DOUBLE ARROW
0x81CC	0x224E	0x21D4	# LEFT RIGHT DOUBLE ARROW
0x81CD	0x224F	0x2200	# FOR ALL
0x81CE	0x2250	0x2203	# THERE EXISTS
0x81DA	0x225C	0x2220	# ANGLE
0x81DB	0x225D	0x22A5	# UP TACK
0x81DC	0x225E	0x2312	# ARC
0x81DD	0x225F	0x2202	# PARTIAL DIFFERENTIAL
0x81DE	0x2260	0x2207	# NABLA
0x81DF	0x2261	0x2261	# IDENTICAL TO
0x81E0	0x2262	0x2252	# APPROXIMATELY EQUAL TO OR THE IMAGE OF
0x81E1	0x2263	0x226A	# MUCH LESS-THAN
0x81E2	0x2264	0x226B	# MUCH GREATER-THAN
0x81E3	0x2265	0x221A	# SQUARE ROOT
0x81E4	0x2266	0x223D	# REVERSED TILDE
0x81E5	0x2267	0x221D	# PROPORTIONAL TO
0x81E6	0x2268	0x2235	# BECAUSE
0x81E7	0x2269	0x222B	# INTEGRAL
0x81E8	0x226A	0x222C	# DOUBLE INTEGRAL
0x81F0	0x2272	0x212B	# ANGSTROM SIGN
0x81F1	0x2273	0x2030	# PER MILLE SIGN
0x81F2	0x2274	0x266F	# MUSIC SHARP SIGN
0x81F3	0x2275	0x266D	# MUSIC FLAT SIGN
0x81F4	0x2276	0x266A	# EIGHTH NOTE
0x81F5	0x2277	0x2020	# DAGGER
0x81F6	0x2278	0x2021	# DOUBLE DAGGER
0x81F7	0x2279	0x00B6	# PILCROW SIGN
0x81FC	0x227E	0x25EF	# LARGE CIRCLE
0x824F	0x2330	0xFF10	# FULLWIDTH DIGIT ZERO
0x8250	0x2331	0xFF11	# FULLWIDTH DIGIT ONE
0x8251	0x2332	0xFF12	# FULLWIDTH DIGIT TWO
0x8252	0x2333	0xFF13	# FULLWIDTH DIGIT THREE
0x8253	0x2334	0xFF14	# FULLWIDTH DIGIT FOUR
0x8254	0x2335	0xFF15	# FULLWIDTH DIGIT FIVE
0x8255	0x2336	0xFF16	# FULLWIDTH DIGIT SIX
0x8256	0x2337	0xFF17	# FULLWIDTH DIGIT SEVEN
0x8257	0x2338	0xFF18	# FULLWIDTH DIGIT EIGHT
0x8258	0x2339	0xFF19	# FULLWIDTH DIGIT NINE
0x8260	0x2341	0xFF21	# FULLWIDTH LATIN CAPITAL LETTER A
0x8261	0x2342	0xFF22	# FULLWIDTH LATIN CAPITAL LETTER B
0x8262	0x2343	0xFF23	# FULLWIDTH LATIN CAPITAL LETTER C
0x8263	0x2344	0xFF24	# FULLWIDTH LATIN CAPITAL LETTER D
0x8264	0x2345	0xFF25	# FULLWIDTH LATIN CAPITAL LETTER E
0x8265	0x2346	0xFF26	# FULLWIDTH LATIN CAPITAL LETTER F
0x8266	0x2347	0xFF27	# FULLWIDTH LATIN CAPITAL LETTER G
0x8267	0x2348	0xFF28	# FULLWIDTH LATIN CAPITAL LETTER H
0x8268	0x2349	0xFF29	# FULLWIDTH LATIN CAPITAL LETTER I
0x8269	0x234A	0xFF2A	# FULLWIDTH LATIN CAPITAL LETTER J
0x826A	0x234B	0xFF2B	# FULLWIDTH LATIN CAPITAL LETTER K
0x826B	0x234C	0xFF2C	# FULLWIDTH LATIN CAPITAL LETTER L
0x826C	0x234D	0xFF2D	# FULLWIDTH LATIN CAPITAL LETTER M
0x826D	0x234E	0xFF2E	# FULLWIDTH LATIN CAPITAL LETTER N
0x826E	0x234F	0xFF2F	# FULLWIDTH LATIN CAPITAL LETTER O
0x826F	0x2350	0xFF30	# FULLWIDTH LATIN CAPITAL LETTER P
0x8270	0x2351	0xFF31	# FULLWIDTH LATIN CAPITAL LETTER Q
0x8271	0x2352	0xFF32	# FULLWIDTH LATIN CAPITAL LETTER R
0x8272	0x2353	0xFF33	# FULLWIDTH LATIN CAPITAL LETTER S
0x8273	0x2354	0xFF34	# FULLWIDTH LATIN CAPITAL LETTER T
0x8274	0x2355	0xFF35	# FULLWIDTH LATIN CAPITAL LETTER U
0x8275	0x2356	0xFF36	# FULLWIDTH LATIN CAPITAL LETTER V
0x8276	0x2357	0xFF37	# FULLWIDTH LATIN CAPITAL LETTER W
0x8277	0x2358	0xFF38	# FULLWIDTH LATIN CAPITAL LETTER X
0x8278	0x2359	0xFF39	# FULLWIDTH LATIN CAPITAL LETTER Y
0x8279	0x235A	0xFF3A	# FULLWIDTH LATIN CAPITAL LETTER Z
0x8281	0x2361	0xFF41	# FULLWIDTH LATIN SMALL LETTER A
0x8282	0x2362	0xFF42	# FULLWIDTH LATIN SMALL LETTER B
0x8283	0x2363	0xFF43	# FULLWIDTH LATIN SMALL LETTER C
0x8284	0x2364	0xFF44	# FULLWIDTH LATIN SMALL LETTER D
0x8285	0x2365	0xFF45	# FULLWIDTH LATIN SMALL LETTER E
0x8286	0x2366	0xFF46	# FULLWIDTH LATIN SMALL LETTER F
0x8287	0x2367	0xFF47	# FULLWIDTH LATIN SMALL LETTER G
0x8288	0x2368	0xFF48	# FULLWIDTH LATIN SMALL LETTER H
0x8289	0x2369	0xFF49	# FULLWIDTH LATIN SMALL LETTER I
0x828A	0x236A	0xFF4A	# FULLWIDTH LATIN SMALL LETTER J
0x828B	0x236B	0xFF4B	# FULLWIDTH LATIN SMALL LETTER K
0x828C	0x236C	0xFF4C	# FULLWIDTH LATIN SMALL LETTER L
0x828D	0x236D	0xFF4D	# FULLWIDTH LATIN SMALL LETTER M
0x828E	0x236E	0xFF4E	# FULLWIDTH LATIN SMALL LETTER N
0x828F	0x236F	0xFF4F	# FULLWIDTH LATIN SMALL LETTER O
0x8290	0x2370	0xFF50	# FULLWIDTH LATIN SMALL LETTER P
0x8291	0x2371	0xFF51	# FULLWIDTH LATIN SMALL LETTER Q
0x8292	0x2372	0xFF52	# FULLWIDTH LATIN SMALL LETTER R
0x8293	0x2373	0xFF53	# FULLWIDTH LATIN SMALL LETTER S
0x8294	0x2374	0xFF54	# FULLWIDTH LATIN SMALL LETTER T
0x8295	0x2375	0xFF55	# FULLWIDTH LATIN SMALL LETTER U
0x8296	0x2376	0xFF56	# FULLWIDTH LATIN SMALL LETTER V
0x8297	0x2377	0xFF57	# FULLWIDTH LATIN SMALL LETTER W
0x8298	0x2378	0xFF58	# FULLWIDTH LATIN SMALL LETTER X
0x8299	0x2379	0xFF59	# FULLWIDTH LATIN SMALL LETTER Y
0x829A	0x237A	0xFF5A	# FULLWIDTH LATIN SMALL LETTER Z
0x829F	0x2421	0x3041	# HIRAGANA LETTER SMALL A
0x82A0	0x2422	0x3042	# HIRAGANA LETTER A
0x82A1	0x2423	0x3043	# HIRAGANA LETTER SMALL I
0x82A2	0x2424	0x3044	# HIRAGANA LETTER I
0x82A3	0x2425	0x3045	# HIRAGANA LETTER SMALL U
0x82A4	0x2426	0x3046	# HIRAGANA LETTER U
0x82A5	0x2427	0x3047	# HIRAGANA LETTER SMALL E
0x82A6	0x2428	0x3048	# HIRAGANA LETTER E
0x82A7	0x2429	0x3049	# HIRAGANA LETTER SMALL O
0x82A8	0x242A	0x304A	# HIRAGANA LETTER O
0x82A9	0x242B	0x304B	# HIRAGANA LETTER KA
0x82AA	0x242C	0x304C	# HIRAGANA LETTER GA
0x82AB	0x242D	0x304D	# HIRAGANA LETTER KI
0x82AC	0x242E	0x304E	# HIRAGANA LETTER GI
0x82AD	0x242F	0x304F	# HIRAGANA LETTER KU
0x82AE	0x2430	0x3050	# HIRAGANA LETTER GU
0x82AF	0x2431	0x3051	# HIRAGANA LETTER KE
0x82B0	0x2432	0x3052	# HIRAGANA LETTER GE
0x82B1	0x2433	0x3053	# HIRAGANA LETTER KO
0x82B2	0x2434	0x3054	# HIRAGANA LETTER GO
0x82B3	0x2435	0x3055	# HIRAGANA LETTER SA
0x82B4	0x2436	0x3056	# HIRAGANA LETTER ZA
0x82B5	0x2437	0x3057	# HIRAGANA LETTER SI
0x82B6	0x2438	0x3058	# HIRAGANA LETTER ZI
0x82B7	0x2439	0x3059	# HIRAGANA LETTER SU
0x82B8	0x243A	0x305A	# HIRAGANA LETTER ZU
0x82B9	0x243B	0x305B	# HIRAGANA LETTER SE
0x82BA	0x243C	0x305C	# HIRAGANA LETTER ZE
0x82BB	0x243D	0x305D	# HIRAGANA LETTER SO
0x82BC	0x243E	0x305E	# HIRAGANA LETTER ZO
0x82BD	0x243F	0x305F	# HIRAGANA LETTER TA
0x82BE	0x2440	0x3060	# HIRAGANA LETTER DA
0x82BF	0x2441	0x3061	# HIRAGANA LETTER TI
0x82C0	0x2442	0x3062	# HIRAGANA LETTER DI
0x82C1	0x2443	0x3063	# HIRAGANA LETTER SMALL TU
0x82C2	0x2444	0x3064	# HIRAGANA LETTER TU
0x82C3	0x2445	0x3065	# HIRAGANA LETTER DU
0x82C4	0x2446	0x3066	# HIRAGANA LETTER TE
0x82C5	0x2447	0x3067	# HIRAGANA LETTER DE
0x82C6	0x2448	0x3068	# HIRAGANA LETTER TO
0x82C7	0x2449	0x3069	# HIRAGANA LETTER DO
0x82C8	0x244A	0x306A	# HIRAGANA LETTER NA
0x82C9	0x244B	0x306B	# HIRAGANA LETTER NI
0x82CA	0x244C	0x306C	# HIRAGANA LETTER NU
0x82CB	0x244D	0x306D	# HIRAGANA LETTER NE
0x82CC	0x244E	0x306E	# HIRAGANA LETTER NO
0x82CD	0x244F	0x306F	# HIRAGANA LETTER HA
0x82CE	0x2450	0x3070	# HIRAGANA LETTER BA
0x82CF	0x2451	0x3071	# HIRAGANA LETTER PA
0x82D0	0x2452	0x3072	# HIRAGANA LETTER HI
0x82D1	0x2453	0x3073	# HIRAGANA LETTER BI
0x82D2	0x2454	0x3074	# HIRAGANA LETTER PI
0x82D3	0x2455	0x3075	# HIRAGANA LETTER HU
0x82D4	0x2456	0x3076	# HIRAGANA LETTER BU
0x82D5	0x2457	0x3077	# HIRAGANA LETTER PU
0x82D6	0x2458	0x3078	# HIRAGANA LETTER HE
0x82D7	0x2459	0x3079	# HIRAGANA LETTER BE
0x82D8	0x245A	0x307A	# HIRAGANA LETTER PE
0x82D9	0x245B	0x307B	# HIRAGANA LETTER HO
0x82DA	0x245C	0x307C	# HIRAGANA LETTER BO
0x82DB	0x245D	0x307D	# HIRAGANA LETTER PO
0x82DC	0x245E	0x307E	# HIRAGANA LETTER MA
0x82DD	0x245F	0x307F	# HIRAGANA LETTER MI
0x82DE	0x2460	0x3080	# HIRAGANA LETTER MU
0x82DF	0x2461	0x3081	# HIRAGANA LETTER ME
0x82E0	0x2462	0x3082	# HIRAGANA LETTER MO
0x82E1	0x2463	0x3083	# HIRAGANA LETTER SMALL YA
0x82E2	0x2464	0x3084	# HIRAGANA LETTER YA
0x82E3	0x2465	0x3085	# HIRAGANA LETTER SMALL YU
0x82E4	0x2466	0x3086	# HIRAGANA LETTER YU
0x82E5	0x2467	0x3087	# HIRAGANA LETTER SMALL YO
0x82E6	0x2468	0x3088	# HIRAGANA LETTER YO
0x82E7	0x2469	0x3089	# HIRAGANA LETTER RA
0x82E8	0x246A	0x308A	# HIRAGANA LETTER RI
0x82E9	0x246B	0x308B	# HIRAGANA LETTER RU
0x82EA	0x246C	0x308C	# HIRAGANA LETTER RE
0x82EB	0x246D	0x308D	# HIRAGANA LETTER RO
0x82EC	0x246E	0x308E	# HIRAGANA LETTER SMALL WA
0x82ED	0x246F	0x308F	# HIRAGANA LETTER WA
0x82EE	0x2470	0x3090	# HIRAGANA LETTER WI
0x82EF	0x2471	0x3091	# HIRAGANA LETTER WE
0x82F0	0x2472	0x3092	# HIRAGANA LETTER WO
0x82F1	0x2473	0x3093	# HIRAGANA LETTER N
0x8340	0x2521	0x30A1	# KATAKANA LETTER SMALL A
0x8341	0x2522	0x30A2	# KATAKANA LETTER A
0x8342	0x2523	0x30A3	# KATAKANA LETTER SMALL I
0x8343	0x2524	0x30A4	# KATAKANA LETTER I
0x8344	0x2525	0x30A5	# KATAKANA LETTER SMALL U
0x8345	0x2526	0x30A6	# KATAKANA LETTER U
0x8346	0x2527	0x30A7	# KATAKANA LETTER SMALL E
0x8347	0x2528	0x30A8	# KATAKANA LETTER E
0x8348	0x2529	0x30A9	# KATAKANA LETTER SMALL O
0x8349	0x252A	0x30AA	# KATAKANA LETTER O
0x834A	0x252B	0x30AB	# KATAKANA LETTER KA
0x834B	0x252C	0x30AC	# KATAKANA LETTER GA
0x834C	0x252D	0x30AD	# KATAKANA LETTER KI
0x834D	0x252E	0x30AE	# KATAKANA LETTER GI
0x834E	0x252F	0x30AF	# KATAKANA LETTER KU
0x834F	0x2530	0x30B0	# KATAKANA LETTER GU
0x8350	0x2531	0x30B1	# KATAKANA LETTER KE
0x8351	0x2532	0x30B2	# KATAKANA LETTER GE
0x8352	0x2533	0x30B3	# KATAKANA LETTER KO
0x8353	0x2534	0x30B4	# KATAKANA LETTER GO
0x8354	0x2535	0x30B5	# KATAKANA LETTER SA
0x8355	0x2536	0x30B6	# KATAKANA LETTER ZA
0x8356	0x2537	0x30B7	# KATAKANA LETTER SI
0x8357	0x2538	0x30B8	# KATAKANA LETTER ZI
0x8358	0x2539	0x30B9	# KATAKANA LETTER SU
0x8359	0x253A	0x30BA	# KATAKANA LETTER ZU
0x835A	0x253B	0x30BB	# KATAKANA LETTER SE
0x835B	0x253C	0x30BC	# KATAKANA LETTER ZE
0x835C	0x253D	0x30BD	# KATAKANA LETTER SO
0x835D	0x253E	0x30BE	# KATAKANA LETTER ZO
0x835E	0x253F	0x30BF	# KATAKANA LETTER TA
0x835F	0x2540	0x30C0	# KATAKANA LETTER DA
0x8360	0x2541	0x30C1	# KATAKANA LETTER TI
0x8361	0x2542	0x30C2	# KATAKANA LETTER DI
0x8362	0x2543	0x30C3	# KATAKANA LETTER SMALL TU
0x8363	0x2544	0x30C4	# KATAKANA LETTER TU
0x8364	0x2545	0x30C5	# KATAKANA LETTER DU
0x8365	0x2546	0x30C6	# KATAKANA LETTER TE
0x8366	0x2547	0x30C7	# KATAKANA LETTER DE
0x8367	0x2548	0x30C8	# KATAKANA LETTER TO
0x8368	0x2549	0x30C9	# KATAKANA LETTER DO
0x8369	0x254A	0x30CA	# KATAKANA LETTER NA
0x836A	0x254B	0x30CB	# KATAKANA LETTER NI
0x836B	0x254C	0x30CC	# KATAKANA LETTER NU
0x836C	0x254D	0x30CD	# KATAKANA LETTER NE
0x836D	0x254E	0x30CE	# KATAKANA LETTER NO
0x836E	0x254F	0x30CF	# KATAKANA LETTER HA
0x836F	0x2550	0x30D0	# KATAKANA LETTER BA
0x8370	0x2551	0x30D1	# KATAKANA LETTER PA
0x8371	0x2552	0x30D2	# KATAKANA LETTER HI
0x8372	0x2553	0x30D3	# KATAKANA LETTER BI
0x8373	0x2554	0x30D4	# KATAKANA LETTER PI
0x8374	0x2555	0x30D5	# KATAKANA LETTER HU
0x8375	0x2556	0x30D6	# KATAKANA LETTER BU
0x8376	0x2557	0x30D7	# KATAKANA LETTER PU
0x8377	0x2558	0x30D8	# KATAKANA LETTER HE
0x8378	0x2559	0x30D9	# KATAKANA LETTER BE
0x8379	0x255A	0x30DA	# KATAKANA LETTER PE
0x837A	0x255B	0x30DB	# KATAKANA LETTER HO
0x837B	0x255C	0x30DC	# KATAKANA LETTER BO
0x837C	0x255D	0x30DD	# KATAKANA LETTER PO
0x837D	0x255E	0x30DE	# KATAKANA LETTER MA
0x837E	0x255F	0x30DF	# KATAKANA LETTER MI
0x8380	0x2560	0x30E0	# KATAKANA LETTER MU
0x8381	0x2561	0x30E1	# KATAKANA LETTER ME
0x8382	0x2562	0x30E2	# KATAKANA LETTER MO
0x8383	0x2563	0x30E3	# KATAKANA LETTER SMALL YA
0x8384	0x2564	0x30E4	# KATAKANA LETTER YA
0x8385	0x2565	0x30E5	# KATAKANA LETTER SMALL YU
0x8386	0x2566	0x30E6	# KATAKANA LETTER YU
0x8387	0x2567	0x30E7	# KATAKANA LETTER SMALL YO
0x8388	0x2568	0x30E8	# KATAKANA LETTER YO
0x8389	0x2569	0x30E9	# KATAKANA LETTER RA
0x838A	0x256A	0x30EA	# KATAKANA LETTER RI
0x838B	0x256B	0x30EB	# KATAKANA LETTER RU
0x838C	0x256C	0x30EC	# KATAKANA LETTER RE
0x838D	0x256D	0x30ED	# KATAKANA LETTER RO
0x838E	0x256E	0x30EE	# KATAKANA LETTER SMALL WA
0x838F	0x256F	0x30EF	# KATAKANA LETTER WA
0x8390	0x2570	0x30F0	# KATAKANA LETTER WI
0x8391	0x2571	0x30F1	# KATAKANA LETTER WE
0x8392	0x2572	0x30F2	# KATAKANA LETTER WO
0x8393	0x2573	0x30F3	# KATAKANA LETTER N
0x8394	0x2574	0x30F4	# KATAKANA LETTER VU
0x8395	0x2575	0x30F5	# KATAKANA LETTER SMALL KA
0x8396	0x2576	0x30F6	# KATAKANA LETTER SMALL KE
0x839F	0x2621	0x0391	# GREEK CAPITAL LETTER ALPHA
0x83A0	0x2622	0x0392	# GREEK CAPITAL LETTER BETA
0x83A1	0x2623	0x0393	# GREEK CAPITAL LETTER GAMMA
0x83A2	0x2624	0x0394	# GREEK CAPITAL LETTER DELTA
0x83A3	0x2625	0x0395	# GREEK CAPITAL LETTER EPSILON
0x83A4	0x2626	0x0396	# GREEK CAPITAL LETTER ZETA
0x83A5	0x2627	0x0397	# GREEK CAPITAL LETTER ETA
0x83A6	0x2628	0x0398	# GREEK CAPITAL LETTER THETA
0x83A7	0x2629	0x0399	# GREEK CAPITAL LETTER IOTA
0x83A8	0x262A	0x039A	# GREEK CAPITAL LETTER KAPPA
0x83A9	0x262B	0x039B	# GREEK CAPITAL LETTER LAMDA
0x83AA	0x262C	0x039C	# GREEK CAPITAL LETTER MU
0x83AB	0x262D	0x039D	# GREEK CAPITAL LETTER NU
0x83AC	0x262E	0x039E	# GREEK CAPITAL LETTER XI
0x83AD	0x262F	0x039F	# GREEK CAPITAL LETTER OMICRON
0x83AE	0x2630	0x03A0	# GREEK CAPITAL LETTER PI
0x83AF	0x2631	0x03A1	# GREEK CAPITAL LETTER RHO
0x83B0	0x2632	0x03A3	# GREEK CAPITAL LETTER SIGMA
0x83B1	0x2633	0x03A4	# GREEK CAPITAL LETTER TAU
0x83B2	0x2634	0x03A5	# GREEK CAPITAL LETTER UPSILON
0x83B3	0x2635	0x03A6	# GREEK CAPITAL LETTER PHI
0x83B4	0x2636	0x03A7	# GREEK CAPITAL LETTER CHI
0x83B5	0x2637	0x03A8	# GREEK CAPITAL LETTER PSI
0x83B6	0x2638	0x03A9	# GREEK CAPITAL LETTER OMEGA
0x83BF	0x2641	0x03B1	# GREEK SMALL LETTER ALPHA
0x83C0	0x2642	0x03B2	# GREEK SMALL LETTER BETA
0x83C1	0x2643	0x03B3	# GREEK SMALL LETTER GAMMA
0x83C2	0x2644	0x03B4	# GREEK SMALL LETTER DELTA
0x83C3	0x2645	0x03B5	# GREEK SMALL LETTER EPSILON
0x83C4	0x2646	0x03B6	# GREEK SMALL LETTER ZETA
0x83C5	0x2647	0x03B7	# GREEK SMALL LETTER ETA
0x83C6	0x2648	0x03B8	# GREEK SMALL LETTER THETA
0x83C7	0x2649	0x03B9	# GREEK SMALL LETTER IOTA
0x83C8	0x264A	0x03BA	# GREEK SMALL LETTER KAPPA
0x83C9	0x264B	0x03BB	# GREEK SMALL LETTER LAMDA
0x83CA	0x264C	0x03BC	# GREEK SMALL LETTER MU
0x83CB	0x264D	0x03BD	# GREEK SMALL LETTER NU
0x83CC	0x264E	0x03BE	# GREEK SMALL LETTER XI
0x83CD	0x264F	0x03BF	# GREEK SMALL LETTER OMICRON
0x83CE	0x2650	0x03C0	# GREEK SMALL LETTER PI
0x83CF	0x2651	0x03C1	# GREEK SMALL LETTER RHO
0x83D0	0x2652	0x03C3	# GREEK SMALL LETTER SIGMA
0x83D1	0x2653	0x03C4	# GREEK SMALL LETTER TAU
0x83D2	0x2654	0x03C5	# GREEK SMALL LETTER UPSILON
0x83D3	0x2655	0x03C6	# GREEK SMALL LETTER PHI
0x83D4	0x2656	0x03C7	# GREEK SMALL LETTER CHI
0x83D5	0x2657	0x03C8	# GREEK SMALL LETTER PSI
0x83D6	0x2658	0x03C9	# GREEK SMALL LETTER OMEGA
0x8440	0x2721	0x0410	# CYRILLIC CAPITAL LETTER A
0x8441	0x2722	0x0411	# CYRILLIC CAPITAL LETTER BE
0x8442	0x2723	0x0412	# CYRILLIC CAPITAL LETTER VE
0x8443	0x2724	0x0413	# CYRILLIC CAPITAL LETTER GHE
0x8444	0x2725	0x0414	# CYRILLIC CAPITAL LETTER DE
0x8445	0x2726	0x0415	# CYRILLIC CAPITAL LETTER IE
0x8446	0x2727	0x0401	# CYRILLIC CAPITAL LETTER IO
0x8447	0x2728	0x0416	# CYRILLIC CAPITAL LETTER ZHE
0x8448	0x2729	0x0417	# CYRILLIC CAPITAL LETTER ZE
0x8449	0x272A	0x0418	# CYRILLIC CAPITAL LETTER I
0x844A	0x272B	0x0419	# CYRILLIC CAPITAL LETTER SHORT I
0x844B	0x272C	0x041A	# CYRILLIC CAPITAL LETTER KA
0x844C	0x272D	0x041B	# CYRILLIC CAPITAL LETTER EL
0x844D	0x272E	0x041C	# CYRILLIC CAPITAL LETTER EM
0x844E	0x272F	0x041D	# CYRILLIC CAPITAL LETTER EN
0x844F	0x2730	0x041E	# CYRILLIC CAPITAL LETTER O
0x8450	0x2731	0x041F	# CYRILLIC CAPITAL LETTER PE
0x8451	0x2732	0x0420	# CYRILLIC CAPITAL LETTER ER
0x8452	0x2733	0x0421	# CYRILLIC CAPITAL LETTER ES
0x8453	0x2734	0x0422	# CYRILLIC CAPITAL LETTER TE
0x8454	0x2735	0x0423	# CYRILLIC CAPITAL LETTER U
0x8455	0x2736	0x0424	# CYRILLIC CAPITAL LETTER EF
0x8456	0x2737	0x0425	# CYRILLIC CAPITAL LETTER HA
0x8457	0x2738	0x0426	# CYRILLIC CAPITAL LETTER TSE
0x8458	0x2739	0x0427	# CYRILLIC CAPITAL LETTER CHE
0x8459	0x273A	0x0428	# CYRILLIC CAPITAL LETTER SHA
0x845A	0x273B	0x0429	# CYRILLIC CAPITAL LETTER SHCHA
0x845B	0x273C	0x042A	# CYRILLIC CAPITAL LETTER HARD SIGN
0x845C	0x273D	0x042B	# CYRILLIC CAPITAL LETTER YERU
0x845D	0x273E	0x042C	# CYRILLIC CAPITAL LETTER SOFT SIGN
0x845E	0x273F	0x042D	# CYRILLIC CAPITAL LETTER E
0x845F	0x2740	0x042E	# CYRILLIC CAPITAL LETTER YU
0x8460	0x2741	0x042F	# CYRILLIC CAPITAL LETTER YA
0x8470	0x2751	0x0430	# CYRILLIC SMALL LETTER A
0x8471	0x2752	0x0431	# CYRILLIC SMALL LETTER BE
0x8472	0x2753	0x0432	# CYRILLIC SMALL LETTER VE
0x8473	0x2754	0x0433	# CYRILLIC SMALL LETTER GHE
0x8474	0x2755	0x0434	# CYRILLIC SMALL LETTER DE
0x8475	0x2756	0x0435	# CYRILLIC SMALL LETTER IE
0x8476	0x2757	0x0451	# CYRILLIC SMALL LETTER IO
0x8477	0x2758	0x0436	# CYRILLIC SMALL LETTER ZHE
0x8478	0x2759	0x0437	# CYRILLIC SMALL LETTER ZE
0x8479	0x275A	0x0438	# CYRILLIC SMALL LETTER I
0x847A	0x275B	0x0439	# CYRILLIC SMALL LETTER SHORT I
0x847B	0x275C	0x043A	# CYRILLIC SMALL LETTER KA
0x847C	0x275D	0x043B	# CYRILLIC SMALL LETTER EL
0x847D	0x275E	0x043C	# CYRILLIC SMALL LETTER EM
0x847E	0x275F	0x043D	# CYRILLIC SMALL LETTER EN
0x8480	0x2760	0x043E	# CYRILLIC SMALL LETTER O
0x8481	0x2761	0x043F	# CYRILLIC SMALL LETTER PE
0x8482	0x2762	0x0440	# CYRILLIC SMALL LETTER ER
0x8483	0x2763	0x0441	# CYRILLIC SMALL LETTER ES
0x8484	0x2764	0x0442	# CYRILLIC SMALL LETTER TE
0x8485	0x2765	0x0443	# CYRILLIC SMALL LETTER U
0x8486	0x2766	0x0444	# CYRILLIC SMALL LETTER EF
0x8487	0x2767	0x0445	# CYRILLIC SMALL LETTER HA
0x8488	0x2768	0x0446	# CYRILLIC SMALL LETTER TSE
0x8489	0x2769	0x0447	# CYRILLIC SMALL LETTER CHE
0x848A	0x276A	0x0448	# CYRILLIC SMALL LETTER SHA
0x848B	0x276B	0x0449	# CYRILLIC SMALL LETTER SHCHA
0x848C	0x276C	0x044A	# CYRILLIC SMALL LETTER HARD SIGN
0x848D	0x276D	0x044B	# CYRILLIC SMALL LETTER YERU
0x848E	0x276E	0x044C	# CYRILLIC SMALL LETTER SOFT SIGN
0x848F	0x276F	0x044D	# CYRILLIC SMALL LETTER E
0x8490	0x2770	0x044E	# CYRILLIC SMALL LETTER YU
0x8491	0x2771	0x044F	# CYRILLIC SMALL LETTER YA
0x849F	0x2821	0x2500	# BOX DRAWINGS LIGHT HORIZONTAL
0x84A0	0x2822	0x2502	# BOX DRAWINGS LIGHT VERTICAL
0x84A1	0x2823	0x250C	# BOX DRAWINGS LIGHT DOWN AND RIGHT
0x84A2	0x2824	0x2510	# BOX DRAWINGS LIGHT DOWN AND LEFT
0x84A3	0x2825	0x2518	# BOX DRAWINGS LIGHT UP AND LEFT
0x84A4	0x2826	0x2514	# BOX DRAWINGS LIGHT UP AND RIGHT
0x84A5	0x2827	0x251C	# BOX DRAWINGS LIGHT VERTICAL AND RIGHT
0x84A6	0x2828	0x252C	# BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
0x84A7	0x2829	0x2524	# BOX DRAWINGS LIGHT VERTICAL AND LEFT
0x84A8	0x282A	0x2534	# BOX DRAWINGS LIGHT UP AND HORIZONTAL
0x84A9	0x282B	0x253C	# BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
0x84AA	0x282C	0x2501	# BOX DRAWINGS HEAVY HORIZONTAL
0x84AB	0x282D	0x2503	# BOX DRAWINGS HEAVY VERTICAL
0x84AC	0x282E	0x250F	# BOX DRAWINGS HEAVY DOWN AND RIGHT
0x84AD	0x282F	0x2513	# BOX DRAWINGS HEAVY DOWN AND LEFT
0x84AE	0x2830	0x251B	# BOX DRAWINGS HEAVY UP AND LEFT
0x84AF	0x2831	0x2517	# BOX DRAWINGS HEAVY UP AND RIGHT
0x84B0	0x2832	0x2523	# BOX DRAWINGS HEAVY VERTICAL AND RIGHT
0x84B1	0x2833	0x2533	# BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
0x84B2	0x2834	0x252B	# BOX DRAWINGS HEAVY VERTICAL AND LEFT
0x84B3	0x2835	0x253B	# BOX DRAWINGS HEAVY UP AND HORIZONTAL
0x84B4	0x2836	0x254B	# BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
0x84B5	0x2837	0x2520	# BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
0x84B6	0x2838	0x252F	# BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
0x84B7	0x2839	0x2528	# BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
0x84B8	0x283A	0x2537	# BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
0x84B9	0x283B	0x253F	# BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
0x84BA	0x283C	0x251D	# BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
0x84BB	0x283D	0x2530	# BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
0x84BC	0x283E	0x2525	# BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
0x84BD	0x283F	0x2538	# BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
0x84BE	0x2840	0x2542	# BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
END JIS0208
START JIS0212
0x222F	0x02D8	# BREVE
0x2230	0x02C7	# CARON (Mandarin Chinese third tone)
0x2231	0x00B8	# CEDILLA
0x2232	0x02D9	# DOT ABOVE (Mandarin Chinese light tone)
0x2233	0x02DD	# DOUBLE ACUTE ACCENT
0x2234	0x00AF	# MACRON
0x2235	0x02DB	# OGONEK
0x2236	0x02DA	# RING ABOVE
0x2237	0x007E	# TILDE
0x2238	0x0384	# GREEK TONOS
0x2239	0x0385	# GREEK DIALYTIKA TONOS
0x2242	0x00A1	# INVERTED EXCLAMATION MARK
0x2243	0x00A6	# BROKEN BAR
0x2244	0x00BF	# INVERTED QUESTION MARK
0x226B	0x00BA	# MASCULINE ORDINAL INDICATOR
0x226C	0x00AA	# FEMININE ORDINAL INDICATOR
0x226D	0x00A9	# COPYRIGHT SIGN
0x226E	0x00AE	# REGISTERED SIGN
0x226F	0x2122	# TRADE MARK SIGN
0x2270	0x00A4	# CURRENCY SIGN
0x2271	0x2116	# NUMERO SIGN
0x2661	0x0386	# GREEK CAPITAL LETTER ALPHA WITH TONOS
0x2662	0x0388	# GREEK CAPITAL LETTER EPSILON WITH TONOS
0x2663	0x0389	# GREEK CAPITAL LETTER ETA WITH TONOS
0x2664	0x038A	# GREEK CAPITAL LETTER IOTA WITH TONOS
0x2665	0x03AA	# GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
0x2667	0x038C	# GREEK CAPITAL LETTER OMICRON WITH TONOS
0x2669	0x038E	# GREEK CAPITAL LETTER UPSILON WITH TONOS
0x266A	0x03AB	# GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
0x266C	0x038F	# GREEK CAPITAL LETTER OMEGA WITH TONOS
0x2671	0x03AC	# GREEK SMALL LETTER ALPHA WITH TONOS
0x2672	0x03AD	# GREEK SMALL LETTER EPSILON WITH TONOS
0x2673	0x03AE	# GREEK SMALL LETTER ETA WITH TONOS
0x2674	0x03AF	# GREEK SMALL LETTER IOTA WITH TONOS
0x2675	0x03CA	# GREEK SMALL LETTER IOTA WITH DIALYTIKA
0x2676	0x0390	# GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
0x2677	0x03CC	# GREEK SMALL LETTER OMICRON WITH TONOS
0x2678	0x03C2	# GREEK SMALL LETTER FINAL SIGMA
0x2679	0x03CD	# GREEK SMALL LETTER UPSILON WITH TONOS
0x267A	0x03CB	# GREEK SMALL LETTER UPSILON WITH DIALYTIKA
0x267B	0x03B0	# GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
0x267C	0x03CE	# GREEK SMALL LETTER OMEGA WITH TONOS
0x2742	0x0402	# CYRILLIC CAPITAL LETTER DJE
0x2743	0x0403	# CYRILLIC CAPITAL LETTER GJE
0x2744	0x0404	# CYRILLIC CAPITAL LETTER UKRAINIAN IE
0x2745	0x0405	# CYRILLIC CAPITAL LETTER DZE
0x2746	0x0406	# CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
0x2747	0x0407	# CYRILLIC CAPITAL LETTER YI
0x2748	0x0408	# CYRILLIC CAPITAL LETTER JE
0x2749	0x0409	# CYRILLIC CAPITAL LETTER LJE
0x274A	0x040A	# CYRILLIC CAPITAL LETTER NJE
0x274B	0x040B	# CYRILLIC CAPITAL LETTER TSHE
0x274C	0x040C	# CYRILLIC CAPITAL LETTER KJE
0x274D	0x040E	# CYRILLIC CAPITAL LETTER SHORT U
0x274E	0x040F	# CYRILLIC CAPITAL LETTER DZHE
0x2772	0x0452	# CYRILLIC SMALL LETTER DJE
0x2773	0x0453	# CYRILLIC SMALL LETTER GJE
0x2774	0x0454	# CYRILLIC SMALL LETTER UKRAINIAN IE
0x2775	0x0455	# CYRILLIC SMALL LETTER DZE
0x2776	0x0456	# CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
0x2777	0x0457	# CYRILLIC SMALL LETTER YI
0x2778	0x0458	# CYRILLIC SMALL LETTER JE
0x2779	0x0459	# CYRILLIC SMALL LETTER LJE
0x277A	0x045A	# CYRILLIC SMALL LETTER NJE
0x277B	0x045B	# CYRILLIC SMALL LETTER TSHE
0x277C	0x045C	# CYRILLIC SMALL LETTER KJE
0x277D	0x045E	# CYRILLIC SMALL LETTER SHORT U
0x277E	0x045F	# CYRILLIC SMALL LETTER DZHE
0x2921	0x00C6	# LATIN CAPITAL LIGATURE AE
0x2922	0x0110	# LATIN CAPITAL LETTER D WITH STROKE
0x2924	0x0126	# LATIN CAPITAL LETTER H WITH STROKE
0x2926	0x0132	# LATIN CAPITAL LIGATURE IJ
0x2928	0x0141	# LATIN CAPITAL LETTER L WITH STROKE
0x2929	0x013F	# LATIN CAPITAL LETTER L WITH MIDDLE DOT
0x292B	0x014A	# LATIN CAPITAL LETTER ENG
0x292C	0x00D8	# LATIN CAPITAL LETTER O WITH STROKE
0x292D	0x0152	# LATIN CAPITAL LIGATURE OE
0x292F	0x0166	# LATIN CAPITAL LETTER T WITH STROKE
0x2930	0x00DE	# LATIN CAPITAL LETTER THORN
0x2941	0x00E6	# LATIN SMALL LIGATURE AE
0x2942	0x0111	# LATIN SMALL LETTER D WITH STROKE
0x2943	0x00F0	# LATIN SMALL LETTER ETH
0x2944	0x0127	# LATIN SMALL LETTER H WITH STROKE
0x2945	0x0131	# LATIN SMALL LETTER DOTLESS I
0x2946	0x0133	# LATIN SMALL LIGATURE IJ
0x2947	0x0138	# LATIN SMALL LETTER KRA
0x2948	0x0142	# LATIN SMALL LETTER L WITH STROKE
0x2949	0x0140	# LATIN SMALL LETTER L WITH MIDDLE DOT
0x294A	0x0149	# LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
0x294B	0x014B	# LATIN SMALL LETTER ENG
0x294C	0x00F8	# LATIN SMALL LETTER O WITH STROKE
0x294D	0x0153	# LATIN SMALL LIGATURE OE
0x294E	0x00DF	# LATIN SMALL LETTER SHARP S
0x294F	0x0167	# LATIN SMALL LETTER T WITH STROKE
0x2950	0x00FE	# LATIN SMALL LETTER THORN
0x2A21	0x00C1	# LATIN CAPITAL LETTER A WITH ACUTE
0x2A22	0x00C0	# LATIN CAPITAL LETTER A WITH GRAVE
0x2A23	0x00C4	# LATIN CAPITAL LETTER A WITH DIAERESIS
0x2A24	0x00C2	# LATIN CAPITAL LETTER A WITH CIRCUMFLEX
0x2A25	0x0102	# LATIN CAPITAL LETTER A WITH BREVE
0x2A26	0x01CD	# LATIN CAPITAL LETTER A WITH CARON
0x2A27	0x0100	# LATIN CAPITAL LETTER A WITH MACRON
0x2A28	0x0104	# LATIN CAPITAL LETTER A WITH OGONEK
0x2A29	0x00C5	# LATIN CAPITAL LETTER A WITH RING ABOVE
0x2A2A	0x00C3	# LATIN CAPITAL LETTER A WITH TILDE
0x2A2B	0x0106	# LATIN CAPITAL LETTER C WITH ACUTE
0x2A2C	0x0108	# LATIN CAPITAL LETTER C WITH CIRCUMFLEX
0x2A2D	0x010C	# LATIN CAPITAL LETTER C WITH CARON
0x2A2E	0x00C7	# LATIN CAPITAL LETTER C WITH CEDILLA
0x2A2F	0x010A	# LATIN CAPITAL LETTER C WITH DOT ABOVE
0x2A30	0x010E	# LATIN CAPITAL LETTER D WITH CARON
0x2A31	0x00C9	# LATIN CAPITAL LETTER E WITH ACUTE
0x2A32	0x00C8	# LATIN CAPITAL LETTER E WITH GRAVE
0x2A33	0x00CB	# LATIN CAPITAL LETTER E WITH DIAERESIS
0x2A34	0x00CA	# LATIN CAPITAL LETTER E WITH CIRCUMFLEX
0x2A35	0x011A	# LATIN CAPITAL LETTER E WITH CARON
0x2A36	0x0116	# LATIN CAPITAL LETTER E WITH DOT ABOVE
0x2A37	0x0112	# LATIN CAPITAL LETTER E WITH MACRON
0x2A38	0x0118	# LATIN CAPITAL LETTER E WITH OGONEK
0x2A3A	0x011C	# LATIN CAPITAL LETTER G WITH CIRCUMFLEX
0x2A3B	0x011E	# LATIN CAPITAL LETTER G WITH BREVE
0x2A3C	0x0122	# LATIN CAPITAL LETTER G WITH CEDILLA
0x2A3D	0x0120	# LATIN CAPITAL LETTER G WITH DOT ABOVE
0x2A3E	0x0124	# LATIN CAPITAL LETTER H WITH CIRCUMFLEX
0x2A3F	0x00CD	# LATIN CAPITAL LETTER I WITH ACUTE
0x2A40	0x00CC	# LATIN CAPITAL LETTER I WITH GRAVE
0x2A41	0x00CF	# LATIN CAPITAL LETTER I WITH DIAERESIS
0x2A42	0x00CE	# LATIN CAPITAL LETTER I WITH CIRCUMFLEX
0x2A43	0x01CF	# LATIN CAPITAL LETTER I WITH CARON
0x2A44	0x0130	# LATIN CAPITAL LETTER I WITH DOT ABOVE
0x2A45	0x012A	# LATIN CAPITAL LETTER I WITH MACRON
0x2A46	0x012E	# LATIN CAPITAL LETTER I WITH OGONEK
0x2A47	0x0128	# LATIN CAPITAL LETTER I WITH TILDE
0x2A48	0x0134	# LATIN CAPITAL LETTER J WITH CIRCUMFLEX
0x2A49	0x0136	# LATIN CAPITAL LETTER K WITH CEDILLA
0x2A4A	0x0139	# LATIN CAPITAL LETTER L WITH ACUTE
0x2A4B	0x013D	# LATIN CAPITAL LETTER L WITH CARON
0x2A4C	0x013B	# LATIN CAPITAL LETTER L WITH CEDILLA
0x2A4D	0x0143	# LATIN CAPITAL LETTER N WITH ACUTE
0x2A4E	0x0147	# LATIN CAPITAL LETTER N WITH CARON
0x2A4F	0x0145	# LATIN CAPITAL LETTER N WITH CEDILLA
0x2A50	0x00D1	# LATIN CAPITAL LETTER N WITH TILDE
0x2A51	0x00D3	# LATIN CAPITAL LETTER O WITH ACUTE
0x2A52	0x00D2	# LATIN CAPITAL LETTER O WITH GRAVE
0x2A53	0x00D6	# LATIN CAPITAL LETTER O WITH DIAERESIS
0x2A54	0x00D4	# LATIN CAPITAL LETTER O WITH CIRCUMFLEX
0x2A55	0x01D1	# LATIN CAPITAL LETTER O WITH CARON
0x2A56	0x0150	# LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
0x2A57	0x014C	# LATIN CAPITAL LETTER O WITH MACRON
0x2A58	0x00D5	# LATIN CAPITAL LETTER O WITH TILDE
0x2A59	0x0154	# LATIN CAPITAL LETTER R WITH ACUTE
0x2A5A	0x0158	# LATIN CAPITAL LETTER R WITH CARON
0x2A5B	0x0156	# LATIN CAPITAL LETTER R WITH CEDILLA
0x2A5C	0x015A	# LATIN CAPITAL LETTER S WITH ACUTE
0x2A5D	0x015C	# LATIN CAPITAL LETTER S WITH CIRCUMFLEX
0x2A5E	0x0160	# LATIN CAPITAL LETTER S WITH CARON
0x2A5F	0x015E	# LATIN CAPITAL LETTER S WITH CEDILLA
0x2A60	0x0164	# LATIN CAPITAL LETTER T WITH CARON
0x2A61	0x0162	# LATIN CAPITAL LETTER T WITH CEDILLA
0x2A62	0x00DA	# LATIN CAPITAL LETTER U WITH ACUTE
0x2A63	0x00D9	# LATIN CAPITAL LETTER U WITH GRAVE
0x2A64	0x00DC	# LATIN CAPITAL LETTER U WITH DIAERESIS
0x2A65	0x00DB	# LATIN CAPITAL LETTER U WITH CIRCUMFLEX
0x2A66	0x016C	# LATIN CAPITAL LETTER U WITH BREVE
0x2A67	0x01D3	# LATIN CAPITAL LETTER U WITH CARON
0x2A68	0x0170	# LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
0x2A69	0x016A	# LATIN CAPITAL LETTER U WITH MACRON
0x2A6A	0x0172	# LATIN CAPITAL LETTER U WITH OGONEK
0x2A6B	0x016E	# LATIN CAPITAL LETTER U WITH RING ABOVE
0x2A6C	0x0168	# LATIN CAPITAL LETTER U WITH TILDE
0x2A6D	0x01D7	# LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
0x2A6E	0x01DB	# LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
0x2A6F	0x01D9	# LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
0x2A70	0x01D5	# LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
0x2A71	0x0174	# LATIN CAPITAL LETTER W WITH CIRCUMFLEX
0x2A72	0x00DD	# LATIN CAPITAL LETTER Y WITH ACUTE
0x2A73	0x0178	# LATIN CAPITAL LETTER Y WITH DIAERESIS
0x2A74	0x0176	# LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
0x2A75	0x0179	# LATIN CAPITAL LETTER Z WITH ACUTE
0x2A76	0x017D	# LATIN CAPITAL LETTER Z WITH CARON
0x2A77	0x017B	# LATIN CAPITAL LETTER Z WITH DOT ABOVE
0x2B21	0x00E1	# LATIN SMALL LETTER A WITH ACUTE
0x2B22	0x00E0	# LATIN SMALL LETTER A WITH GRAVE
0x2B23	0x00E4	# LATIN SMALL LETTER A WITH DIAERESIS
0x2B24	0x00E2	# LATIN SMALL LETTER A WITH CIRCUMFLEX
0x2B25	0x0103	# LATIN SMALL LETTER A WITH BREVE
0x2B26	0x01CE	# LATIN SMALL LETTER A WITH CARON
0x2B27	0x0101	# LATIN SMALL LETTER A WITH MACRON
0x2B28	0x0105	# LATIN SMALL LETTER A WITH OGONEK
0x2B29	0x00E5	# LATIN SMALL LETTER A WITH RING ABOVE
0x2B2A	0x00E3	# LATIN SMALL LETTER A WITH TILDE
0x2B2B	0x0107	# LATIN SMALL LETTER C WITH ACUTE
0x2B2C	0x0109	# LATIN SMALL LETTER C WITH CIRCUMFLEX
0x2B2D	0x010D	# LATIN SMALL LETTER C WITH CARON
0x2B2E	0x00E7	# LATIN SMALL LETTER C WITH CEDILLA
0x2B2F	0x010B	# LATIN SMALL LETTER C WITH DOT ABOVE
0x2B30	0x010F	# LATIN SMALL LETTER D WITH CARON
0x2B31	0x00E9	# LATIN SMALL LETTER E WITH ACUTE
0x2B32	0x00E8	# LATIN SMALL LETTER E WITH GRAVE
0x2B33	0x00EB	# LATIN SMALL LETTER E WITH DIAERESIS
0x2B34	0x00EA	# LATIN SMALL LETTER E WITH CIRCUMFLEX
0x2B35	0x011B	# LATIN SMALL LETTER E WITH CARON
0x2B36	0x0117	# LATIN SMALL LETTER E WITH DOT ABOVE
0x2B37	0x0113	# LATIN SMALL LETTER E WITH MACRON
0x2B38	0x0119	# LATIN SMALL LETTER E WITH OGONEK
0x2B39	0x01F5	# LATIN SMALL LETTER G WITH ACUTE
0x2B3A	0x011D	# LATIN SMALL LETTER G WITH CIRCUMFLEX
0x2B3B	0x011F	# LATIN SMALL LETTER G WITH BREVE
0x2B3D	0x0121	# LATIN SMALL LETTER G WITH DOT ABOVE
0x2B3E	0x0125	# LATIN SMALL LETTER H WITH CIRCUMFLEX
0x2B3F	0x00ED	# LATIN SMALL LETTER I WITH ACUTE
0x2B40	0x00EC	# LATIN SMALL LETTER I WITH GRAVE
0x2B41	0x00EF	# LATIN SMALL LETTER I WITH DIAERESIS
0x2B42	0x00EE	# LATIN SMALL LETTER I WITH CIRCUMFLEX
0x2B43	0x01D0	# LATIN SMALL LETTER I WITH CARON
0x2B45	0x012B	# LATIN SMALL LETTER I WITH MACRON
0x2B46	0x012F	# LATIN SMALL LETTER I WITH OGONEK
0x2B47	0x0129	# LATIN SMALL LETTER I WITH TILDE
0x2B48	0x0135	# LATIN SMALL LETTER J WITH CIRCUMFLEX
0x2B49	0x0137	# LATIN SMALL LETTER K WITH CEDILLA
0x2B4A	0x013A	# LATIN SMALL LETTER L WITH ACUTE
0x2B4B	0x013E	# LATIN SMALL LETTER L WITH CARON
0x2B4C	0x013C	# LATIN SMALL LETTER L WITH CEDILLA
0x2B4D	0x0144	# LATIN SMALL LETTER N WITH ACUTE
0x2B4E	0x0148	# LATIN SMALL LETTER N WITH CARON
0x2B4F	0x0146	# LATIN SMALL LETTER N WITH CEDILLA
0x2B50	0x00F1	# LATIN SMALL LETTER N WITH TILDE
0x2B51	0x00F3	# LATIN SMALL LETTER O WITH ACUTE
0x2B52	0x00F2	# LATIN SMALL LETTER O WITH GRAVE
0x2B53	0x00F6	# LATIN SMALL LETTER O WITH DIAERESIS
0x2B54	0x00F4	# LATIN SMALL LETTER O WITH CIRCUMFLEX
0x2B55	0x01D2	# LATIN SMALL LETTER O WITH CARON
0x2B56	0x0151	# LATIN SMALL LETTER O WITH DOUBLE ACUTE
0x2B57	0x014D	# LATIN SMALL LETTER O WITH MACRON
0x2B58	0x00F5	# LATIN SMALL LETTER O WITH TILDE
0x2B59	0x0155	# LATIN SMALL LETTER R WITH ACUTE
0x2B5A	0x0159	# LATIN SMALL LETTER R WITH CARON
0x2B5B	0x0157	# LATIN SMALL LETTER R WITH CEDILLA
0x2B5C	0x015B	# LATIN SMALL LETTER S WITH ACUTE
0x2B5D	0x015D	# LATIN SMALL LETTER S WITH CIRCUMFLEX
0x2B5E	0x0161	# LATIN SMALL LETTER S WITH CARON
0x2B5F	0x015F	# LATIN SMALL LETTER S WITH CEDILLA
0x2B60	0x0165	# LATIN SMALL LETTER T WITH CARON
0x2B61	0x0163	# LATIN SMALL LETTER T WITH CEDILLA
0x2B62	0x00FA	# LATIN SMALL LETTER U WITH ACUTE
0x2B63	0x00F9	# LATIN SMALL LETTER U WITH GRAVE
0x2B64	0x00FC	# LATIN SMALL LETTER U WITH DIAERESIS
0x2B65	0x00FB	# LATIN SMALL LETTER U WITH CIRCUMFLEX
0x2B66	0x016D	# LATIN SMALL LETTER U WITH BREVE
0x2B67	0x01D4	# LATIN SMALL LETTER U WITH CARON
0x2B68	0x0171	# LATIN SMALL LETTER U WITH DOUBLE ACUTE
0x2B69	0x016B	# LATIN SMALL LETTER U WITH MACRON
0x2B6A	0x0173	# LATIN SMALL LETTER U WITH OGONEK
0x2B6B	0x016F	# LATIN SMALL LETTER U WITH RING ABOVE
0x2B6C	0x0169	# LATIN SMALL LETTER U WITH TILDE
0x2B6D	0x01D8	# LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
0x2B6E	0x01DC	# LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
0x2B6F	0x01DA	# LATIN SMALL LETTER U WITH DIAERESIS AND CARON
0x2B70	0x01D6	# LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
0x2B71	0x0175	# LATIN SMALL LETTER W WITH CIRCUMFLEX
0x2B72	0x00FD	# LATIN SMALL LETTER Y WITH ACUTE
0x2B73	0x00FF	# LATIN SMALL LETTER Y WITH DIAERESIS
0x2B74	0x0177	# LATIN SMALL LETTER Y WITH CIRCUMFLEX
0x2B75	0x017A	# LATIN SMALL LETTER Z WITH ACUTE
0x2B76	0x017E	# LATIN SMALL LETTER Z WITH CARON
0x2B77	0x017C	# LATIN SMALL LETTER Z WITH DOT ABOVE
END JIS0212
START JIS02131
END JIS02131
