#include "InternalSensors.h"

InternalSensors::InternalSensors(unsigned long interval) {
  m_hasBMP180 = false;
  m_lastMeasurement = 0;
  m_interval = interval;
}

bool InternalSensors::TryInitializeBMP180() {
  m_bmp.SetAltitudeAboveSeaLevel();
  m_hasBMP180 = m_bmp.TryInitialize();

  return m_hasBMP180;
}

bool InternalSensors::HasBMP180() {
  return m_hasBMP180;
}

int InternalSensors::GetAltitudeAboveSeaLevel() {
	return m_bmp.GetAltitudeAboveSeaLevel();
}

void InternalSensors::SetAltitudeAboveSeaLevel(int altitude) {
  m_bmp.SetAltitudeAboveSeaLevel(altitude);
}

unsigned long InternalSensors::GetInterval() {
	return m_interval;
}

void InternalSensors::SetInterval(unsigned long interval) {
	m_interval = interval;
}

String InternalSensors::BuildFhemDataString(struct Frame *frame) {
  if (frame->Temperature < -40.0 || frame->Temperature > 85.0)
    return "";
  
  
  String result = "OK WS ";

  result += frame->ID;
  result += " 2";

  // add temperature
  int temp = frame->Temperature * 10 + 1000;
  result += " ";
  result += (byte)(temp >> 8);
  result += " ";
  result += (byte)(temp);

  // no humidity
  result += " 255";

  // no rain
  result += " 255 255";

  // no wind direction
  result += " 255 255";

  // no wind speed
  result += " 255 255";

  // no wind gust
  result += " 255 255";

  // add Flags
  result += " ";
  result += (frame->NewBatteryFlag ? 1 : 0) + (frame->LowBatteryFlag ? 4 : 0);

  // add pressure
  result += " ";
  result += (byte)(frame->Pressure >> 8);
  result += " ";
  result += (byte)(frame->Pressure);

  return result;
}

 String InternalSensors::GetFhemDataString(){
  struct Frame frame;
  String fhemString = "";

  m_lastMeasurement = millis();

  frame.ID = 0;
  frame.LowBatteryFlag = false;
  frame.NewBatteryFlag = false;
  frame.Temperature = m_bmp.GetTemperature();
  frame.Pressure = m_bmp.GetPressure();

  fhemString = BuildFhemDataString(&frame);

  return fhemString;
}

 bool InternalSensors::TryHandleData() {
   if (!m_hasBMP180 || (m_lastMeasurement + m_interval * 1000 < millis()))
	   return false;

   String fhemString = GetFhemDataString();

   if (fhemString.length() > 0) {
     Serial.println(fhemString);
   }

   return fhemString.length() > 0;
 }

