/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.html.embedding.HtmlEmbedment;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.EmbedmentLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer._HtmlLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlLexer
extends BaseHtmlLexer {
    private static final Logger LOG = Logger.getInstance(HtmlLexer.class);
    private final boolean highlightMode;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;
    private final int EMBEDDED_LEXER_ON;
    private Lexer embeddedLexer;
    private boolean hasNoEmbedments;
    private final boolean hasNoLayers;

    public HtmlLexer() {
        this((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _HtmlLexer()), TOKENS_TO_MERGE), true, false);
    }

    public HtmlLexer(boolean highlightMode) {
        this((Lexer)new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)new _HtmlLexer()), TOKENS_TO_MERGE), true, highlightMode);
    }

    protected HtmlLexer(@NotNull Lexer baseLexer, boolean caseInsensitive) {
        if (baseLexer == null) {
            HtmlLexer.$$$reportNull$$$0(0);
        }
        this(baseLexer, caseInsensitive, false);
    }

    protected HtmlLexer(@NotNull Lexer baseLexer, boolean caseInsensitive, boolean highlightMode) {
        if (baseLexer == null) {
            HtmlLexer.$$$reportNull$$$0(1);
        }
        super(baseLexer, caseInsensitive);
        this.EMBEDDED_LEXER_ON = 1 << this.getBaseStateShift();
        this.hasNoLayers = Boolean.TRUE.equals(LayeredLexer.ourDisableLayersFlag.get());
        this.highlightMode = highlightMode;
    }

    public boolean isHighlighting() {
        return this.highlightMode;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            HtmlLexer.$$$reportNull$$$0(2);
        }
        this.myTokenType = null;
        this.embeddedLexer = null;
        if (this.highlightMode && (initialState & this.EMBEDDED_LEXER_ON) != 0) {
            LOG.error((Throwable)new IllegalStateException("Do not reset HTML Lexer to a state with embedded lexer on"));
        }
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    public void advance() {
        if (this.highlightMode) {
            if (this.embeddedLexer != null) {
                this.embeddedLexer.advance();
                if (this.embeddedLexer.getTokenType() == null) {
                    this.embeddedLexer = null;
                }
            }
            if (this.embeddedLexer == null) {
                super.advance();
                if (!this.hasNoEmbedments) {
                    this.tryCreateEmbeddedLexer();
                }
            }
        } else {
            this.myTokenType = null;
            super.advance();
        }
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenType();
        }
        if (this.myTokenType != null) {
            return this.myTokenType;
        }
        if (this.highlightMode) {
            int state;
            IElementType tokenType = super.getTokenType();
            if (tokenType == null) {
                return null;
            }
            if (tokenType == XmlTokenType.XML_NAME) {
                int state2 = this.getState() & 0x3F;
                if (this.isHtmlTagState(state2)) {
                    tokenType = XmlTokenType.XML_TAG_NAME;
                }
            } else if (tokenType == XmlTokenType.XML_WHITE_SPACE || tokenType == XmlTokenType.XML_REAL_WHITE_SPACE) {
                tokenType = this.embeddedLexer != null && this.isWithinTag() ? XmlTokenType.XML_WHITE_SPACE : (this.isWithinTag() ? XmlTokenType.TAG_WHITE_SPACE : XmlTokenType.XML_REAL_WHITE_SPACE);
            } else if ((tokenType == XmlTokenType.XML_CHAR_ENTITY_REF || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN) && (state = this.getState() & 0x3F) == 4) {
                return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
            return tokenType;
        }
        IElementType tokenType = super.getTokenType();
        this.myTokenStart = super.getTokenStart();
        this.myTokenEnd = super.getTokenEnd();
        HtmlEmbedment embedment = this.acquireHtmlEmbedmentInfo();
        if (embedment != null) {
            this.skipEmbedment(embedment);
            this.myTokenEnd = embedment.getRange().getEndOffset();
            this.myTokenType = Objects.requireNonNullElse(embedment.getElementType(), XmlTokenType.XML_DATA_CHARACTERS);
        } else {
            this.myTokenType = tokenType;
        }
        return this.myTokenType;
    }

    public int getTokenStart() {
        if (this.myTokenType != null) {
            return this.myTokenStart;
        }
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenStart();
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.myTokenType != null) {
            return this.myTokenEnd;
        }
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenEnd();
        }
        return super.getTokenEnd();
    }

    @Override
    public int getState() {
        int state = super.getState();
        return state |= this.embeddedLexer != null ? this.EMBEDDED_LEXER_ON : 0;
    }

    @Nullable
    protected Lexer getEmbeddedLexer() {
        return this.embeddedLexer;
    }

    public void setHasNoEmbeddments(boolean hasNoEmbedments) {
        this.hasNoEmbedments = hasNoEmbedments;
    }

    private void tryCreateEmbeddedLexer() {
        IElementType token = this.myDelegate.getTokenType();
        if (token == null) {
            return;
        }
        HtmlEmbedment embedment = this.acquireHtmlEmbedmentInfo();
        if (embedment != null && !embedment.getRange().isEmpty()) {
            if (this.hasNoLayers) {
                LayeredLexer.ourDisableLayersFlag.set(Boolean.TRUE);
            }
            try {
                this.embeddedLexer = embedment.createHighlightingLexer();
            }
            finally {
                if (this.hasNoLayers) {
                    LayeredLexer.ourDisableLayersFlag.set(null);
                }
            }
            if (this.embeddedLexer != null) {
                this.skipEmbedment(embedment);
                this.embeddedLexer.start(this.getBufferSequence(), embedment.getRange().getStartOffset(), embedment.getRange().getEndOffset(), this.embeddedLexer instanceof EmbedmentLexer ? ((EmbedmentLexer)this.embeddedLexer).getEmbeddedInitialState(this.myDelegate.getTokenType()) : 0);
                if (this.embeddedLexer.getTokenType() == null) {
                    this.embeddedLexer = null;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lexer/HtmlLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

