/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.welcomeScreen;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBFont;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayConnectorKt;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import com.jetbrains.gateway.welcomeScreen.GatewayPanelComponents;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u001a\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a\u0015\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "providerIcon", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JLabel;", "Lcom/intellij/ui/dsl/builder/Row;", "icon", "Ljavax/swing/Icon;", "installedConnector", "Lcom/intellij/openapi/ui/DialogPanel;", "connector", "Lcom/jetbrains/gateway/api/GatewayConnector;", "action", "Lkotlin/Function0;", "", "installedConnectorImpl", "MAX_ACTION_TEXT_LEN", "", "computeActionText", "", "Lorg/jetbrains/annotations/Nls;", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nGatewayPanelComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayPanelComponents.kt\ncom/jetbrains/gateway/welcomeScreen/GatewayPanelComponentsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n83#2,3:96\n14#2:100\n1#3:99\n*S KotlinDebug\n*F\n+ 1 GatewayPanelComponents.kt\ncom/jetbrains/gateway/welcomeScreen/GatewayPanelComponentsKt\n*L\n35#1:96,3\n28#1:100\n*E\n"})
public final class GatewayPanelComponentsKt {
    @NotNull
    private static final Logger logger;
    private static final int MAX_ACTION_TEXT_LEN = 23;

    @NotNull
    public static final Cell<JLabel> providerIcon(@NotNull Row $this$providerIcon, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)$this$providerIcon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        int dimension = icon.getIconWidth() > icon.getIconHeight() ? icon.getIconWidth() : icon.getIconHeight();
        return $this$providerIcon.icon(IconUtil.scale((Icon)icon, null, (float)(JBUIScale.scale((float)32.0f) / (float)dimension)));
    }

    @Nullable
    public static final DialogPanel installedConnector(@NotNull GatewayConnector connector, @NotNull Function0<Unit> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            object = Result.constructor-impl((Object)GatewayPanelComponentsKt.installedConnectorImpl(connector, (Function0<Unit>)((Function0)() -> GatewayPanelComponentsKt.installedConnector$lambda$1$lambda$0(action))));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (DialogPanel)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private static final DialogPanel installedConnectorImpl(GatewayConnector connector, Function0<Unit> action) {
        DialogPanel dialogPanel;
        DialogPanel $this$installedConnectorImpl_u24lambda_u2412 = dialogPanel = BuilderKt.panel(arg_0 -> GatewayPanelComponentsKt.installedConnectorImpl$lambda$11(connector, action, arg_0));
        boolean bl = false;
        $this$installedConnectorImpl_u24lambda_u2412.setOpaque(false);
        return dialogPanel;
    }

    private static final String computeActionText(GatewayConnector connector) {
        String current = connector.getActionText();
        if (current.length() > 23) {
            logger.error(connector.getConnectorId() + ": getActionText() exceeds 23 symbols");
            return GatewayBundle.INSTANCE.message("default.connector.actionText", new Object[0]);
        }
        return current;
    }

    private static final Unit installedConnector$lambda$1$lambda$0(Function0 $action) {
        try {
            $action.invoke();
        }
        catch (Throwable t) {
            logger.error("GatewayConnector action failed");
            logger.error(t);
            Messages.showErrorDialog((String)GatewayBundle.INSTANCE.message("dialog.title.please.contact.provider.s.support.for.help.exception.info.can.be.found.in.logs", new Object[0]), (String)GatewayBundle.INSTANCE.message("dialog.message.failed.to.run.action", new Object[0]));
        }
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11$lambda$2(GatewayConnector $connector, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        GatewayPanelComponentsKt.providerIcon($this$row, $connector.getIcon()).align((Align)AlignY.TOP.INSTANCE);
        $this$row.bottomGap(BottomGap.NONE);
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11$lambda$4$lambda$3(JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont((Font)JBFont.create((Font)$this$applyToComponent.getFont().deriveFont(1, 13.0f), (boolean)true));
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11$lambda$4(GatewayConnector $connector, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String title = $connector.getTitle();
        $this$row.label(title).applyToComponent(GatewayPanelComponentsKt::installedConnectorImpl$lambda$11$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11$lambda$10$lambda$5(GatewayConnector $connector, Function0 $action, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GatewayUsagesCollector.INSTANCE.onConnectLeftClick($connector.getClass());
        $action.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11$lambda$10$lambda$6(JButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setBackground(WelcomeScreenUIManager.getMainAssociatedComponentBackground());
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7(GatewayConnector $connector, ActionEvent actionEvent, ActionLink actionLink) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)actionLink, (String)"<unused var>");
        GatewayUsagesCollector.INSTANCE.onDocumentationClick($connector.getClass());
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11$lambda$10(GatewayConnector $connector, Function0 $action, Row $this$row) {
        block0: {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.button(GatewayPanelComponentsKt.computeActionText($connector), arg_0 -> GatewayPanelComponentsKt.installedConnectorImpl$lambda$11$lambda$10$lambda$5($connector, $action, arg_0)).applyToComponent(GatewayPanelComponentsKt::installedConnectorImpl$lambda$11$lambda$10$lambda$6);
            ActionLink actionLink = GatewayConnectorKt.createDocumentationLink($connector);
            if (actionLink == null) break block0;
            ActionLink it = actionLink;
            boolean bl = false;
            Cell $this$installedConnectorImpl_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = cell = $this$row.cell((JComponent)it);
            boolean bl2 = false;
            ButtonKt.actionListener((Cell)$this$installedConnectorImpl_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248, (arg_0, arg_1) -> GatewayPanelComponentsKt.installedConnectorImpl$lambda$11$lambda$10$lambda$9$lambda$8$lambda$7($connector, arg_0, arg_1));
        }
        return Unit.INSTANCE;
    }

    private static final Unit installedConnectorImpl$lambda$11(GatewayConnector $connector, Function0 $action, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GatewayPanelComponentsKt.installedConnectorImpl$lambda$11$lambda$2($connector, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GatewayPanelComponentsKt.installedConnectorImpl$lambda$11$lambda$4($connector, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GatewayPanelComponentsKt.installedConnectorImpl$lambda$11$lambda$10($connector, $action, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GatewayPanelComponents.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GatewayPanelComponentsKt.logger = logger;
    }
}

