/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.layout.Breaker;
import com.openhtmltopdf.layout.FunctionData;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.CharCounts;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.OpenUtil;

public class InlineText {
    private InlineLayoutBox _parent;
    private int _x;
    private int _width;
    private String _masterText;
    private int _start;
    private int _end;
    private boolean _containedLF = false;
    private boolean _trimmedLeadingSpace;
    private boolean _trimmedTrailingSpace;
    private CharCounts _counts;
    private InlineTextRareData _rareData;

    private void ensureRareData() {
        if (this._rareData == null) {
            this._rareData = new InlineTextRareData();
        }
    }

    public void setTextDirection(byte direction) {
        if (direction != 0) {
            this.ensureRareData();
        }
        if (this._rareData != null) {
            this._rareData._textDirection = direction;
        }
    }

    public byte getTextDirection() {
        return this._rareData != null ? this._rareData._textDirection : (byte)0;
    }

    public void setLetterSpacing(float letterSpacing) {
        if (letterSpacing != 0.0f) {
            this.ensureRareData();
        }
        if (this._rareData != null) {
            this._rareData._letterSpacing = letterSpacing;
        }
    }

    public float getLetterSpacing() {
        return this._rareData != null ? this._rareData._letterSpacing : 0.0f;
    }

    public void trimTrailingSpace(LayoutContext c) {
        if (!this.isEmpty() && this._masterText.charAt(this._end - 1) == ' ') {
            --this._end;
            this.setWidth(Breaker.getTextWidthWithLetterSpacing(c, this.getParent().getStyle().getFSFont(c), this.getSubstring(), this.getLetterSpacing()));
            this.setTrimmedTrailingSpace(true);
        }
    }

    public boolean isEmpty() {
        return this._start == this._end && !this._containedLF;
    }

    public String getSubstring() {
        if (this.getMasterText() != null) {
            if (this._start == -1 || this._end == -1) {
                throw new RuntimeException("negative index in InlineBox");
            }
            if (this._end < this._start) {
                throw new RuntimeException("end is less than setStartStyle");
            }
            return this.getMasterText().substring(this._start, this._end);
        }
        throw new RuntimeException("No master text set!");
    }

    public void setSubstring(int start2, int end) {
        if (end < start2) {
            String msg = String.format("(start = %d, end = %d)", start2, end);
            throw new RuntimeException("set substring length too long " + msg + ": " + this);
        }
        if (end < 0 || start2 < 0) {
            throw new RuntimeException("Trying to set negative index to inline box");
        }
        this._start = start2;
        this._end = end;
        if (this._end > 0 && this._masterText.charAt(this._end - 1) == '\n') {
            this._containedLF = true;
            --this._end;
        }
    }

    public String getMasterText() {
        return this._masterText;
    }

    public void setMasterText(String masterText) {
        this._masterText = masterText;
    }

    public int getX() {
        return this._x;
    }

    public void setX(int x) {
        this._x = x;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public void paint(RenderingContext c) {
        c.getOutputDevice().drawText(c, this);
    }

    public void paintSelection(RenderingContext c) {
        c.getOutputDevice().drawSelection(c, this);
    }

    public InlineLayoutBox getParent() {
        return this._parent;
    }

    public void setParent(InlineLayoutBox parent) {
        this._parent = parent;
    }

    public boolean isDynamicFunction() {
        return this._rareData != null && this._rareData._functionData != null;
    }

    public FunctionData getFunctionData() {
        return this._rareData != null ? this._rareData._functionData : null;
    }

    public void setFunctionData(FunctionData functionData) {
        if (functionData != null) {
            this.ensureRareData();
        }
        if (this._rareData != null) {
            this._rareData._functionData = functionData;
        }
    }

    public void updateDynamicValue(RenderingContext c) {
        String value2 = this._rareData._functionData.getContentFunction().calculate(c, this._rareData._functionData.getFunction(), this);
        this._start = 0;
        this._end = value2.length();
        this._masterText = value2;
        this.setWidth(Breaker.getTextWidthWithLetterSpacing(c, this.getParent().getStyle().getFSFont(c), value2, this.getLetterSpacing()));
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("InlineText: ");
        if (this._containedLF || this.isDynamicFunction()) {
            result2.append("(");
            if (this._containedLF) {
                result2.append('L');
            }
            if (this.isDynamicFunction()) {
                result2.append('F');
            }
            result2.append(") ");
        }
        result2.append('(');
        result2.append(this.getSubstring());
        result2.append(')');
        return result2.toString();
    }

    public String getTextExportText() {
        char[] ch = this.getSubstring().toCharArray();
        StringBuilder result2 = new StringBuilder();
        if (this.isTrimmedLeadingSpace()) {
            result2.append(' ');
        }
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (c == '\n') continue;
            result2.append(c);
        }
        if (this.isTrimmedTrailingSpace()) {
            result2.append(' ');
        }
        return result2.toString();
    }

    public boolean isTrimmedLeadingSpace() {
        return this._trimmedLeadingSpace;
    }

    public void setTrimmedLeadingSpace(boolean trimmedLeadingSpace) {
        this._trimmedLeadingSpace = trimmedLeadingSpace;
    }

    private void setTrimmedTrailingSpace(boolean trimmedTrailingSpace) {
        this._trimmedTrailingSpace = trimmedTrailingSpace;
    }

    private boolean isTrimmedTrailingSpace() {
        return this._trimmedTrailingSpace;
    }

    public static boolean isJustifySpaceCodePoint(int cp) {
        return cp == 32 || cp == 160 || cp == 12288;
    }

    public void countJustifiableChars(CharCounts counts) {
        if (this.getLetterSpacing() != 0.0f) {
            return;
        }
        this._counts = new CharCounts();
        this.getSubstring().codePoints().forEach(cp -> {
            if (InlineText.isJustifySpaceCodePoint(cp)) {
                this._counts.incrementSpaceCount();
            } else if (OpenUtil.isCodePointPrintable(cp)) {
                this._counts.incrementNonSpaceCount();
            }
        });
        if (this.isEndsOnSoftHyphen()) {
            this._counts.incrementNonSpaceCount();
        }
        counts.setSpaceCount(counts.getSpaceCount() + this._counts.getSpaceCount());
        counts.setNonSpaceCount(counts.getNonSpaceCount() + this._counts.getNonSpaceCount());
    }

    public float calcTotalAdjustment(JustificationInfo info) {
        if (this.getLetterSpacing() != 0.0f) {
            return 0.0f;
        }
        if (this._counts == null) {
            return 0.0f;
        }
        return (float)this._counts.getSpaceCount() * info.getSpaceAdjust() + (float)this._counts.getNonSpaceCount() * info.getNonSpaceAdjust();
    }

    public int getStart() {
        return this._start;
    }

    public int getEnd() {
        return this._end;
    }

    public void setEndsOnSoftHyphen(boolean endsOnSoftHyphen) {
        if (endsOnSoftHyphen) {
            this.ensureRareData();
        }
        if (this._rareData != null) {
            this._rareData._endsOnSoftHyphen = endsOnSoftHyphen;
        }
    }

    public boolean isEndsOnSoftHyphen() {
        return this._rareData != null ? this._rareData._endsOnSoftHyphen : false;
    }

    static class InlineTextRareData {
        FunctionData _functionData;
        boolean _endsOnSoftHyphen = false;
        float _letterSpacing = 0.0f;
        byte _textDirection = 0;

        InlineTextRareData() {
        }
    }
}

