/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.util.text.Strings;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.license.QodanaLicense;
import org.jetbrains.qodana.license.QodanaLicenseType;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FailureConditions;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FixesStrategy;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001IB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0015\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b4J\u0006\u00105\u001a\u000206J\u0012\u00107\u001a\u0002062\b\u00108\u001a\u0004\u0018\u00010\tH\u0007J\u0016\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\tJ \u0010<\u001a\u0002062\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\tH\u0007J\u0010\u0010A\u001a\u0002062\u0006\u0010B\u001a\u00020CH\u0007J\u001c\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020F0E0\b2\u0006\u0010G\u001a\u00020HH\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/UsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "knownSystems", "", "", "systemField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "versionField", "buildField", "envEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "knownProfiles", "profileField", "includeField", "Lcom/intellij/internal/statistic/eventLog/events/RoundedIntEventField;", "excludeField", "stopThresholdField", "bootstrapField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "scriptField", "phpMigrationFromLevelField", "phpMigrationToLevelField", "failureConditionAnySeverityField", "failureConditionCriticalField", "failureConditionHighField", "failureConditionModerateField", "failureConditionLowField", "failureConditionInfoField", "failureConditionMinimumTotalCoverageField", "failureConditionMinimumFreshCoverageField", "sourceDirField", "includeAbsentField", "fixesStrategyField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "baselineField", "configEvent", "licenseTypeField", "Lorg/jetbrains/qodana/license/QodanaLicenseType;", "trialField", "daysLeftField", "licenseEvent", "qodanaYamlDetectedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "splitEnv", "Lorg/jetbrains/qodana/staticAnalysis/stat/UsageCollector$Environment;", "env", "splitEnv$intellij_qodana", "logQodanaYamlPresent", "", "logEnv", "qodanaEnv", "profileForReporting", "name", "path", "logConfig", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "profileName", "profilePath", "logLicense", "license", "Lorg/jetbrains/qodana/license/QodanaLicense;", "logFailureConditions", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "", "failureConditions", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FailureConditions;", "Environment", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nUsageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsageCollector.kt\norg/jetbrains/qodana/staticAnalysis/stat/UsageCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,244:1\n264#2:245\n*S KotlinDebug\n*F\n+ 1 UsageCollector.kt\norg/jetbrains/qodana/staticAnalysis/stat/UsageCollector\n*L\n88#1:245\n*E\n"})
public final class UsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final UsageCollector INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final List<String> knownSystems;
    @NotNull
    private static final StringEventField systemField;
    @NotNull
    private static final StringEventField versionField;
    @NotNull
    private static final StringEventField buildField;
    @NotNull
    private static final VarargEventId envEvent;
    @NotNull
    private static final List<String> knownProfiles;
    @NotNull
    private static final StringEventField profileField;
    @NotNull
    private static final RoundedIntEventField includeField;
    @NotNull
    private static final RoundedIntEventField excludeField;
    @NotNull
    private static final RoundedIntEventField stopThresholdField;
    @NotNull
    private static final BooleanEventField bootstrapField;
    @NotNull
    private static final StringEventField scriptField;
    @NotNull
    private static final StringEventField phpMigrationFromLevelField;
    @NotNull
    private static final StringEventField phpMigrationToLevelField;
    @NotNull
    private static final RoundedIntEventField failureConditionAnySeverityField;
    @NotNull
    private static final RoundedIntEventField failureConditionCriticalField;
    @NotNull
    private static final RoundedIntEventField failureConditionHighField;
    @NotNull
    private static final RoundedIntEventField failureConditionModerateField;
    @NotNull
    private static final RoundedIntEventField failureConditionLowField;
    @NotNull
    private static final RoundedIntEventField failureConditionInfoField;
    @NotNull
    private static final RoundedIntEventField failureConditionMinimumTotalCoverageField;
    @NotNull
    private static final RoundedIntEventField failureConditionMinimumFreshCoverageField;
    @NotNull
    private static final BooleanEventField sourceDirField;
    @NotNull
    private static final BooleanEventField includeAbsentField;
    @NotNull
    private static final EnumEventField<FixesStrategy> fixesStrategyField;
    @NotNull
    private static final StringEventField baselineField;
    @NotNull
    private static final VarargEventId configEvent;
    @NotNull
    private static final EnumEventField<QodanaLicenseType> licenseTypeField;
    @NotNull
    private static final BooleanEventField trialField;
    @NotNull
    private static final RoundedIntEventField daysLeftField;
    @NotNull
    private static final VarargEventId licenseEvent;
    @NotNull
    private static final EventId qodanaYamlDetectedEvent;

    private UsageCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final Environment splitEnv$intellij_qodana(@NotNull String env2) {
        Intrinsics.checkNotNullParameter((Object)env2, (String)"env");
        String regex = "(?x)\n        ([\\w-]+)                          # system\n        (?: : (\\d+ (?:\\.\\d+)* (?:_EAP)?)  # optional version; keep in sync with versionField\n          (?: : ([1-9]\\d{0,8}) )?         # optional build\n        )?\n      ";
        MatchResult matchResult = new Regex(regex).matchEntire((CharSequence)env2);
        if (matchResult != null) {
            MatchResult m = matchResult;
            boolean bl = false;
            MatchResult.Destructured destructured = m.getDestructured();
            String system = (String)destructured.getMatch().getGroupValues().get(1);
            String version = (String)destructured.getMatch().getGroupValues().get(2);
            String build2 = (String)destructured.getMatch().getGroupValues().get(3);
            if (Intrinsics.areEqual((Object)system, (Object)"teamcity") || Intrinsics.areEqual((Object)system, (Object)"teamcity-cloud")) {
                return new Environment(system, Strings.nullize((String)version), Strings.nullize((String)build2));
            }
            if (knownSystems.contains(system)) {
                return new Environment(system, Strings.nullize((String)version), null);
            }
        }
        return new Environment("other", null, null);
    }

    public final void logQodanaYamlPresent() {
        qodanaYamlDetectedEvent.log();
    }

    @JvmStatic
    public static final void logEnv(@Nullable String qodanaEnv) {
        String string = qodanaEnv;
        if (string == null) {
            string = "other";
        }
        Environment env2 = INSTANCE.splitEnv$intellij_qodana(string);
        List args = new ArrayList();
        ((Collection)args).add(systemField.with((Object)env2.getSystem()));
        if (env2.getVersion() != null) {
            ((Collection)args).add(versionField.with((Object)env2.getVersion()));
        }
        if (env2.getBuild() != null) {
            ((Collection)args).add(buildField.with((Object)env2.getBuild()));
        }
        envEvent.log(args);
    }

    @NotNull
    public final String profileForReporting(@NotNull String name, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Intrinsics.areEqual((Object)name, (Object)"empty") ? "empty" : (Intrinsics.areEqual((Object)name, (Object)"qodana.starter") ? "starter" : (Intrinsics.areEqual((Object)name, (Object)"qodana.recommended") ? "recommended" : (StringsKt.startsWith$default((String)name, (String)"qodana.single:", (boolean)false, (int)2, null) ? "single" : (Intrinsics.areEqual((Object)name, (Object)"") && !Intrinsics.areEqual((Object)path, (Object)"") ? "path" : (Intrinsics.areEqual((Object)name, (Object)"") && Intrinsics.areEqual((Object)path, (Object)"") ? "absent" : "other")))));
    }

    @JvmStatic
    public static final void logConfig(@NotNull QodanaConfig config, @NotNull String profileName, @NotNull String profilePath) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)profilePath, (String)"profilePath");
        List args = new ArrayList();
        ((Collection)args).add(profileField.with((Object)INSTANCE.profileForReporting(profileName, profilePath)));
        ((Collection)args).add(includeField.with((Object)config.getInclude().size()));
        ((Collection)args).add(excludeField.with((Object)config.getExclude().size()));
        ((Collection)args).add(bootstrapField.with((Object)Strings.isNotEmpty((String)config.getBootstrap())));
        CollectionsKt.addAll((Collection)args, (Iterable)INSTANCE.logFailureConditions(config.getFailureConditions()));
        switch (config.getScript().getName()) {
            case "local-changes": 
            case "scoped": 
            case "migrate-classes": {
                ((Collection)args).add(scriptField.with((Object)config.getScript().getName()));
                break;
            }
            case "php-migration": {
                ((Collection)args).add(scriptField.with((Object)"php-migration"));
                Collection collection = args;
                Object object = config.getScript().getParameters().get("fromLevel");
                collection.add(phpMigrationFromLevelField.with((Object)(object != null ? object.toString() : null)));
                collection = args;
                Object object2 = config.getScript().getParameters().get("toLevel");
                collection.add(phpMigrationToLevelField.with((Object)(object2 != null ? object2.toString() : null)));
                break;
            }
            default: {
                ((Collection)args).add(scriptField.with((Object)"other"));
            }
            case "default": 
        }
        ((Collection)args).add(sourceDirField.with((Object)(config.getSourceDirectory() != null ? 1 : 0)));
        ((Collection)args).add(fixesStrategyField.with((Object)config.getFixesStrategy()));
        ((Collection)args).add(includeAbsentField.with((Object)config.getIncludeAbsent()));
        Object object = args;
        object.add(baselineField.with((Object)(config.getBaseline() == null ? "none" : "local")));
        configEvent.log(args);
    }

    @JvmStatic
    public static final void logLicense(@NotNull QodanaLicense license) {
        Intrinsics.checkNotNullParameter((Object)license, (String)"license");
        List args = new ArrayList();
        ((Collection)args).add(licenseTypeField.with((Object)license.getType()));
        ((Collection)args).add(trialField.with((Object)license.getTrial()));
        if (license.getExpirationDate() != null) {
            long daysLeft = Duration.between(Instant.now(), license.getExpirationDate().toInstant()).toDays() + 1L;
            ((Collection)args).add(daysLeftField.with((Object)((int)daysLeft)));
        }
        licenseEvent.log(args);
    }

    private final List<EventPair<Integer>> logFailureConditions(FailureConditions failureConditions) {
        List list2;
        List $this$logFailureConditions_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionAnySeverityField), $this$logFailureConditions_u24lambda_u242, failureConditions.getSeverityThresholds().getAny());
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionCriticalField), $this$logFailureConditions_u24lambda_u242, failureConditions.getSeverityThresholds().getCritical());
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionHighField), $this$logFailureConditions_u24lambda_u242, failureConditions.getSeverityThresholds().getHigh());
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionModerateField), $this$logFailureConditions_u24lambda_u242, failureConditions.getSeverityThresholds().getModerate());
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionLowField), $this$logFailureConditions_u24lambda_u242, failureConditions.getSeverityThresholds().getLow());
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionInfoField), $this$logFailureConditions_u24lambda_u242, failureConditions.getSeverityThresholds().getInfo());
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionMinimumTotalCoverageField), $this$logFailureConditions_u24lambda_u242, failureConditions.getTestCoverageThresholds().getTotal());
        UsageCollector.logFailureConditions$lambda$2$logIfPresent((EventField<Integer>)((EventField)failureConditionMinimumFreshCoverageField), $this$logFailureConditions_u24lambda_u242, failureConditions.getTestCoverageThresholds().getFresh());
        return CollectionsKt.build((List)list2);
    }

    private static final String fixesStrategyField$lambda$0(FixesStrategy it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String string = it.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final void logFailureConditions$lambda$2$logIfPresent(EventField<Integer> $this$logFailureConditions_u24lambda_u242_u24logIfPresent, List<EventPair<Integer>> $this_buildList, Integer value2) {
        if (value2 != null) {
            $this_buildList.add((EventPair<Integer>)$this$logFailureConditions_u24lambda_u242_u24logIfPresent.with((Object)value2));
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void name$iv;
        INSTANCE = new UsageCollector();
        GROUP = new EventLogGroup("qodana.usage", 10, null, 4, null);
        Object[] objectArray = new String[]{"azure-pipelines", "bamboo", "buddy", "bitrise", "circleci", "codefresh", "codeship", "github-actions", "gitlab", "gocd", "jenkins", "jetbrains-space", "semaphore", "travis-ci", "wercker", "cli", "teamcity", "teamcity-cloud", "gradle", "other"};
        knownSystems = CollectionsKt.listOf((Object[])objectArray);
        systemField = EventFields.String((String)"system", knownSystems);
        versionField = EventFields.StringValidatedByInlineRegexp((String)"version", (String)"(?x) \\d+ (?:\\.\\d+)* (?:_EAP)?");
        buildField = EventFields.StringValidatedByRegexpReference$default((String)"build", (String)"integer", null, (int)4, null);
        objectArray = new EventField[]{systemField, versionField, buildField};
        envEvent = GROUP.registerVarargEvent("env", (EventField[])objectArray);
        objectArray = new String[]{"empty", "starter", "recommended", "single", "path", "absent", "other"};
        knownProfiles = CollectionsKt.listOf((Object[])objectArray);
        profileField = EventFields.String((String)"profile", knownProfiles);
        includeField = EventFields.RoundedInt((String)"include");
        excludeField = EventFields.RoundedInt((String)"exclude");
        stopThresholdField = EventFields.RoundedInt((String)"stopThreshold");
        bootstrapField = EventFields.Boolean((String)"bootstrap");
        objectArray = new String[]{"php-migration", "local-changes", "migrate-classes", "scoped", "other"};
        scriptField = EventFields.String((String)"script", (List)CollectionsKt.listOf((Object[])objectArray));
        phpMigrationFromLevelField = EventFields.StringValidatedByRegexpReference$default((String)"phpMigrationFromLevel", (String)"version", null, (int)4, null);
        phpMigrationToLevelField = EventFields.StringValidatedByRegexpReference$default((String)"phpMigrationToLevel", (String)"version", null, (int)4, null);
        failureConditionAnySeverityField = EventFields.RoundedInt((String)"failureConditionAnySeverity");
        failureConditionCriticalField = EventFields.RoundedInt((String)"failureConditionCritical");
        failureConditionHighField = EventFields.RoundedInt((String)"failureConditionHigh");
        failureConditionModerateField = EventFields.RoundedInt((String)"failureConditionModerate");
        failureConditionLowField = EventFields.RoundedInt((String)"failureConditionLow");
        failureConditionInfoField = EventFields.RoundedInt((String)"failureConditionInfo");
        failureConditionMinimumTotalCoverageField = EventFields.RoundedInt((String)"failureConditionMinimumTotalCoverage");
        failureConditionMinimumFreshCoverageField = EventFields.RoundedInt((String)"failureConditionMinimumFreshCoverage");
        sourceDirField = EventFields.Boolean((String)"sourceDirectory");
        includeAbsentField = EventFields.Boolean((String)"includeAbsent");
        objectArray = EventFields.INSTANCE;
        String string = "fixesStrategy";
        Function1 transform$iv = UsageCollector::fixesStrategyField$lambda$0;
        boolean $i$f$Enum = false;
        fixesStrategyField = new EnumEventField((String)name$iv, FixesStrategy.class, null, transform$iv);
        objectArray = new String[]{"none", "local", "cloud"};
        baselineField = EventFields.String((String)"baselineType", (List)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new EventField[]{profileField, includeField, excludeField, stopThresholdField, bootstrapField, scriptField, phpMigrationFromLevelField, phpMigrationToLevelField, failureConditionAnySeverityField, failureConditionCriticalField, failureConditionHighField, failureConditionModerateField, failureConditionLowField, failureConditionInfoField, failureConditionMinimumTotalCoverageField, failureConditionMinimumFreshCoverageField, sourceDirField, includeAbsentField, fixesStrategyField, baselineField};
        configEvent = GROUP.registerVarargEvent("config", (EventField[])objectArray);
        licenseTypeField = EventFields.Enum$default((String)"licenseType", QodanaLicenseType.class, null, (int)4, null);
        trialField = EventFields.Boolean((String)"trial");
        daysLeftField = EventFields.RoundedInt((String)"daysLeft");
        objectArray = new EventField[]{licenseTypeField, trialField, daysLeftField};
        licenseEvent = GROUP.registerVarargEvent("license.info", (EventField[])objectArray);
        qodanaYamlDetectedEvent = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"qodana.yaml.detected", null, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/UsageCollector$Environment;", "", "system", "", "version", "build", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSystem", "()Ljava/lang/String;", "getVersion", "getBuild", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.qodana"})
    public static final class Environment {
        @NotNull
        private final String system;
        @Nullable
        private final String version;
        @Nullable
        private final String build;

        public Environment(@NotNull String system, @Nullable String version, @Nullable String build2) {
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            this.system = system;
            this.version = version;
            this.build = build2;
        }

        @NotNull
        public final String getSystem() {
            return this.system;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @Nullable
        public final String getBuild() {
            return this.build;
        }

        @NotNull
        public final String component1() {
            return this.system;
        }

        @Nullable
        public final String component2() {
            return this.version;
        }

        @Nullable
        public final String component3() {
            return this.build;
        }

        @NotNull
        public final Environment copy(@NotNull String system, @Nullable String version, @Nullable String build2) {
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            return new Environment(system, version, build2);
        }

        public static /* synthetic */ Environment copy$default(Environment environment2, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = environment2.system;
            }
            if ((n & 2) != 0) {
                string2 = environment2.version;
            }
            if ((n & 4) != 0) {
                string3 = environment2.build;
            }
            return environment2.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Environment(system=" + this.system + ", version=" + this.version + ", build=" + this.build + ")";
        }

        public int hashCode() {
            int result2 = this.system.hashCode();
            result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
            result2 = result2 * 31 + (this.build == null ? 0 : this.build.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Environment)) {
                return false;
            }
            Environment environment2 = (Environment)other;
            if (!Intrinsics.areEqual((Object)this.system, (Object)environment2.system)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.version, (Object)environment2.version)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.build, (Object)environment2.build);
        }
    }
}

