/*
 * Decompiled with CFR 0.152.
 */
package training.learn.course;

import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.course.LearningCourse;
import training.util.DataLoader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Ltraining/learn/course/LearningCourseBase;", "Ltraining/learn/course/LearningCourse;", "lang", "", "<init>", "(Ljava/lang/String;)V", "getLang", "()Ljava/lang/String;", "langSupport", "Ltraining/lang/LangSupport;", "getLangSupport", "()Ltraining/lang/LangSupport;", "langSupport$delegate", "Lkotlin/Lazy;", "loadSample", "Ltraining/dsl/LessonSample;", "path", "intellij.featuresTrainer"})
public abstract class LearningCourseBase
implements LearningCourse {
    @NotNull
    private final String lang;
    @NotNull
    private final Lazy langSupport$delegate;

    public LearningCourseBase(@NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        this.lang = lang;
        this.langSupport$delegate = LazyKt.lazy(() -> LearningCourseBase.langSupport_delegate$lambda$0(this));
    }

    @NotNull
    public final String getLang() {
        return this.lang;
    }

    @NotNull
    public final LangSupport getLangSupport() {
        Lazy lazy = this.langSupport$delegate;
        return (LangSupport)lazy.getValue();
    }

    @NotNull
    public final LessonSample loadSample(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = this.lang.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = "modules/" + string + "/" + path;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)DataLoader.INSTANCE.getResourceAsStream(string2, classLoader));
        Charset charset = Charsets.UTF_8;
        String content = new String(byArray, charset);
        return LessonSampleKt.parseLessonSample(content);
    }

    private static final LangSupport langSupport_delegate$lambda$0(LearningCourseBase this$0) {
        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupportById(this$0.lang);
        if (langSupport == null) {
            throw new IllegalStateException(("No language with id " + this$0.lang).toString());
        }
        return langSupport;
    }
}

