/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactoryImpl;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentModificationFailedException;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsModificationsKt;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.run.HttpClientJsonVariablesHelperKt;
import com.intellij.httpClient.http.request.run.HttpRequestActionsProvider;
import com.intellij.httpClient.http.request.run.HttpRequestExecutorExtensionFactory;
import com.intellij.httpClient.http.request.run.console.HttpRequestErrorFileFilter;
import com.intellij.httpClient.http.request.run.console.HttpRequestErrorFixFilter;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u00162\u00020\u0001:\b\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter;", "Lcom/intellij/execution/filters/Filter;", "<init>", "()V", "addEnvFileOption", "", "addVariableToEnvOption", "runWithEnvOption", "addFormatToConf", "Lcom/intellij/openapi/util/NlsSafe;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "QuickFixProvider", "ConsoleClickAction", "CreateNewEnvFileConsoleClickAction", "AddToExistingEnvConsoleClickAction", "RunWithEnvAction", "AddFormatToSslConfProperty", "VariablePosition", "Companion", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestErrorFixFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,367:1\n14#2:368\n*S KotlinDebug\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter\n*L\n365#1:368\n*E\n"})
public final class HttpRequestErrorFixFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String addEnvFileOption = "1. " + HttpClientExecutorBundle.message("http.client.request.error.message.add.env.file.quickfix", new Object[0]);
    @NotNull
    private final String addVariableToEnvOption = "2. " + HttpClientExecutorBundle.message("http.client.request.error.message.add.to.env.quickfix", new Object[0]);
    @NotNull
    private final String runWithEnvOption = "3. " + HttpClientExecutorBundle.message("http.client.request.error.message.run.with.env.quickfix", new Object[0]);
    @Nullable
    private final String addFormatToConf = com.intellij.httpClient.http.request.run.console.HttpRequestErrorFixFilter$Companion.access$getSslFileFormatFixSuggestionMessage(Companion);
    @NotNull
    private static final String VARIABLE_SEPARATOR = "'";
    @NotNull
    private static final Logger LOG;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Filter.Result result2;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int begin2 = entireLength - line.length();
        QuickFixProvider provider = new QuickFixProvider(begin2, ((Object)StringsKt.trimEnd((CharSequence)line)).toString());
        String string = provider.getCurrentLine();
        if (Intrinsics.areEqual((Object)string, (Object)this.addEnvFileOption)) {
            result2 = provider.addQuickFix(HttpClientExecutorBundle.message("http.client.request.error.message.add.env.file.quickfix", new Object[0]), 2, (Function1<? super Integer, ? extends HyperlinkInfo>)((Function1)applyFilter.1.INSTANCE));
        } else if (Intrinsics.areEqual((Object)string, (Object)this.addVariableToEnvOption)) {
            result2 = provider.addQuickFix(HttpClientExecutorBundle.message("http.client.request.error.message.add.to.env.quickfix", new Object[0]), 3, (Function1<? super Integer, ? extends HyperlinkInfo>)((Function1)applyFilter.2.INSTANCE));
        } else if (Intrinsics.areEqual((Object)string, (Object)this.runWithEnvOption)) {
            result2 = provider.addQuickFix(HttpClientExecutorBundle.message("http.client.request.error.message.run.with.env.quickfix", new Object[0]), 4, (Function1<? super Integer, ? extends HyperlinkInfo>)((Function1)applyFilter.3.INSTANCE));
        } else if (Intrinsics.areEqual((Object)string, (Object)this.addFormatToConf)) {
            String string2 = HttpRequestErrorFixFilter.Companion.getSslFileFormatFixMessage();
            if (string2 != null) {
                String message = string2;
                boolean bl = false;
                result2 = provider.addQuickFix(message, 2, (Function1<? super Integer, ? extends HyperlinkInfo>)((Function1)applyFilter.4.1.INSTANCE));
            } else {
                result2 = null;
            }
        } else {
            result2 = null;
        }
        return result2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HttpRequestErrorFixFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J#\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0010\b\u0004\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019H\u0082\bJ\u0018\u0010\u001a\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0015H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$AddFormatToSslConfProperty;", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "lineOffset", "", "<init>", "(I)V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "event", "Ljava/awt/event/InputEvent;", "addFormat", "file", "Lcom/intellij/psi/PsiFile;", "errorOffset", "addToInlinedPath", "currentProperty", "Lcom/intellij/json/psi/JsonProperty;", "addToObject", "addFormatProperty", "formatPropertyProvider", "Lkotlin/Function0;", "changeFormatProperty", "formatProperty", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestErrorFixFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$AddFormatToSslConfProperty\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,367:1\n269#1,11:370\n269#1,11:382\n66#2,2:368\n19#3:381\n*S KotlinDebug\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$AddFormatToSslConfProperty\n*L\n247#1:370,11\n261#1:382,11\n237#1:368,2\n259#1:381\n*E\n"})
    private static final class AddFormatToSslConfProperty
    extends ConsoleClickAction {
        private final int lineOffset;

        public AddFormatToSslConfProperty(int lineOffset) {
            this.lineOffset = lineOffset;
        }

        @Override
        public void execute(@NotNull Project project, @NotNull Editor editor2, int offset, @NotNull InputEvent event) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            int positionInfoLine = editor2.getDocument().getLineNumber(offset) - this.lineOffset;
            HttpRequestErrorFileFilter.ErrorInformation errorInformation = Companion.getErrorInformationFromEditor(editor2, positionInfoLine, project);
            if (errorInformation == null) {
                return;
            }
            HttpRequestErrorFileFilter.ErrorInformation errorInformation2 = errorInformation;
            VirtualFile virtualFile = Companion.getFileFromFileHyperlink(errorInformation2.getPosition());
            if (virtualFile == null) {
                return;
            }
            VirtualFile vFile = virtualFile;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            if (psiFile == null) {
                return;
            }
            PsiFile psiFile2 = psiFile;
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
            if (document == null) {
                return;
            }
            Document document2 = document;
            boolean bl = false;
            int errorOffset = document2.getLineStartOffset(errorInformation2.getPosition().getDocumentLine()) + errorInformation2.getPosition().getDocumentColumn();
            this.addFormat(psiFile2, errorOffset);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void addFormat(PsiFile file, int errorOffset) {
            PsiElement element;
            block7: {
                PsiElement psiElement = file.findElementAt(errorOffset);
                if (psiElement == null) return;
                PsiElement $this$parentOfType_u24default$iv = psiElement;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                psiElement = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, JsonProperty.class, (boolean)true);
                if (psiElement == null) {
                    return;
                }
                element = psiElement;
                String string = element.getName();
                switch (string.hashCode()) {
                    case 3433509: {
                        if (!string.equals("path")) {
                            return;
                        }
                        break block7;
                    }
                    case 592328908: {
                        if (string.equals("clientCertificate")) break;
                        return;
                    }
                    case -1950045709: {
                        if (!string.equals("clientCertificateKey")) return;
                        this.addToInlinedPath(file, (JsonProperty)element);
                        return;
                    }
                }
                this.addToInlinedPath(file, (JsonProperty)element);
                return;
            }
            this.addToObject(file, (JsonProperty)element);
        }

        private final void addToInlinedPath(PsiFile file, JsonProperty currentProperty) {
            JsonValue jsonValue = currentProperty.getValue();
            if (jsonValue == null) {
                return;
            }
            JsonValue pathValue = jsonValue;
            AddFormatToSslConfProperty this_$iv = this;
            boolean $i$f$addFormatProperty = false;
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            OpenFileAction.Companion.openFile(virtualFile, project);
            Editor editor2 = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor();
            if (editor2 != null) {
                Editor editor$iv = editor2;
                WriteCommandAction.writeCommandAction((Project)file.getProject()).withName(RestClientBundle.message("http.request.env.ssl.add.format.fix.action", new Object[0])).run(new ThrowableRunnable(this_$iv, editor$iv, file, pathValue){
                    final /* synthetic */ AddFormatToSslConfProperty this$0;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ PsiFile $file$inlined;
                    final /* synthetic */ JsonValue $pathValue$inlined;
                    {
                        this.this$0 = $receiver;
                        this.$editor = $editor;
                        this.$file$inlined = psiFile;
                        this.$pathValue$inlined = jsonValue;
                    }

                    public final void run() {
                        boolean bl = false;
                        JsonObject jsonObject = new JsonElementGenerator(this.$file$inlined.getProject()).createObject(StringsKt.trimIndent((String)("\n              \"path\": " + this.$pathValue$inlined.getText() + ",\n              \"format\": \"\"\n            ")));
                        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"createObject(...)");
                        JsonObject jsonObject2 = jsonObject;
                        PsiElement psiElement = this.$pathValue$inlined.replace((PsiElement)jsonObject2);
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
                        JsonObject newObject = (JsonObject)psiElement;
                        JsonProperty jsonProperty = newObject.findProperty("format");
                        if (jsonProperty == null) {
                            return;
                        }
                        JsonProperty formatProperty = jsonProperty;
                        AddFormatToSslConfProperty.access$changeFormatProperty(this.this$0, this.$editor, formatProperty);
                    }
                });
            }
        }

        private final void addToObject(PsiFile file, JsonProperty currentProperty) {
            PsiElement $this$asSafely$iv = currentProperty.getParent();
            boolean $i$f$asSafely = false;
            PsiElement psiElement = $this$asSafely$iv;
            if (!(psiElement instanceof JsonObject)) {
                psiElement = null;
            }
            JsonObject jsonObject = (JsonObject)psiElement;
            if (jsonObject == null) {
                return;
            }
            JsonObject currentObject = jsonObject;
            AddFormatToSslConfProperty this_$iv = this;
            boolean $i$f$addFormatProperty = false;
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            OpenFileAction.Companion.openFile(virtualFile, project);
            Editor editor2 = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor();
            if (editor2 != null) {
                Editor editor$iv = editor2;
                WriteCommandAction.writeCommandAction((Project)file.getProject()).withName(RestClientBundle.message("http.request.env.ssl.add.format.fix.action", new Object[0])).run(new ThrowableRunnable(this_$iv, editor$iv, file, currentObject){
                    final /* synthetic */ AddFormatToSslConfProperty this$0;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ PsiFile $file$inlined;
                    final /* synthetic */ JsonObject $currentObject$inlined;
                    {
                        this.this$0 = $receiver;
                        this.$editor = $editor;
                        this.$file$inlined = psiFile;
                        this.$currentObject$inlined = jsonObject;
                    }

                    public final void run() {
                        boolean bl = false;
                        JsonElementGenerator generator = new JsonElementGenerator(this.$file$inlined.getProject());
                        JsonProperty jsonProperty = generator.createProperty("format", generator.createStringLiteral("").getText());
                        Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"createProperty(...)");
                        JsonProperty formatProperty = jsonProperty;
                        JsonProperty jsonProperty2 = HttpClientEnvironmentsModificationsKt.addPropertyToObject(generator, this.$currentObject$inlined, formatProperty);
                        if (jsonProperty2 == null) {
                            return;
                        }
                        JsonProperty formatProperty2 = jsonProperty2;
                        AddFormatToSslConfProperty.access$changeFormatProperty(this.this$0, this.$editor, formatProperty2);
                    }
                });
            }
        }

        private final void addFormatProperty(PsiFile file, Function0<? extends JsonProperty> formatPropertyProvider) {
            boolean $i$f$addFormatProperty = false;
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            OpenFileAction.Companion.openFile(virtualFile, project);
            Editor editor2 = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor();
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            WriteCommandAction.writeCommandAction((Project)file.getProject()).withName(RestClientBundle.message("http.request.env.ssl.add.format.fix.action", new Object[0])).run(new ThrowableRunnable(formatPropertyProvider, this, editor3){
                final /* synthetic */ Function0<JsonProperty> $formatPropertyProvider;
                final /* synthetic */ AddFormatToSslConfProperty this$0;
                final /* synthetic */ Editor $editor;
                {
                    this.$formatPropertyProvider = $formatPropertyProvider;
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                }

                public final void run() {
                    JsonProperty jsonProperty = (JsonProperty)this.$formatPropertyProvider.invoke();
                    if (jsonProperty == null) {
                        return;
                    }
                    JsonProperty formatProperty = jsonProperty;
                    AddFormatToSslConfProperty.access$changeFormatProperty(this.this$0, this.$editor, formatProperty);
                }
            });
        }

        @RequiresWriteLock
        private final void changeFormatProperty(Editor editor2, JsonProperty formatProperty) {
            PsiDocumentManager.getInstance((Project)formatProperty.getProject()).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            JsonValue jsonValue = formatProperty.getValue();
            Intrinsics.checkNotNull((Object)jsonValue, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonStringLiteral");
            JsonStringLiteral literal = (JsonStringLiteral)jsonValue;
            TemplateBuilder templateBuilder2 = TemplateBuilderFactoryImpl.getInstance().createTemplateBuilder((PsiElement)literal);
            templateBuilder2.replaceElement((PsiElement)literal, new TextRange(0, literal.getTextLength()), (Expression)new MacroCallNode((Macro)new CompleteMacro()));
            templateBuilder2.run(editor2, true);
        }

        public static final /* synthetic */ void access$changeFormatProperty(AddFormatToSslConfProperty $this, Editor editor2, JsonProperty formatProperty) {
            $this.changeFormatProperty(editor2, formatProperty);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$AddToExistingEnvConsoleClickAction;", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "lineOffset", "", "<init>", "(I)V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "event", "Ljava/awt/event/InputEvent;", "getEnvironments", "", "", "context", "Lcom/intellij/psi/PsiFile;", "variableName", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestErrorFixFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$AddToExistingEnvConsoleClickAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 HttpClientEnvironmentsModifications.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentModificationResult\n+ 4 HttpClientEnvironmentsModifications.kt\ncom/intellij/httpClient/http/request/environment/HttpClientEnvironmentModificationResult$handleErrorForEditorAnd$1\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1#2:368\n49#3,9:369\n58#3,2:379\n49#4:378\n774#5:381\n865#5:382\n2632#5,3:383\n866#5:386\n1557#5:387\n1628#5,3:388\n*S KotlinDebug\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$AddToExistingEnvConsoleClickAction\n*L\n152#1:369,9\n152#1:379,2\n152#1:378\n177#1:381\n177#1:382\n177#1:383,3\n177#1:386\n182#1:387\n182#1:388,3\n*E\n"})
    private static final class AddToExistingEnvConsoleClickAction
    extends ConsoleClickAction {
        private final int lineOffset;

        public AddToExistingEnvConsoleClickAction(int lineOffset) {
            this.lineOffset = lineOffset;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull Project project, @NotNull Editor editor2, int offset, @NotNull InputEvent event) {
            List<String> list2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            int fileInfoLineNumber = editor2.getDocument().getLineNumber(offset) - this.lineOffset;
            Pair pair = Companion.getVariablePositionAndFileFromEditor(editor2, fileInfoLineNumber, project);
            if (pair == null) {
                return;
            }
            Pair pair2 = pair;
            VariablePosition errorInfo = (VariablePosition)pair2.component1();
            VirtualFile virtualFile = (VirtualFile)pair2.component2();
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile == null) {
                return;
            }
            PsiFile psiFile2 = psiFile;
            List<String> it = list2 = this.getEnvironments(editor2, psiFile2, errorInfo.getVariableName());
            boolean bl = false;
            List<String> list3 = !((Collection)it).isEmpty() ? list2 : null;
            if (list3 == null) {
                return;
            }
            List<String> allEnvironments = list3;
            if (allEnvironments.size() == 1) {
                void arg0$iv;
                Object object = HttpClientEnvironmentsModificationsKt.addVariableToEnvironment(project, (String)CollectionsKt.first(allEnvironments), errorInfo.getVariableName(), psiFile2, false);
                boolean bl2 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)arg0$iv);
                if (throwable != null) {
                    Throwable it$iv = throwable;
                    boolean bl3 = false;
                    if (!(it$iv instanceof HttpClientEnvironmentModificationFailedException)) {
                        throw it$iv;
                    }
                    HintManager.getInstance().showErrorHint(editor2, ((HttpClientEnvironmentModificationFailedException)it$iv).getMessage());
                    boolean bl4 = false;
                }
                return;
            }
            String string = RestClientBundle.message("rest.client.request.execute.environment.popup.header", new Object[0]);
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(allEnvironments, project, errorInfo, psiFile2, editor2, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ VariablePosition $errorInfo;
                final /* synthetic */ PsiFile $psiFile;
                final /* synthetic */ Editor $editor;
                {
                    this.$project = $project;
                    this.$errorInfo = $errorInfo;
                    this.$psiFile = $psiFile;
                    this.$editor = $editor;
                    super($super_call_param$1, $allEnvironments);
                }

                public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                    Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                    return this.doFinalStep(() -> execute.1.onChosen$lambda$0(this.$project, selectedValue, this.$errorInfo, this.$psiFile, this.$editor));
                }

                /*
                 * WARNING - void declaration
                 */
                private static final void onChosen$lambda$0(Project $project, String $selectedValue, VariablePosition $errorInfo, PsiFile $psiFile, Editor $editor) {
                    block1: {
                        void arg0$iv;
                        Object object = HttpClientEnvironmentsModificationsKt.addVariableToEnvironment($project, $selectedValue, $errorInfo.getVariableName(), $psiFile, false);
                        boolean bl = false;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)arg0$iv);
                        if (throwable == null) break block1;
                        Throwable it$iv = throwable;
                        boolean bl2 = false;
                        if (!(it$iv instanceof HttpClientEnvironmentModificationFailedException) || $editor == null) {
                            throw it$iv;
                        }
                        HintManager.getInstance().showErrorHint($editor, ((HttpClientEnvironmentModificationFailedException)it$iv).getMessage());
                        boolean bl3 = false;
                    }
                }
            }).showInBestPositionFor(editor2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getEnvironments(Editor editor2, PsiFile context, String variableName) {
            void $this$mapTo$iv$iv;
            HttpClientEnvironmentsProvider.EnvironmentDescriptor env;
            Iterable $this$filterTo$iv$iv;
            void $this$filter$iv;
            List<HttpClientEnvironmentsProvider.EnvironmentDescriptor> allEnvironments = HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(context).asList();
            if (allEnvironments.isEmpty()) {
                String string = RestClientBundle.message("http.client.request.error.message.add.to.env.no.env.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Companion.showMessage(editor2, string);
                return CollectionsKt.emptyList();
            }
            Iterable iterable = allEnvironments;
            boolean $i$f$filter2 = false;
            void var8_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block7: {
                    env = (HttpClientEnvironmentsProvider.EnvironmentDescriptor)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$none$iv = env.getVariables();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)variableName)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredEnvironments = (List)destination$iv$iv;
            if (filteredEnvironments.isEmpty()) {
                Object[] $i$f$filter2 = new Object[]{variableName};
                String string = RestClientBundle.message("http.client.request.error.message.add.to.env.already.has.var.error", $i$f$filter2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Companion.showMessage(editor2, string);
                return CollectionsKt.emptyList();
            }
            Iterable $this$map$iv = filteredEnvironments;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                env = (HttpClientEnvironmentsProvider.EnvironmentDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0018\u001a\u00020\u0005H\u0002J\u000f\u0010\u0019\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001aH\u0002J\u000f\u0010\u001b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$Companion;", "", "<init>", "()V", "VARIABLE_SEPARATOR", "", "getErrorInformationFromEditor", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNumber", "", "project", "Lcom/intellij/openapi/project/Project;", "getVariablePositionFromEditor", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$VariablePosition;", "getVariablePositionAndFileFromEditor", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileFromFileHyperlink", "fileHyperlinkRawData", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "showMessage", "", "message", "getSslFileFormatFixSuggestionMessage", "Lcom/intellij/openapi/util/NlsSafe;", "getSslFileFormatFixMessage", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestErrorFixFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,367:1\n1#2:368\n648#3,5:369\n*S KotlinDebug\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$Companion\n*L\n359#1:369,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final HttpRequestErrorFileFilter.ErrorInformation getErrorInformationFromEditor(Editor editor2, int lineNumber, Project project) {
            String fileInfoLine = ((Object)editor2.getDocument().getCharsSequence().subSequence(editor2.getDocument().getLineStartOffset(lineNumber), editor2.getDocument().getLineEndOffset(lineNumber))).toString();
            return HttpRequestErrorFileFilter.Companion.getInstance(project).getErrorInformation(fileInfoLine);
        }

        private final VariablePosition getVariablePositionFromEditor(Editor editor2, int lineNumber, Project project) {
            HttpRequestErrorFileFilter.ErrorInformation errorInformation = this.getErrorInformationFromEditor(editor2, lineNumber, project);
            if (errorInformation == null) {
                return null;
            }
            HttpRequestErrorFileFilter.ErrorInformation errorInformation2 = errorInformation;
            String variableName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)errorInformation2.getMessage(), (String)HttpRequestErrorFixFilter.VARIABLE_SEPARATOR, null, (int)2, null), (String)HttpRequestErrorFixFilter.VARIABLE_SEPARATOR, null, (int)2, null);
            String string = HttpClientJsonVariablesHelperKt.findJsonPathFirstKey(variableName);
            if (string == null) {
                string = variableName;
            }
            String firstKey = string;
            return new VariablePosition(errorInformation2.getPosition(), firstKey);
        }

        private final Pair<VariablePosition, VirtualFile> getVariablePositionAndFileFromEditor(Editor editor2, int lineNumber, Project project) {
            VariablePosition variablePosition = this.getVariablePositionFromEditor(editor2, lineNumber, project);
            if (variablePosition == null) {
                return null;
            }
            VariablePosition errorInfo = variablePosition;
            VirtualFile virtualFile = this.getFileFromFileHyperlink(errorInfo.getPosition());
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            return TuplesKt.to((Object)errorInfo, (Object)virtualFile2);
        }

        private final VirtualFile getFileFromFileHyperlink(FileHyperlinkRawData fileHyperlinkRawData) {
            VirtualFile virtualFile = LocalFileFinder.findFile((String)fileHyperlinkRawData.getFilePath());
            if (virtualFile == null) {
                virtualFile = TempFileSystem.getInstance().refreshAndFindFileByPath(fileHyperlinkRawData.getFilePath());
            }
            return virtualFile;
        }

        private final void showMessage(Editor editor2, @NlsContexts.HintText String message) {
            JComponent jComponent = HintUtil.createInformationLabel((String)message);
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createInformationLabel(...)");
            JComponent label = jComponent;
            Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getInformationColor()).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            Balloon balloon2 = balloon;
            RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor2);
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
            RelativePoint point = relativePoint;
            balloon2.show(point, Balloon.Position.above);
        }

        private final String getSslFileFormatFixSuggestionMessage() {
            Object[] objectArray = new Object[]{"", ""};
            String string = RestClientBundle.message("http.request.env.ssl.conf.guess.format.from.extension.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            char[] cArray = new char[]{'\n'};
            String string2 = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)1);
            return string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
        }

        /*
         * WARNING - void declaration
         */
        private final String getSslFileFormatFixMessage() {
            String string;
            int fixBeginWithoutSpaces;
            String suggestion;
            block4: {
                void $this$takeWhile$iv;
                String string2 = this.getSslFileFormatFixSuggestionMessage();
                if (string2 == null) {
                    return null;
                }
                suggestion = string2;
                Object object = StringsKt.indexOf$default((CharSequence)suggestion, (String)":", (int)0, (boolean)false, (int)6, null);
                int it = ((Number)object).intValue();
                boolean bl = false;
                Object object2 = !(it == -1) ? object : null;
                if (object2 == null) {
                    return null;
                }
                fixBeginWithoutSpaces = (Integer)object2 + 1;
                String string3 = suggestion.substring(fixBeginWithoutSpaces);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                object = string3;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it22 = $this$takeWhile$iv.charAt(index$iv);
                    int n2 = 0;
                    if (CharsKt.isWhitespace((char)it22)) continue;
                    void it22 = $this$takeWhile$iv;
                    n2 = 0;
                    String string4 = it22.substring(n2, index$iv);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    break block4;
                }
                string = $this$takeWhile$iv;
            }
            int spacesCount = string.length();
            int fixBegin = fixBeginWithoutSpaces + spacesCount;
            Integer n = StringsKt.indexOf$default((CharSequence)suggestion, (String)".", (int)0, (boolean)false, (int)6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n3 = !(it == -1) ? n : null;
            if (n3 == null) {
                return null;
            }
            int fixEnd = n3;
            String string5 = suggestion.substring(fixBegin, fixEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string5;
        }

        public static final /* synthetic */ String access$getSslFileFormatFixSuggestionMessage(Companion $this) {
            return $this.getSslFileFormatFixSuggestionMessage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u001a\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "Lcom/intellij/execution/filters/HyperlinkInfoBase;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "event", "Ljava/awt/event/InputEvent;", "navigate", "hyperlinkLocationPoint", "Lcom/intellij/ui/awt/RelativePoint;", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestErrorFixFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,367:1\n1#2:368\n*E\n"})
    private static abstract class ConsoleClickAction
    extends HyperlinkInfoBase {
        public abstract void execute(@NotNull Project var1, @NotNull Editor var2, int var3, @NotNull InputEvent var4);

        public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
            Object object;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (hyperlinkLocationPoint == null) {
                    LOG.warn("hyperlink location is null");
                    return;
                }
                Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
                Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
                for (Object object2 : (Object[])editorArray) {
                    Editor it = (Editor)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getContentComponent(), (Object)hyperlinkLocationPoint.getOriginalComponent())) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            Editor editor2 = (Editor)object;
            if (editor2 == null) {
                LOG.warn("Cannot find editor");
                return;
            }
            VisualPosition visualPosition = editor2.xyToVisualPosition(hyperlinkLocationPoint.getOriginalPoint());
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"xyToVisualPosition(...)");
            VisualPosition visualPosition2 = visualPosition;
            LogicalPosition logicalPosition = editor2.visualToLogicalPosition(visualPosition2);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"visualToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            int offset = editor2.logicalPositionToOffset(logicalPosition2);
            MouseEvent mouseEvent = hyperlinkLocationPoint.toMouseEvent();
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"toMouseEvent(...)");
            this.execute(project, editor2, offset, mouseEvent);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$CreateNewEnvFileConsoleClickAction;", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "lineOffset", "", "<init>", "(I)V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "event", "Ljava/awt/event/InputEvent;", "intellij.restClient"})
    private static final class CreateNewEnvFileConsoleClickAction
    extends ConsoleClickAction {
        private final int lineOffset;

        public CreateNewEnvFileConsoleClickAction(int lineOffset) {
            this.lineOffset = lineOffset;
        }

        @Override
        public void execute(@NotNull Project project, @NotNull Editor editor2, int offset, @NotNull InputEvent event) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            int fileInfoLineNumber = editor2.getDocument().getLineNumber(offset) - this.lineOffset;
            Pair pair = Companion.getVariablePositionAndFileFromEditor(editor2, fileInfoLineNumber, project);
            if (pair == null) {
                return;
            }
            Pair pair2 = pair;
            VariablePosition errorInfo = (VariablePosition)pair2.component1();
            VirtualFile virtualFile = (VirtualFile)pair2.component2();
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext editorDataContext = dataContext;
            DataContext dataContext2 = CustomizedDataContext.withSnapshot((DataContext)editorDataContext, arg_0 -> CreateNewEnvFileConsoleClickAction.execute$lambda$0(virtualFile, errorInfo, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"withSnapshot(...)");
            DataContext dataContext3 = dataContext2;
            AnAction action = ActionManager.getInstance().getAction("HTTPClientNewEnvironmentFile");
            AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"IntentionMenu", (DataContext)dataContext3);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
            AnActionEvent event2 = anActionEvent;
            event2.getPresentation().setPerformGroup(true);
            Intrinsics.checkNotNull((Object)action);
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event2);
        }

        private static final void execute$lambda$0(VirtualFile $virtualFile, VariablePosition $errorInfo, DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = LangDataKeys.VIRTUAL_FILE;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"VIRTUAL_FILE");
            sink.set(dataKey, (Object)$virtualFile);
            DataKey<String> dataKey2 = HttpClientDataKeys.ENV_VARIABLE_DEFAULT_NAME;
            Intrinsics.checkNotNullExpressionValue(dataKey2, (String)"ENV_VARIABLE_DEFAULT_NAME");
            sink.set(dataKey2, (Object)$errorInfo.getVariableName());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$QuickFixProvider;", "", "lineBegin", "", "currentLine", "", "<init>", "(ILjava/lang/String;)V", "getCurrentLine", "()Ljava/lang/String;", "addQuickFix", "Lcom/intellij/execution/filters/Filter$Result;", "message", "lineOffset", "quickFixFactory", "Lkotlin/Function1;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "intellij.restClient"})
    private static final class QuickFixProvider {
        private final int lineBegin;
        @NotNull
        private final String currentLine;

        public QuickFixProvider(int lineBegin, @NotNull String currentLine) {
            Intrinsics.checkNotNullParameter((Object)currentLine, (String)"currentLine");
            this.lineBegin = lineBegin;
            this.currentLine = currentLine;
        }

        @NotNull
        public final String getCurrentLine() {
            return this.currentLine;
        }

        @NotNull
        public final Filter.Result addQuickFix(@Nls @NotNull String message, int lineOffset, @NotNull Function1<? super Integer, ? extends HyperlinkInfo> quickFixFactory) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(quickFixFactory, (String)"quickFixFactory");
            int startIndex = StringsKt.indexOf$default((CharSequence)this.currentLine, (String)message, (int)0, (boolean)false, (int)6, null);
            return new Filter.Result(this.lineBegin + startIndex, this.lineBegin + startIndex + message.length(), (HyperlinkInfo)quickFixFactory.invoke((Object)lineOffset));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$RunWithEnvAction;", "Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$ConsoleClickAction;", "lineOffset", "", "<init>", "(I)V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "event", "Ljava/awt/event/InputEvent;", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpRequestErrorFixFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$RunWithEnvAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1#2:368\n774#3:369\n865#3:370\n1755#3,3:371\n866#3:374\n1557#3:375\n1628#3,3:376\n*S KotlinDebug\n*F\n+ 1 HttpRequestErrorFixFilter.kt\ncom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$RunWithEnvAction\n*L\n199#1:369\n199#1:370\n199#1:371,3\n199#1:374\n209#1:375\n209#1:376,3\n*E\n"})
    private static final class RunWithEnvAction
    extends ConsoleClickAction {
        private final int lineOffset;

        public RunWithEnvAction(int lineOffset) {
            this.lineOffset = lineOffset;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(@NotNull Project project, @NotNull Editor editor2, int offset, @NotNull InputEvent event) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object $this$any$iv;
            Iterable $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object;
            PsiElement it;
            PsiFile psiFile;
            VariablePosition errorInfo;
            block15: {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    int fileInfoLineNumber = editor2.getDocument().getLineNumber(offset) - this.lineOffset;
                    Pair pair = Companion.getVariablePositionAndFileFromEditor(editor2, fileInfoLineNumber, project);
                    if (pair == null) {
                        return;
                    }
                    Pair pair2 = pair;
                    errorInfo = (VariablePosition)pair2.component1();
                    VirtualFile virtualFile = (VirtualFile)pair2.component2();
                    PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile2 == null) {
                        return;
                    }
                    psiFile = psiFile2;
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                    if (document == null) {
                        return;
                    }
                    Document document2 = document;
                    int requestOffset = document2.getLineStartOffset(errorInfo.getPosition().getDocumentLine()) + errorInfo.getPosition().getDocumentColumn();
                    PsiElement psiElement = psiFile.findElementAt(requestOffset);
                    if (psiElement == null) break block14;
                    it = psiElement;
                    boolean bl = false;
                    object = (HttpClientExecutionBlock)PsiTreeUtil.getParentOfType((PsiElement)it, HttpClientExecutionBlock.class);
                    if (object != null) break block15;
                }
                return;
            }
            HttpClientExecutionBlock httpExecutionBlock = object;
            object = HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(psiFile).asList();
            boolean $i$f$filter2 = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block13: {
                    HttpClientEnvironmentsProvider.EnvironmentDescriptor env = (HttpClientEnvironmentsProvider.EnvironmentDescriptor)element$iv$iv;
                    boolean bl2 = false;
                    $this$any$iv = env.getVariables();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv = iterator.next();
                            String it2 = (String)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2, (Object)errorInfo.getVariableName())) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List environments = (List)destination$iv$iv;
            if (environments.isEmpty()) {
                Object[] $i$f$filter2 = new Object[]{errorInfo.getVariableName()};
                String string = RestClientBundle.message("http.client.request.error.message.run.with.env.no.env.error", $i$f$filter2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Companion.showMessage(editor2, string);
                return;
            }
            $this$filterTo$iv$iv = environments;
            HttpClientExecutionBlock httpClientExecutionBlock = httpExecutionBlock;
            HttpRequestActionsProvider.HttpRequestActionsProviderStrategy httpRequestActionsProviderStrategy = HttpRequestActionsProvider.wrapToActionOrGroup(HttpRequestActionsProvider.getRunWithEnvActionsProvider(), HttpRequestExecutorExtensionFactory.getRunExtension());
            boolean $i$f$map = false;
            void $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                $this$any$iv = (HttpClientEnvironmentsProvider.EnvironmentDescriptor)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it3.getName());
            }
            collection = (List)destination$iv$iv2;
            List<AnAction> list2 = httpRequestActionsProviderStrategy.provideActions(httpClientExecutionBlock, collection);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"provideActions(...)");
            AnAction runAction = (AnAction)CollectionsKt.first(list2);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor2.getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext editorContext = dataContext;
            DataContext dataContext2 = CustomizedDataContext.withSnapshot((DataContext)editorContext, arg_0 -> RunWithEnvAction.execute$lambda$4(httpExecutionBlock, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"withSnapshot(...)");
            DataContext dataContext3 = dataContext2;
            HttpRequestEnvironment.setDefaultEnvName(project, null);
            Intrinsics.checkNotNull((Object)runAction);
            ActionUtil.invokeAction((AnAction)runAction, (DataContext)dataContext3, (String)"unknown", (InputEvent)event, null);
        }

        private static final void execute$lambda$4(HttpClientExecutionBlock $httpExecutionBlock, DataSink sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = LangDataKeys.PSI_ELEMENT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT_ARRAY");
            HttpClientExecutionBlock[] httpClientExecutionBlockArray = new HttpClientExecutionBlock[]{$httpExecutionBlock};
            sink.set(dataKey, (Object)httpClientExecutionBlockArray);
            DataKey<Boolean> dataKey2 = HttpClientDataKeys.FORCE_USING_STORED_ENVIRONMENT;
            Intrinsics.checkNotNullExpressionValue(dataKey2, (String)"FORCE_USING_STORED_ENVIRONMENT");
            sink.set(dataKey2, (Object)true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/http/request/run/console/HttpRequestErrorFixFilter$VariablePosition;", "", "position", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "variableName", "", "<init>", "(Lcom/intellij/execution/filters/FileHyperlinkRawData;Ljava/lang/String;)V", "getPosition", "()Lcom/intellij/execution/filters/FileHyperlinkRawData;", "getVariableName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    private static final class VariablePosition {
        @NotNull
        private final FileHyperlinkRawData position;
        @NotNull
        private final String variableName;

        public VariablePosition(@NotNull FileHyperlinkRawData position, @NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            this.position = position;
            this.variableName = variableName;
        }

        @NotNull
        public final FileHyperlinkRawData getPosition() {
            return this.position;
        }

        @NotNull
        public final String getVariableName() {
            return this.variableName;
        }

        @NotNull
        public final FileHyperlinkRawData component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.variableName;
        }

        @NotNull
        public final VariablePosition copy(@NotNull FileHyperlinkRawData position, @NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            return new VariablePosition(position, variableName);
        }

        public static /* synthetic */ VariablePosition copy$default(VariablePosition variablePosition, FileHyperlinkRawData fileHyperlinkRawData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fileHyperlinkRawData = variablePosition.position;
            }
            if ((n & 2) != 0) {
                string = variablePosition.variableName;
            }
            return variablePosition.copy(fileHyperlinkRawData, string);
        }

        @NotNull
        public String toString() {
            return "VariablePosition(position=" + this.position + ", variableName=" + this.variableName + ")";
        }

        public int hashCode() {
            int result2 = this.position.hashCode();
            result2 = result2 * 31 + this.variableName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariablePosition)) {
                return false;
            }
            VariablePosition variablePosition = (VariablePosition)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)variablePosition.position)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.variableName, (Object)variablePosition.variableName);
        }
    }
}

