/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNodeGen;
import com.oracle.truffle.regex.tregex.string.Encodings;

public abstract class InputRegionMatchesNode
extends Node {
    public static InputRegionMatchesNode create() {
        return InputRegionMatchesNodeGen.create();
    }

    public abstract boolean execute(TruffleString var1, int var2, TruffleString var3, int var4, int var5, TruffleString.WithMask var6, Encodings.Encoding var7);

    @Specialization(guards={"mask == null"})
    public boolean doTString(TruffleString input, int fromIndex1, TruffleString match, int fromIndex2, int length2, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
        int fromByteIndexA = fromIndex1 << encoding.getStride();
        int fromByteIndexB = fromIndex2 << encoding.getStride();
        int byteLength = length2 << encoding.getStride();
        return input.byteLength(encoding.getTStringEncoding()) >= fromByteIndexA + byteLength && regionEqualsNode.execute((AbstractTruffleString)input, fromByteIndexA, match, fromByteIndexB, byteLength, encoding.getTStringEncoding());
    }

    @Fallback
    public boolean doTStringMask(TruffleString input, int fromIndex1, TruffleString match, int fromIndex2, int length2, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
        int fromByteIndexA = fromIndex1 << encoding.getStride();
        int fromByteIndexB = fromIndex2 << encoding.getStride();
        int byteLength = length2 << encoding.getStride();
        return input.byteLength(encoding.getTStringEncoding()) >= fromByteIndexA + byteLength && regionEqualsNode.execute((AbstractTruffleString)input, fromByteIndexA, mask, fromByteIndexB, byteLength, encoding.getTStringEncoding());
    }
}

