/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.vertica;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.vertica.VertTokens;
import com.intellij.sql.dialects.vertica.refactoring.VertExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VertDialect
extends SqlLanguageDialectBase {
    public static final VertDialect INSTANCE = new VertDialect();

    private VertDialect() {
        super("Vertica");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(VertTokens.class);
        if (tokensHelper == null) {
            VertDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "geom", "geometry", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "uuid", "uuid", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.VERTICA;
        if (dbms == null) {
            VertDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            VertDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = VertDialect.getScAndDb(dataSource);
        TreePatternNode.Group[] schemas = SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.first, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0]));
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames(dataSource), SqlDialectImplUtilCore.forcedContextExpandedToSchemas(dataSource, this.getDbms(), searchPath, schemas, SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.second, SqlDbElementType.DATABASE, schemas))));
        if (treePattern == null) {
            VertDialect.$$$reportNull$$$0(3);
        }
        return treePattern;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text2) {
        if (type == null) {
            VertDialect.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            VertDialect.$$$reportNull$$$0(5);
        }
        return SqlLexer.isValidRawCopyToken(text2);
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    public boolean supportsNaturalJoin() {
        return true;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            VertDialect.$$$reportNull$$$0(6);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlUpdateStatement.class, SqlMergeStatement.class}) != null;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, ObjectName @Nullable [] dsNames) {
        ObjectName dbName = VertDialect.getDbName(dataSource);
        DasNamespace namespace = VertDialect.getDefaultNamespace(dataSource, dbName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, namespace.getKind() == SqlDbElementType.SCHEMA ? null : TreePatternUtils.create(LazyData.PUBLIC_NAME, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                VertDialect.$$$reportNull$$$0(7);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbName, TreePatternUtils.create(LazyData.PUBLIC_NAME, SqlDbElementType.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(ObjectName @Nullable [] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            VertDialect.$$$reportNull$$$0(8);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Arrays.asList(ObjectName.quoted("v_internal"), ObjectName.quoted("v_catalog"), ObjectName.quoted("v_monitor")), false, SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA);
        if (treePattern == null) {
            VertDialect.$$$reportNull$$$0(9);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            VertDialect.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            VertDialect.$$$reportNull$$$0(11);
        }
        return 128;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == SqlDbElementType.PROJECTION) {
            result2.add((ObjectKind)SqlDbElementType.SCHEMA);
        }
        return super.getParentDbTypes(result2, type);
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return VertExtractFunctionHelper.INSTANCE;
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(true, false)));
    }

    @Nullable
    private static ObjectName getDbName(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig(dataSource);
        return ObjectName.plain((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName(config), (Object)SqlDialectImplUtilCore.getUserName(config)));
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource) {
        ObjectName dbName = VertDialect.getDbName(dataSource);
        ObjectName scName = null;
        DasNamespace namespace = VertDialect.getDefaultNamespace(dataSource, dbName);
        if (namespace != null) {
            DasObject parent;
            if (namespace.getKind() == SqlDbElementType.SCHEMA) {
                scName = ObjectName.quoted(namespace.getName());
            }
            if ((parent = namespace.getDasParent()) != null && parent.getKind() == SqlDbElementType.DATABASE) {
                dbName = ObjectName.quoted(parent.getName());
            }
        }
        if (scName == null) {
            scName = LazyData.PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 8, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/vertica/VertDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/vertica/VertDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 8, 11 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final ObjectName PUBLIC_NAME = ObjectName.quoted("public");
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2);
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(SqlDbElementType.KEY, SqlDbElementType.INDEX, SqlDbElementType.PROJECTION);

        LazyData() {
        }
    }
}

