/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.Stack;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ProfilerDumpWriterBase;
import com.intellij.profiler.model.NoThreadInfoInProfilerData;
import com.intellij.profiler.model.ThreadInfo;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/api/CollapsedProfilerDumpWriter;", "Lcom/intellij/profiler/api/ProfilerDumpWriterBase;", "data", "Lcom/intellij/profiler/CallTreeBuilder;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "name", "", "timeStamp", "", "frameWriter", "Lkotlin/Function1;", "threadWriter", "Lcom/intellij/profiler/model/ThreadInfo;", "<init>", "(Lcom/intellij/profiler/CallTreeBuilder;Ljava/lang/String;JLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "writeDump", "", "outputFile", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.profiler.common"})
public final class CollapsedProfilerDumpWriter
extends ProfilerDumpWriterBase {
    @NotNull
    private final CallTreeBuilder<BaseCallStackElement> data;
    @NotNull
    private final Function1<BaseCallStackElement, String> frameWriter;
    @NotNull
    private final Function1<ThreadInfo, String> threadWriter;

    public CollapsedProfilerDumpWriter(@NotNull CallTreeBuilder<BaseCallStackElement> data, @NotNull String name, long timeStamp, @NotNull Function1<? super BaseCallStackElement, String> frameWriter, @NotNull Function1<? super ThreadInfo, String> threadWriter) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(frameWriter, (String)"frameWriter");
        Intrinsics.checkNotNullParameter(threadWriter, (String)"threadWriter");
        super(name, timeStamp, "collapsed");
        this.data = data;
        this.frameWriter = frameWriter;
        this.threadWriter = threadWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDump(@NotNull File outputFile, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object object = outputFile;
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)object;
            boolean bl = false;
            indicator.checkCanceled();
            Iterable<Stack<BaseCallStackElement>> stacks = this.data.getAllStacks();
            for (Stack<BaseCallStackElement> stack : stacks) {
                if (stack.getThread() != NoThreadInfoInProfilerData.INSTANCE) {
                    writer.append((CharSequence)this.threadWriter.invoke((Object)stack.getThread()));
                    writer.append(";");
                }
                writer.append(CollectionsKt.joinToString$default((Iterable)stack.getFrames(), (CharSequence)";", null, null, (int)0, null, arg_0 -> CollapsedProfilerDumpWriter.writeDump$lambda$1$lambda$0(this, arg_0), (int)30, null));
                Appendable appendable = ((Appendable)writer).append(" " + stack.getValue());
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                StringsKt.appendln((Appendable)appendable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private static final CharSequence writeDump$lambda$1$lambda$0(CollapsedProfilerDumpWriter this$0, BaseCallStackElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)this$0.frameWriter.invoke((Object)it);
    }
}

