/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VueClassicServiceWrapper;
import org.jetbrains.vuejs.lang.typescript.service.VueLspServiceWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "classicLanguageService", "Lorg/jetbrains/vuejs/lang/typescript/service/VueClassicServiceWrapper;", "getClassicLanguageService", "()Lorg/jetbrains/vuejs/lang/typescript/service/VueClassicServiceWrapper;", "classicLanguageService$delegate", "Lkotlin/Lazy;", "lspLanguageService", "Lorg/jetbrains/vuejs/lang/typescript/service/VueLspServiceWrapper;", "getLspLanguageService", "()Lorg/jetbrains/vuejs/lang/typescript/service/VueLspServiceWrapper;", "lspLanguageService$delegate", "allServices", "", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "getAllServices", "()Ljava/util/List;", "getService", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isHighlightingCandidate", "", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueLanguageServiceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueLanguageServiceProvider.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,48:1\n295#2,2:49\n31#3,2:51\n31#3,2:53\n*S KotlinDebug\n*F\n+ 1 VueLanguageServiceProvider.kt\norg/jetbrains/vuejs/lang/typescript/service/VueLanguageServiceProvider\n*L\n24#1:49,2\n18#1:51,2\n19#1:53,2\n*E\n"})
public final class VueLanguageServiceProvider
implements JSLanguageServiceProvider {
    @NotNull
    private final Lazy classicLanguageService$delegate;
    @NotNull
    private final Lazy lspLanguageService$delegate;

    public VueLanguageServiceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.classicLanguageService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VueLanguageServiceProvider.classicLanguageService_delegate$lambda$0(project));
        this.lspLanguageService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> VueLanguageServiceProvider.lspLanguageService_delegate$lambda$1(project));
    }

    private final VueClassicServiceWrapper getClassicLanguageService() {
        Lazy lazy = this.classicLanguageService$delegate;
        return (VueClassicServiceWrapper)lazy.getValue();
    }

    private final VueLspServiceWrapper getLspLanguageService() {
        Lazy lazy = this.lspLanguageService$delegate;
        return (VueLspServiceWrapper)lazy.getValue();
    }

    @NotNull
    public List<JSLanguageService> getAllServices() {
        Object[] objectArray = new JSLanguageService[]{this.getClassicLanguageService().getService(), this.getLspLanguageService().getService()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public JSLanguageService getService(@NotNull VirtualFile file) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable $this$firstOrNull$iv = this.getAllServices();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JSLanguageService it = (JSLanguageService)element$iv;
                boolean bl = false;
                if (!it.isAcceptable(file)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public boolean isHighlightingCandidate(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptLanguageServiceProvider.isJavaScriptOrTypeScriptFileType((FileType)file.getFileType()) || VueFileTypeKt.isVueFile(file);
    }

    private static final VueClassicServiceWrapper classicLanguageService_delegate$lambda$0(Project $project) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<VueClassicServiceWrapper> serviceClass$iv = VueClassicServiceWrapper.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VueClassicServiceWrapper)object;
    }

    private static final VueLspServiceWrapper lspLanguageService_delegate$lambda$1(Project $project) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<VueLspServiceWrapper> serviceClass$iv = VueLspServiceWrapper.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (VueLspServiceWrapper)object;
    }
}

