/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.bundler;

import com.intellij.lang.javascript.buildTools.bundler.WebBundlerDefinition;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerDefinitionsProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerNotifier;", "", "<init>", "()V", "lastMessages", "Ljava/util/concurrent/ConcurrentHashMap;", "", "notify", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "type", "Lcom/intellij/openapi/ui/MessageType;", "path", "bundlerId", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nWebBundlerNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBundlerNotifier.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerNotifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public final class WebBundlerNotifier {
    @NotNull
    public static final WebBundlerNotifier INSTANCE = new WebBundlerNotifier();
    @NotNull
    private static final ConcurrentHashMap<String, String> lastMessages = new ConcurrentHashMap();

    private WebBundlerNotifier() {
    }

    public final void notify(@NotNull Project project, @NlsContexts.NotificationContent @NotNull String message, @NotNull MessageType type, @NotNull String path2, @NotNull String bundlerId, @Nullable AnAction action) {
        Notification notification;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)bundlerId, (String)"bundlerId");
        if (Intrinsics.areEqual((Object)lastMessages.put(path2, message), (Object)message)) {
            return;
        }
        WebBundlerDefinition webBundlerDefinition = WebBundlerDefinitionsProvider.Companion.getInstance(project).findDefinitionById(bundlerId);
        if (webBundlerDefinition == null) {
            return;
        }
        WebBundlerDefinition bundlerDefinition = webBundlerDefinition;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(bundlerDefinition.getId());
        String string = bundlerDefinition.getPresentation();
        NotificationType notificationType = type.toNotificationType();
        Intrinsics.checkNotNullExpressionValue((Object)notificationType, (String)"toNotificationType(...)");
        Notification it = notification = notificationGroup.createNotification(string, message, notificationType).setListener((arg_0, arg_1) -> WebBundlerNotifier.notify$lambda$0(path2, project, arg_0, arg_1));
        boolean bl = false;
        if (action != null) {
            it.addAction(action);
        }
        notification.notify(project);
    }

    public static /* synthetic */ void notify$default(WebBundlerNotifier webBundlerNotifier, Project project, String string, MessageType messageType, String string2, String string3, AnAction anAction, int n, Object object) {
        if ((n & 0x20) != 0) {
            anAction = null;
        }
        webBundlerNotifier.notify(project, string, messageType, string2, string3, anAction);
    }

    private static final void notify$lambda$0(String $path, Project $project, Notification notification, HyperlinkEvent hyperlinkEvent) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)hyperlinkEvent, (String)"<unused var>");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)$path));
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        OpenFileDescriptor descriptor = new OpenFileDescriptor($project, file);
        FileEditorManager.getInstance((Project)$project).openTextEditor(descriptor, true);
    }
}

