/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterListStub;
import com.intellij.lang.javascript.psi.util.JSDestructuringVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSParameterListImpl
extends JSStubElementImpl<JSParameterListStub>
implements JSParameterList {
    private volatile JSParameter[] myParameters;
    private volatile JSParameterListElement[] myCallParameters;
    private static final TokenSet SIMPLE_PARAMETERS = TokenSet.andNot((TokenSet)JSExtendedLanguagesTokenSetProvider.PARAMETERS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_PARAMETER}));
    private static final TokenSet DESTUCTURING_CONSTRUCTS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS, JSElementTypes.DESTRUCTURING_CONTAINERS});

    public JSParameterListImpl(ASTNode node) {
        super(node);
    }

    public JSParameterListImpl(JSParameterListStub stub) {
        this(stub, (IStubElementType)JSStubElementTypes.PARAMETER_LIST);
    }

    protected JSParameterListImpl(JSParameterListStub stub, IStubElementType type) {
        super(stub, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSParameter @NotNull [] getParameterVariables() {
        JSParameter[] parameters = this.myParameters;
        if (parameters == null) {
            JSParameterListImpl jSParameterListImpl = this;
            synchronized (jSParameterListImpl) {
                parameters = this.myParameters;
                if (parameters == null) {
                    parameters = this.calcParameters();
                    this.myParameters = parameters;
                }
            }
        }
        if (parameters == null) {
            JSParameterListImpl.$$$reportNull$$$0(0);
        }
        return parameters;
    }

    protected JSParameter @NotNull [] calcParameters() {
        JSParameter[] parameters = this.getRawParameters();
        JSElement[] destructuringParameters = (JSElement[])this.getStubOrPsiChildren(DESTUCTURING_CONSTRUCTS, JSElement.ARRAY_FACTORY);
        if (destructuringParameters.length != 0) {
            final ArrayList destrParameters = new ArrayList();
            JSDestructuringVisitor visitor = new JSDestructuringVisitor(){

                @Override
                public void visitJSParameter(@NotNull JSParameter node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    destrParameters.add(node);
                }

                @Override
                public void visitJSVariable(@NotNull JSVariable node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSParameterListImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSParameter";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJSVariable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            visitor.visitJSParameterList(this);
            parameters = new JSParameter[destrParameters.size()];
            destrParameters.toArray(parameters);
        }
        if (parameters == null) {
            JSParameterListImpl.$$$reportNull$$$0(1);
        }
        return parameters;
    }

    protected JSParameter @NotNull [] getRawParameters() {
        JSParameter[] jSParameterArray = (JSParameter[])this.getStubOrPsiChildren(SIMPLE_PARAMETERS, JSParameter.ARRAY_FACTORY);
        if (jSParameterArray == null) {
            JSParameterListImpl.$$$reportNull$$$0(2);
        }
        return jSParameterArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public JSParameterListElement @NotNull [] getParameters() {
        JSParameterListElement[] parameters = this.myCallParameters;
        if (parameters != null) {
            if (parameters != null) return parameters;
            JSParameterListImpl.$$$reportNull$$$0(3);
            return parameters;
        }
        JSParameterListImpl jSParameterListImpl = this;
        // MONITORENTER : jSParameterListImpl
        parameters = this.myCallParameters;
        if (parameters == null) {
            parameters = this.calcCallParameters();
            this.myCallParameters = parameters;
        }
        // MONITOREXIT : jSParameterListImpl
        if (parameters != null) return parameters;
        JSParameterListImpl.$$$reportNull$$$0(4);
        return parameters;
    }

    protected JSParameterListElement[] calcCallParameters() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.DESTRUCTURING_PARAMETERS)) {
            return this.getParameterVariables();
        }
        PsiElement[] children = this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.PARAMETERS, PsiElement.ARRAY_FACTORY);
        ArrayList<JSParameterListElement> result2 = new ArrayList<JSParameterListElement>();
        for (PsiElement child : children) {
            if (child instanceof JSParameter) {
                result2.add((JSParameter)child);
                continue;
            }
            if (!(child instanceof JSDestructuringParameter)) continue;
            result2.add((JSDestructuringParameter)child);
        }
        return result2.toArray(JSParameterListElement.EMPTY_ARRAY);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSParameterListImpl.$$$reportNull$$$0(5);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSParameterList(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public void clearCaches() {
        this.myParameters = null;
        this.myCallParameters = null;
        super.clearCaches();
    }

    public static boolean handleChildDeletion(@NotNull JSParameterListElement element) {
        PsiElement parent;
        if (element == null) {
            JSParameterListImpl.$$$reportNull$$$0(6);
        }
        if ((parent = element.getParent()) instanceof JSParameterList) {
            JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)element, (PsiElement[])((JSParameterList)parent).getParameters());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSParameterListImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterVariables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawParameters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSParameterListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleChildDeletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

