/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

class JSResolveStatus {
    @Nullable
    final JSElement myImportUsed;
    final JSResolveResult.ProblemKind myResolveProblem;
    private final JSTypeSubstitutor mySubstitutor;

    JSResolveStatus(@Nullable JSElement importElement, JSResolveResult.ProblemKind resolveProblem, @Nullable JSTypeSubstitutor substitutor) {
        this.myImportUsed = importElement;
        this.myResolveProblem = resolveProblem;
        this.mySubstitutor = substitutor;
    }

    @Nullable
    public JSTypeSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSResolveStatus status = (JSResolveStatus)o;
        return Objects.equals(this.myImportUsed, status.myImportUsed) && Objects.equals((Object)this.myResolveProblem, (Object)status.myResolveProblem) && Objects.equals(this.mySubstitutor, status.mySubstitutor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myImportUsed, this.myResolveProblem, this.mySubstitutor});
    }

    public String toString() {
        return "JSResolveStatus{hasImportUsed=" + (this.myImportUsed != null) + ", myResolveProblem=" + (this.myResolveProblem != null ? "'" + this.myResolveProblem.getMessageKey() + "'" : null) + ", hasSubstitutor=" + (this.mySubstitutor != null) + "}";
    }
}

