/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypeImpl
extends JSTypeBaseImpl {
    private static final Logger LOGGER = Logger.getInstance(JSGenericTypeImpl.class);
    @NotNull
    private final JSType myType;
    @NotNull
    private final List<JSType> myArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull JSType argument) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(1);
        }
        if (argument == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(2);
        }
        this(source, type, Collections.singletonList(argument));
    }

    JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(4);
        }
        this(source, JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream), JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream));
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(7);
        }
        super(source);
        this.myType = type;
        List<JSType> fixedList = JSGenericTypeImpl.computeActualArguments(type, arguments);
        this.myArguments = Collections.unmodifiableList(fixedList);
    }

    @NotNull
    private static List<JSType> computeActualArguments(@NotNull JSType type, @NotNull List<JSType> arguments) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(8);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(9);
        }
        if (ContainerUtil.all(arguments, arg -> arg != null && !(arg instanceof JSNamedTypeSubstitutorType))) {
            List<JSType> list = arguments;
            if (list == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<JSType> newArgs = new ArrayList<JSType>(arguments.size());
        PsiElement sourceElement = type.getSource().getSourceElement();
        List typeParameterNames = null;
        if (sourceElement instanceof TypeScriptTypeParameterListOwner) {
            typeParameterNames = ContainerUtil.map((Object[])((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameters(), p -> p.getName());
        }
        Int2ObjectOpenHashMap toInsert = new Int2ObjectOpenHashMap();
        for (JSType arg2 : arguments) {
            if (arg2 instanceof JSNamedTypeSubstitutorType) {
                int index;
                if (typeParameterNames == null || (index = typeParameterNames.indexOf(((JSNamedTypeSubstitutorType)arg2).getGenericName())) == -1) continue;
                toInsert.put(index, (Object)((JSNamedTypeSubstitutorType)arg2).getRealType());
                continue;
            }
            if (arg2 == null) {
                LOGGER.error("Generic argument must be not null");
                arg2 = JSAnyType.get(type.getSource());
            }
            newArgs.add(arg2);
        }
        int[] keys = toInsert.keySet().toIntArray();
        Arrays.sort(keys);
        for (int key : keys) {
            if (key < newArgs.size()) continue;
            newArgs.add((JSType)toInsert.get(key));
        }
        ArrayList<JSType> arrayList = newArgs;
        if (arrayList == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(12);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myArguments, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(13);
        }
        this.myType.accept(visitor);
        for (JSType argument : this.getArguments()) {
            argument.accept(visitor);
        }
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(14);
        }
        if (builder2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(15);
        }
        if (!this.isTypeScript()) {
            boolean wrapInBraces = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (wrapInBraces) {
                builder2.append("(");
            }
            this.myType.buildTypeText(format, builder2);
            if (wrapInBraces) {
                builder2.append(")");
            }
            if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
                builder2.append(".");
            }
            this.appendArgumentTypeText(format, builder2);
            return;
        }
        boolean isNestedFunctionType = this.myType instanceof JSFunctionTypeImpl;
        if (isNestedFunctionType) {
            this.appendArgumentTypeText(format, builder2);
            this.myType.buildTypeText(format, builder2);
        } else {
            this.myType.buildTypeText(format, builder2);
            this.appendArgumentTypeText(format, builder2);
        }
    }

    @Override
    protected int hashCodeImpl() {
        int arguments = JSTypeHashCodeUtil.getHashCode(this.getArguments());
        return Objects.hash(this.getType(), arguments);
    }

    private void appendArgumentTypeText(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(16);
        }
        if (builder2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(17);
        }
        builder2.append("<");
        String prefix = "";
        for (JSType argument : this.myArguments) {
            builder2.append(prefix);
            argument.buildTypeText(format, builder2);
            prefix = ", ";
        }
        builder2.append(">");
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    private static boolean isResolvedTypeScript(@NotNull JSType type) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(18);
        }
        if (type.isEcma()) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSType nested = ((JSGenericTypeImpl)type).getType();
            return JSGenericTypeImpl.isResolvedTypeScript(nested);
        }
        if (type instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
            Collection<? extends PsiElement> declarations = info.getDeclarations();
            return !declarations.isEmpty() && ContainerUtil.and(declarations, el -> DialectDetector.isTypeScript(el));
        }
        return false;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(19);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(20);
        }
        if (this.myArguments.isEmpty()) {
            return this.myType.isDirectlyAssignableType(elementType, processingContext);
        }
        if (this.isTypeScript() || JSGenericTypeImpl.isResolvedTypeScript(elementType)) {
            return this.isDirectAssignableTypeInTypeScript(elementType, processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                return false;
            }
            List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).getArguments();
            ListIterator<JSType> iterator = elementTypeArgs.listIterator();
            boolean allArgumentsEquivalent = true;
            for (JSType argument : this.getArguments()) {
                allArgumentsEquivalent &= iterator.hasNext() && this.jsOrASGenericsCompatible(argument, iterator.next(), processingContext);
            }
            return allArgumentsEquivalent && !iterator.hasNext();
        }
        if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
            return false;
        }
        if (elementType instanceof JSArrayType && !((JSArrayType)elementType).isPrimitive()) {
            return this.isDirectlyAssignableType(((JSArrayType)elementType).asGenericType(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    private boolean isDirectAssignableTypeInTypeScript(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult type;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(21);
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        if (elementType instanceof JSTupleType) {
            return this.isDirectlyAssignableType(((JSTupleType)elementType).toArrayType(true), processingContext);
        }
        if (elementType instanceof JSArrayType) {
            elementType = ((JSArrayType)elementType).asGenericType();
        } else {
            JSType resolved;
            if (elementType instanceof JSUnionType) {
                JSUnionType composite = (JSUnionType)elementType;
                boolean isAssignable = true;
                for (JSType type2 : composite.getTypes()) {
                    if (this.isDirectlyAssignableType(type2, processingContext)) continue;
                    isAssignable = false;
                    break;
                }
                return isAssignable;
            }
            if (elementType instanceof JSRecordType && this != (resolved = this.substituteOrRecordType(processingContext))) {
                return resolved.isDirectlyAssignableType(elementType, processingContext);
            }
        }
        if ((elementType instanceof JSGenericTypeImpl || elementType instanceof JSNamedType) && (type = JSTypeCastUtil.isDirectlyAssignableInClassHierarchy(this, elementType, processingContext)).isStrict()) {
            return type.isAssignable();
        }
        if (elementType instanceof JSIntersectionType && this.isDirectlyAssignableForIntersection(elementType, processingContext)) {
            return true;
        }
        JSType resolved = this.substituteOrRecordType(processingContext);
        if (resolved != this) {
            JSType rTypeNested = JSGenericTypeImpl.getGenericOwnerIdOrSelfId(elementType);
            JSType lTypeNested = this.getType();
            return JSRecursiveTypeUtil.computeGenericRecursiveTypes(lTypeNested, rTypeNested, elementType, processingContext, resolved::isDirectlyAssignableType);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private boolean isDirectlyAssignableForIntersection(@NotNull JSType type, @NotNull ProcessingContext context2) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(23);
        }
        if (!(type instanceof JSIntersectionType)) {
            return false;
        }
        boolean forGenerics = JSGenericTypesEvaluator.isGenericProcessingInProgress(context2);
        return JSTypeCastUtil.executeJoinInferredGenerics((Processor<? super ProcessingContext>)((Processor)newContext -> {
            boolean isAssignable = false;
            for (JSType jsType : ((JSIntersectionType)type).getTypes()) {
                if ((isAssignable |= this.isDirectlyAssignableType(jsType, (ProcessingContext)newContext)) || forGenerics) continue;
                return false;
            }
            return isAssignable;
        }), context2, this.getSource(), true);
    }

    @NotNull
    public static JSType getGenericOwnerIdOrSelfId(@NotNull JSType elementType) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(24);
        }
        if (elementType instanceof JSAliasTypeImpl) {
            elementType = ((JSAliasTypeImpl)elementType).getAlias();
        }
        if (elementType instanceof TypeScriptCompilerType) {
            TypeScriptCompilerType tscType = (TypeScriptCompilerType)elementType;
            elementType = tscType.getTargetOrSelf();
        }
        JSType jSType = elementType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)elementType).getType() : elementType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @NotNull
    private JSType substituteOrRecordType(@NotNull ProcessingContext processingContext) {
        JSType resolved;
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(26);
        }
        if ((resolved = this.forceExpand(JSGenericTypeImpl.createSubstitutionContextForAssignability(processingContext))) == this) {
            JSRecordType jSRecordType = resolved.asRecordType((PsiElement)processingContext.get(JSTypeComparingContextService.LOCATION));
            if (jSRecordType == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(27);
            }
            return jSRecordType;
        }
        JSType jSType = resolved;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(28);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(29);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(30);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(31);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(32);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(33);
        }
        if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext, allowResolve)) {
            return false;
        }
        return JSTypeCastUtil.areListsEquivalent(this.myArguments, ((JSGenericTypeImpl)type).myArguments, processingContext, allowResolve);
    }

    private boolean jsOrASGenericsCompatible(@NotNull JSType type1, @NotNull JSType type2, @Nullable ProcessingContext processingContext) {
        if (type1 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(34);
        }
        if (type2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(35);
        }
        if (type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (this.isEcma()) {
            return false;
        }
        if ("Array".equals(JSTypeUtils.getQualifiedNameMatchingType(this.myType, false))) {
            return type1.isDirectlyAssignableType(type2, processingContext);
        }
        return type1.isDirectlyAssignableType(type2, processingContext) || type2.isDirectlyAssignableType(type1, processingContext);
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            if (type.getSource().isEcma()) {
                return JSNamedType.isNamedTypeWithName(genericType.myType, "Vector") && genericType.getArguments().size() == 1;
            }
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(36);
        }
        return jSType;
    }

    @NotNull
    public List<JSType> getArguments() {
        List<JSType> list = this.myArguments;
        if (list == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(38);
        }
        if (newSource == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(39);
        }
        JSType oldType = this.getType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        List<JSType> oldArgs = this.getArguments();
        List newArgs = ContainerUtil.map(oldArgs, type -> JSTypeUtils.transformTypeHierarchySafe(type, childTransform));
        if (newType == oldType && ContainerUtil.equalsIdentity(oldArgs, (List)newArgs)) {
            JSGenericTypeImpl jSGenericTypeImpl = this;
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(40);
            }
            return jSGenericTypeImpl;
        }
        if (newType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl newGenericType = (JSGenericTypeImpl)newType;
            return new JSGenericTypeImpl(newSource, newGenericType.getType(), newGenericType.getArguments());
        }
        return new JSGenericTypeImpl(newSource, newType, newArgs);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(41);
        }
        return new JSGenericTypeImpl(source, this.getType(), this.getArguments());
    }

    @NotNull
    public JSType forceExpand(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(42);
        }
        context2.putUserData(IS_FORCED_SUBSTITUTION, true);
        JSType jSType = (JSType)ObjectUtils.notNull((Object)this.substitute(context2), (Object)this);
        JSType jSType2 = jSType;
        if (jSType2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(43);
        }
        return jSType2;
        finally {
            context2.putUserData(IS_FORCED_SUBSTITUTION, null);
        }
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        boolean forceExpand;
        JSType owner;
        if (context2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(44);
        }
        JSType type = this.getType();
        if (this.myArguments.isEmpty()) {
            return type;
        }
        if (type instanceof TypeScriptGenericThisTypeImpl && (owner = ((TypeScriptGenericThisTypeImpl)type).getOwnerType()) != null) {
            return new JSGenericTypeImpl(this.getSource(), owner, this.getArguments()).substitute(context2);
        }
        if (this.isJavaScript() && this.myArguments.size() == 2 && JSNamedType.isNamedTypeWithName(type, "Object")) {
            JSType recordType = JSNamedTypeFactory.createType("Record", type.getSource(), JSContext.INSTANCE);
            return new JSGenericTypeImpl(this.getSource(), recordType, this.getArguments());
        }
        PsiElement sourceElement = this.getSourceElement();
        if (sourceElement instanceof JSDocComment && (!(type instanceof JSTypeImpl) || ((JSTypeImpl)type).resolveType().getAliasedType() == null && ((JSTypeImpl)type).getJSTypedef() == null)) {
            return this;
        }
        boolean bl = forceExpand = context2.getUserData(IS_FORCED_SUBSTITUTION) == Boolean.TRUE;
        if (!forceExpand && this.isTypeScript() && context2.getUserData(IS_CHECKING_ASSIGNABILITY) == Boolean.TRUE) {
            return this;
        }
        context2.putUserData(IS_FORCED_SUBSTITUTION, null);
        return JSGenericTypeImpl.expandForGenericType(context2, this);
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        JSType substitute;
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(45);
        }
        if ((substitute = this.substitute(processingContext)) == this) {
            substitute = substitute.asRecordType();
        }
        if (!(substitute instanceof JSNotARecordType)) {
            List<JSType> typeStream = substitute.getFunctionTypes(processingContext, newCallSignatures).toList();
            Stream<JSType> stream = typeStream.stream();
            if (stream == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(46);
            }
            return stream;
        }
        JSType innerType = this.getType();
        Stream<JSType> stream = innerType.getFunctionTypes(processingContext, newCallSignatures).map(functionType -> {
            if (this.isSourceStrict() && !this.isTypeScript()) {
                JSType resultType;
                PsiFile scope2 = this.getScope();
                JSType jSType = resultType = scope2 != null ? JSTypeUtils.applyJSGenericsForType(this.getArguments(), innerType, scope2, functionType) : functionType;
                if (resultType != functionType) {
                    return resultType;
                }
            }
            PsiElement sourceElement = functionType.getSource().getSourceElement();
            if (functionType instanceof JSFunctionTypeImpl) {
                TypeScriptTypeParameter[] tsSignatureTypeParameters;
                if (sourceElement instanceof TypeScriptFunction && (tsSignatureTypeParameters = TypeScriptPsiUtil.getTypeParametersForOwner(sourceElement)).length > 0) {
                    JSTypeSubstitutor arguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(tsSignatureTypeParameters, this.getArguments());
                    return JSTypeUtils.applyGenericArguments(functionType, arguments);
                }
                return functionType;
            }
            return new JSGenericTypeImpl(this.getSource(), (JSType)functionType, this.getArguments());
        });
        if (stream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(47);
        }
        return stream;
    }

    @Nullable
    private static JSType expandForGenericType(@NotNull JSTypeSubstitutionContext context2, @NotNull JSGenericTypeImpl originalType) {
        JSGenericTypeImpl aliasGenericType;
        JSType alias;
        List<JSType> originalArguments;
        List arguments;
        JSType nestedType;
        JSType expanded;
        if (context2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(48);
        }
        if (originalType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(49);
        }
        if ((expanded = (nestedType = originalType.getType()).substitute(context2.withGenerics(arguments = ContainerUtil.map(originalArguments = originalType.getArguments(), type -> {
            JSType result2 = context2.substituteNested((JSType)type);
            return result2 == null ? JSAnyType.get(type.getSource()) : result2;
        })))) == nestedType) {
            return originalType;
        }
        if (expanded instanceof JSAliasTypeImpl && (alias = ((JSAliasTypeImpl)expanded).getAlias()) instanceof JSGenericTypeImpl && (aliasGenericType = (JSGenericTypeImpl)alias).getType() == nestedType && ContainerUtil.equalsIdentity(aliasGenericType.getArguments(), originalArguments)) {
            return new JSAliasTypeImpl(originalType, ((JSAliasTypeImpl)expanded).getOriginalType(), expanded.getSource());
        }
        return expanded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 25, 27, 28, 31, 32, 36, 37, 40, 43, 46, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 18: 
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 10: 
            case 11: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 19: 
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 20: 
            case 26: 
            case 30: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 23: 
            case 42: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeActualArguments";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericOwnerIdOrSelfId";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteOrRecordType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "forceExpand";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeActualArguments";
                break;
            }
            case 10: 
            case 11: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 47: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentTypeText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedTypeScript";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeInTypeScript";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableForIntersection";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getGenericOwnerIdOrSelfId";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "substituteOrRecordType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "jsOrASGenericsCompatible";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "forceExpand";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "expandForGenericType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 25, 27, 28, 31, 32, 36, 37, 40, 43, 46, 47 -> new IllegalStateException(string);
        };
    }
}

