/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceUpdateContext;", "", "unsavedContents", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/editor/Document;", "openContents", "timestamps", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getUnsavedContents", "()Ljava/util/Map;", "getOpenContents", "getTimestamps", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.impl"})
public final class JSLanguageServiceUpdateContext {
    @NotNull
    private final Map<VirtualFile, Document> unsavedContents;
    @NotNull
    private final Map<VirtualFile, Document> openContents;
    @NotNull
    private final Map<VirtualFile, Long> timestamps;

    public JSLanguageServiceUpdateContext(@NotNull Map<VirtualFile, ? extends Document> unsavedContents, @NotNull Map<VirtualFile, ? extends Document> openContents, @NotNull Map<VirtualFile, Long> timestamps) {
        Intrinsics.checkNotNullParameter(unsavedContents, (String)"unsavedContents");
        Intrinsics.checkNotNullParameter(openContents, (String)"openContents");
        Intrinsics.checkNotNullParameter(timestamps, (String)"timestamps");
        this.unsavedContents = unsavedContents;
        this.openContents = openContents;
        this.timestamps = timestamps;
        if (!this.timestamps.keySet().containsAll((Collection)this.unsavedContents.keySet()) || !this.timestamps.keySet().containsAll((Collection)this.openContents.keySet())) {
            Logger.getInstance(JSLanguageServiceUpdateContext.class).error((Throwable)new IllegalArgumentException("Timestamps contains not all files: unsavedContents=" + this.unsavedContents.keySet() + ", openContents=" + this.openContents.keySet() + ", timestamps=" + this.timestamps.keySet()));
        }
    }

    @NotNull
    public final Map<VirtualFile, Document> getUnsavedContents() {
        return this.unsavedContents;
    }

    @NotNull
    public final Map<VirtualFile, Document> getOpenContents() {
        return this.openContents;
    }

    @NotNull
    public final Map<VirtualFile, Long> getTimestamps() {
        return this.timestamps;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSLanguageServiceUpdateContext)) {
            return false;
        }
        return Intrinsics.areEqual(this.unsavedContents, ((JSLanguageServiceUpdateContext)other).unsavedContents) && Intrinsics.areEqual(this.openContents, ((JSLanguageServiceUpdateContext)other).openContents) && Intrinsics.areEqual(this.timestamps, ((JSLanguageServiceUpdateContext)other).timestamps);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.unsavedContents, this.openContents, this.timestamps};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "JSLanguageServiceUpdateContext{myUnsavedContents=" + this.unsavedContents + ", myOpenContents=" + this.openContents + ", myTimestamps=" + this.timestamps + "}";
    }
}

