/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingPass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\fH$J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\fH\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/codeHighlighting/DirtyScopeTrackingHighlightingPassFactory;", "highlightingPassRegistrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "<init>", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "passId", "", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPassId", "getService", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "file", "isAcceptablePsiFile", "", "serviceName", "", "getServiceName", "()Ljava/lang/String;", "dispose", "", "intellij.javascript.impl"})
public abstract class JSLanguageServiceHighlightingPassFactory
implements Disposable,
DirtyScopeTrackingHighlightingPassFactory {
    private final int passId;

    protected JSLanguageServiceHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)highlightingPassRegistrar, (String)"highlightingPassRegistrar");
        if (Registry.Companion.is("typescript.service.geterr.enabled")) {
            nArray = null;
        } else {
            int[] nArray2 = new int[]{4};
            nArray = nArray2;
        }
        int[] runAfterCompletionOf = nArray;
        this.passId = highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, runAfterCompletionOf, null, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!this.isAcceptablePsiFile(psiFile)) {
            return null;
        }
        JSLanguageService service = this.getService(psiFile);
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (TextEditorHighlightingPass)new JSLanguageServiceHighlightingPass(project, service, psiFile, editor, this.getServiceName());
    }

    public int getPassId() {
        return this.passId;
    }

    @Nullable
    protected abstract JSLanguageService getService(@NotNull PsiFile var1);

    protected final boolean isAcceptablePsiFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof JSFile || file instanceof XmlFile;
    }

    @NotNull
    protected abstract String getServiceName();

    public void dispose() {
    }
}

