/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSParameterIntentionAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myReferencedName;
    private final boolean myHasUsages;

    public CreateJSParameterIntentionAction(JSReferenceExpression referenceExpression, String referencedName) {
        super((PsiElement)referenceExpression);
        this.myReferencedName = referencedName;
        this.myHasUsages = CreateJSParameterIntentionAction.hasUsages(CreateJSParameterIntentionAction.getJSFunction(this.myStartElement.getElement()));
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("javascript.fix.create.parameter", this.myReferencedName);
        if (string == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.create.variable.intention.family", new Object[0]);
        if (string == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSReferenceExpression node;
        JSFunction function;
        if (project == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            CreateJSParameterIntentionAction.$$$reportNull$$$0(5);
        }
        if ((function = CreateJSParameterIntentionAction.getJSFunction((PsiElement)(node = (JSReferenceExpression)startElement))) == null) {
            return;
        }
        JSParameterInserter parameterInserter = JSParameterInserter.build(function);
        if (parameterInserter == null) {
            return;
        }
        String type = null;
        boolean isActionScript = DialectDetector.isActionScript((PsiElement)node);
        if (isActionScript) {
            type = BaseCreateFix.guessTypeForExpression(node, (PsiElement)file, false);
        }
        if (this.myHasUsages && !IntentionPreviewUtils.isPreviewElement((PsiElement)function) && editor != null) {
            TextRange textRange = node.getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            final String finalType = type;
            new JSIntroduceParameterHandler(){

                @Override
                protected JSIntroduceParameterSettings getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope2) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        return new JSIntroduceParameterSettings.Base(expressionDescriptor){

                            @Override
                            public boolean addOptionalParameter() {
                                return parameterInserter.mustBeOptional();
                            }

                            @Override
                            public String getInitialValue() {
                                return JSTypeUtils.defaultValueOfType(finalType);
                            }

                            @Override
                            public boolean isReplaceAllOccurrences() {
                                return true;
                            }

                            @Override
                            public String getVariableName() {
                                return node.getReferencedName();
                            }

                            @Override
                            public String getVariableType() {
                                return finalType;
                            }
                        };
                    }
                    return (JSIntroduceParameterSettings)super.getSettings(project, editor, expressionDescriptor, occurrences, scope2);
                }
            }.invoke(project, editor, file, DataManager.getInstance().getDataContext());
            return;
        }
        Object typeDecoration = "";
        if (isActionScript && type != null) {
            typeDecoration = (String)typeDecoration + ":" + type;
        }
        boolean mustBeOptional = parameterInserter.mustBeOptional();
        String introduced = node.getReferencedName() + (String)typeDecoration;
        if (mustBeOptional) {
            introduced = introduced + "=" + JSTypeUtils.defaultValueOfType(type);
        }
        String finalIntroduced = introduced;
        JSParameter parameter = parameterInserter.doInsert(finalIntroduced, mustBeOptional, "");
        CodeStyleManager.getInstance((Project)project).reformat(parameter.getParent());
    }

    @Nullable
    private static JSFunction getJSFunction(PsiElement element) {
        return (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class});
    }

    private static boolean hasUsages(@Nullable JSFunction function) {
        if (function == null) {
            return false;
        }
        boolean noRefsFound = ReferencesSearch.search((PsiElement)function).forEach(psiReference -> JSResolveUtil.isSelfReference(psiReference.getElement()));
        return !noRefsFound;
    }

    public boolean startInWriteAction() {
        return !this.myHasUsages;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSParameterIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

