/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImplNoSubstitute;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptObjectJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTemplateLiteralJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImplNoSubstitute;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumNumberLiteralType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumStringLiteralType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.service.DocumentOffsetsManager;
import com.intellij.lang.typescript.tsc.ComputeInCoroutineKt;
import com.intellij.lang.typescript.tsc.TypeScriptCompilerTypeConverter$getTypeFromGenericParameter$;
import com.intellij.lang.typescript.tsc.TypeScriptServiceEvaluationSupportBase;
import com.intellij.lang.typescript.tsc.gen.ConditionalType;
import com.intellij.lang.typescript.tsc.gen.Declaration;
import com.intellij.lang.typescript.tsc.gen.FreshableIntrinsicType;
import com.intellij.lang.typescript.tsc.gen.ImplementationKt;
import com.intellij.lang.typescript.tsc.gen.IndexType;
import com.intellij.lang.typescript.tsc.gen.IndexedAccessType;
import com.intellij.lang.typescript.tsc.gen.IntersectionType;
import com.intellij.lang.typescript.tsc.gen.IntrinsicType;
import com.intellij.lang.typescript.tsc.gen.LiteralType;
import com.intellij.lang.typescript.tsc.gen.Node;
import com.intellij.lang.typescript.tsc.gen.NumberLiteralType;
import com.intellij.lang.typescript.tsc.gen.ObjectType;
import com.intellij.lang.typescript.tsc.gen.PseudoBigInt;
import com.intellij.lang.typescript.tsc.gen.Signature;
import com.intellij.lang.typescript.tsc.gen.SourceFile;
import com.intellij.lang.typescript.tsc.gen.StringLiteralType;
import com.intellij.lang.typescript.tsc.gen.SubstitutionType;
import com.intellij.lang.typescript.tsc.gen.Symbol;
import com.intellij.lang.typescript.tsc.gen.TemplateLiteralType;
import com.intellij.lang.typescript.tsc.gen.TscElementFactoriesKt;
import com.intellij.lang.typescript.tsc.gen.Type;
import com.intellij.lang.typescript.tsc.gen.TypeBase;
import com.intellij.lang.typescript.tsc.gen.TypeFlagsValues;
import com.intellij.lang.typescript.tsc.gen.TypeObjectKt;
import com.intellij.lang.typescript.tsc.gen.TypeObjectProperty;
import com.intellij.lang.typescript.tsc.gen.TypeParameter;
import com.intellij.lang.typescript.tsc.gen.TypeScriptServerTypeCheckerContextKt;
import com.intellij.lang.typescript.tsc.gen.UnionType;
import com.intellij.lang.typescript.tsc.types.JSGenericTypeImplNoSubstitute;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerConditionalTypeImpl;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerIntersectionType;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerObjectTypeImpl;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerSymbolType;
import com.intellij.lang.typescript.tsc.types.TypeScriptCompilerUnionType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u0015H\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tJ\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/intellij/lang/typescript/tsc/TypeScriptCompilerTypeConverter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "buildJSTypeSource", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "tscType", "Lcom/intellij/lang/typescript/tsc/gen/Type;", "toJSType", "Lcom/intellij/lang/javascript/psi/JSType;", "getTypeFromGenericParameter", "Lcom/intellij/lang/javascript/psi/types/typescript/TypeScriptGenericParameterImpl;", "declaration", "Lcom/intellij/psi/PsiElement;", "constraintType", "getEnumAndFieldNames", "Lkotlin/Pair;", "", "findPsiElement", "Lcom/intellij/lang/typescript/tsc/gen/Declaration;", "documentOffsetsManager", "Lcom/intellij/lang/javascript/service/DocumentOffsetsManager;", "getDocumentOffsetsManager", "()Lcom/intellij/lang/javascript/service/DocumentOffsetsManager;", "signature", "Lcom/intellij/lang/typescript/tsc/gen/Signature;", "loadTypeProperties", "", "type", "convertTypeArguments", "", "typeArguments", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerTypeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerTypeConverter.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerTypeConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,350:1\n1#2:351\n1#2:369\n1#2:391\n1557#3:352\n1628#3,3:353\n1734#3,3:356\n1611#3,9:359\n1863#3:368\n1864#3:370\n1620#3:371\n1557#3:377\n1628#3,3:378\n1611#3,9:381\n1863#3:390\n1864#3:392\n1620#3:393\n1557#3:394\n1628#3,3:395\n14#4:372\n24#4:398\n477#5:373\n183#5,2:374\n19#6:376\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerTypeConverter.kt\ncom/intellij/lang/typescript/tsc/TypeScriptCompilerTypeConverter\n*L\n174#1:369\n314#1:391\n113#1:352\n113#1:353,3\n114#1:356,3\n174#1:359,9\n174#1:368\n174#1:370\n174#1:371\n294#1:377\n294#1:378,3\n314#1:381,9\n314#1:390\n314#1:392\n314#1:393\n346#1:394\n346#1:395,3\n181#1:372\n215#1:398\n190#1:373\n220#1:374,2\n293#1:376\n*E\n"})
public final class TypeScriptCompilerTypeConverter {
    @NotNull
    private final Project project;

    public TypeScriptCompilerTypeConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final JSTypeSource buildJSTypeSource(Type tscType) {
        PsiElement psiElement;
        Declaration declaration;
        Object object = tscType.getSymbol();
        Declaration declaration2 = object != null && (object = object.getDeclarations()) != null ? (Declaration)CollectionsKt.getOrNull((List)object, (int)0) : (declaration = null);
        if (declaration != null && (psiElement = this.findPsiElement(declaration)) != null) {
            JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(psiElement, true);
            Intrinsics.checkNotNullExpressionValue((Object)jSTypeSource, (String)"createTypeSource(...)");
            return jSTypeSource;
        }
        JSTypeSource jSTypeSource = JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeSource, (String)"EMPTY_TS_EXPLICITLY_DECLARED");
        return jSTypeSource;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JSType toJSType(@NotNull Type tscType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)tscType, (String)"tscType");
        boolean isFreshLiteralType = ImplementationKt.intersects(tscType.getFlags(), TypeFlagsValues.INSTANCE.getLiteral()) && Intrinsics.areEqual((Object)((LiteralType)tscType).getFreshType(), (Object)tscType);
        int n = tscType.getFlags();
        if (n == TypeFlagsValues.INSTANCE.getAny()) {
            object = JSAnyType.get(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getUnknown()) {
            object = JSUnknownType.TS_INSTANCE;
        } else if (n == TypeFlagsValues.INSTANCE.getString()) {
            object = JSNamedTypeFactory.createStringPrimitiveType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getNumber()) {
            object = JSNamedTypeFactory.createNumberPrimitiveType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getBoolean() || n == (TypeFlagsValues.INSTANCE.getBoolean() | TypeFlagsValues.INSTANCE.getUnion())) {
            object = JSNamedTypeFactory.createBooleanPrimitiveType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getEnum()) {
            PsiElement sourceElement = this.buildJSTypeSource(tscType).getSourceElement();
            object = sourceElement instanceof TypeScriptEnumField ? (TypeScriptEnumField)sourceElement : null;
            if (object == null || (object = object.getConstantValue()) == null || (object = object.getExpandedJSType(null)) == null) {
                JSNamespace jSNamespace;
                TypeScriptEnum typeScriptEnum = sourceElement instanceof TypeScriptEnum ? (TypeScriptEnum)sourceElement : null;
                if (typeScriptEnum != null) {
                    TypeScriptEnum it = typeScriptEnum;
                    boolean bl2 = false;
                    jSNamespace = JSNamedTypeFactory.buildProvidedNamespace(it, true);
                } else {
                    jSNamespace = null;
                }
                object = jSNamespace;
            }
        } else if (n == TypeFlagsValues.INSTANCE.getBigInt()) {
            object = JSNamedTypeFactory.createBigIntPrimitiveType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getStringLiteral()) {
            object = new JSStringLiteralTypeImpl(((StringLiteralType)tscType).getValue(), isFreshLiteralType, this.buildJSTypeSource(tscType));
        } else if (n == (TypeFlagsValues.INSTANCE.getStringLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            Pair<String, String> pair = this.getEnumAndFieldNames(tscType);
            if (pair == null) {
                return null;
            }
            Pair<String, String> sourceElement = pair;
            String enumName = (String)sourceElement.component1();
            String fieldName = (String)sourceElement.component2();
            object = new TypeScriptEnumStringLiteralType(((StringLiteralType)tscType).getValue(), enumName, fieldName, this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getNumberLiteral() || n == (TypeFlagsValues.INSTANCE.getNumberLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl;
            String valueAsString;
            double d;
            Number value = ((NumberLiteralType)tscType).getValue();
            if (value instanceof Integer) {
                d = value.intValue();
            } else {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Double");
                d = (Double)value;
            }
            double doubleValue = d;
            String string = valueAsString = value instanceof Integer ? String.valueOf(value.intValue()) : null;
            if (tscType.getFlags() == (TypeFlagsValues.INSTANCE.getNumberLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
                Pair<String, String> pair = this.getEnumAndFieldNames(tscType);
                if (pair == null) {
                    return null;
                }
                Pair<String, String> pair2 = pair;
                String enumName = (String)pair2.component1();
                String fieldName = (String)pair2.component2();
                jSNumberLiteralTypeImpl = new TypeScriptEnumNumberLiteralType(doubleValue, enumName, fieldName, this.buildJSTypeSource(tscType), valueAsString);
            } else {
                jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(doubleValue, isFreshLiteralType, this.buildJSTypeSource(tscType), valueAsString);
            }
            object = jSNumberLiteralTypeImpl;
        } else if (n == TypeFlagsValues.INSTANCE.getBooleanLiteral() || n == (TypeFlagsValues.INSTANCE.getBooleanLiteral() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            FreshableIntrinsicType freshableIntrinsicType = TypeObjectKt.asFreshableIntrinsicType(tscType);
            object = new JSBooleanLiteralTypeImpl(Boolean.parseBoolean(freshableIntrinsicType.getIntrinsicName()), isFreshLiteralType, this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getBigIntLiteral()) {
            Object object2 = ((LiteralType)tscType).getValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.PseudoBigInt");
            BigInteger positiveValue = new BigInteger(((PseudoBigInt)object2).getBase10Value());
            Object object3 = ((LiteralType)tscType).getValue();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.PseudoBigInt");
            BigInteger value = ((PseudoBigInt)object3).getNegative() ? positiveValue.negate() : positiveValue;
            object = new JSBigIntLiteralTypeImpl(value, isFreshLiteralType, this.buildJSTypeSource(tscType), value.toString(10));
        } else if (n == TypeFlagsValues.INSTANCE.getESSymbol()) {
            object = JSNamedTypeFactory.createSymbolPrimitiveType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getVoid()) {
            object = JSNamedTypeFactory.createVoidType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getUndefined()) {
            object = JSNamedTypeFactory.createUndefinedType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getNull()) {
            object = JSNamedTypeFactory.createNullType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getNever()) {
            object = JSNamedTypeFactory.createNeverType(this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getUniqueESSymbol()) {
            object = new JSUniqueSymbolTypeImpl(this.buildJSTypeSource(tscType), JSTypeContext.INSTANCE, false);
        } else if (n == TypeFlagsValues.INSTANCE.getTypeParameter()) {
            JSTypeBaseImpl jSTypeBaseImpl;
            JSType jSType;
            Type it;
            Type type = ((TypeParameter)tscType).getConstraint();
            if (type != null) {
                it = type;
                boolean bl = false;
                jSType = this.toJSType(it);
            } else {
                jSType = null;
            }
            JSType constraintType = jSType;
            JSTypeSource typeSource = this.buildJSTypeSource(tscType);
            if (Intrinsics.areEqual((Object)((TypeParameter)tscType).isThisType(), (Object)true)) {
                JSGenericTypeImpl genericTypeWithThis = null;
                if (constraintType instanceof TypeScriptCompilerObjectTypeImpl) {
                    List typeArguments;
                    boolean bl;
                    List $this$map$iv;
                    Symbol symbol;
                    block85: {
                        void $this$mapTo$iv$iv;
                        it = TypeScriptCompilerObjectTypeImpl.getSymbolAndTypeArguments$default((TypeScriptCompilerObjectTypeImpl)constraintType, false, 1, null);
                        symbol = (Symbol)it.component1();
                        List tscTypeArguments = (List)it.component2();
                        Iterable bl2 = tscTypeArguments;
                        boolean $i$f$map = false;
                        void var13_51 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            Type type2 = (Type)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add(this.toJSType((Type)it2));
                        }
                        List it3 = $this$map$iv = (List)destination$iv$iv;
                        boolean bl4 = false;
                        Iterable $this$all$iv = it3;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                JSType jsType = (JSType)element$iv;
                                boolean bl5 = false;
                                if (jsType != null) continue;
                                bl = false;
                                break block85;
                            }
                            bl = true;
                        }
                    }
                    List list = typeArguments = bl ? $this$map$iv : null;
                    if (symbol != null) {
                        JSType baseType;
                        List list2 = typeArguments;
                        boolean bl6 = list2 != null ? !((Collection)list2).isEmpty() : false;
                        if (bl6 && (baseType = ((TypeScriptCompilerObjectTypeImpl)constraintType).buildBaseType(symbol)) != null) {
                            genericTypeWithThis = new JSGenericTypeImplNoSubstitute(typeSource, new TypeScriptGenericThisTypeImpl(((TypeScriptCompilerObjectTypeImpl)constraintType).getSource(), baseType), typeArguments, this.project, tscType);
                        }
                    }
                }
                JSGenericTypeImpl jSGenericTypeImpl = genericTypeWithThis;
                jSTypeBaseImpl = jSGenericTypeImpl != null ? (JSTypeBaseImpl)jSGenericTypeImpl : (JSTypeBaseImpl)new TypeScriptGenericThisTypeImpl(typeSource, constraintType);
            } else {
                jSTypeBaseImpl = this.getTypeFromGenericParameter(typeSource.getSourceElement(), constraintType);
            }
            object = jSTypeBaseImpl;
        } else if (n == TypeFlagsValues.INSTANCE.getObject()) {
            object = new TypeScriptCompilerObjectTypeImpl((ObjectType)tscType, this.project);
        } else if (n == TypeFlagsValues.INSTANCE.getUnion() || n == (TypeFlagsValues.INSTANCE.getUnion() | TypeFlagsValues.INSTANCE.getEnumLiteral())) {
            object = new TypeScriptCompilerUnionType((UnionType)tscType, this.project, this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getIntersection()) {
            object = new TypeScriptCompilerIntersectionType((IntersectionType)tscType, this.project, this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getIndex()) {
            JSType referencedType = this.toJSType(((IndexType)tscType).getType());
            object = referencedType != null ? new TypeScriptTypeOperatorJSTypeImplNoSubstitute(referencedType, this.buildJSTypeSource(tscType)) : null;
        } else if (n == TypeFlagsValues.INSTANCE.getIndexedAccess()) {
            JSType jSType;
            JSType jSType2;
            Type type = ((IndexedAccessType)tscType).getObjectType();
            if (type != null) {
                Type it = type;
                boolean bl = false;
                jSType2 = this.toJSType(it);
            } else {
                jSType2 = null;
            }
            JSType objectType = jSType2;
            Type type3 = ((IndexedAccessType)tscType).getIndexType();
            if (type3 != null) {
                Type it = type3;
                boolean bl = false;
                jSType = this.toJSType(it);
            } else {
                jSType = null;
            }
            JSType indexType = jSType;
            object = objectType != null && indexType != null ? new TypeScriptIndexedAccessJSTypeImplNoSubstitute(objectType, indexType, this.buildJSTypeSource(tscType)) : null;
        } else if (n == TypeFlagsValues.INSTANCE.getConditional()) {
            object = new TypeScriptCompilerConditionalTypeImpl((ConditionalType)tscType, this.project, this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getSubstitution()) {
            PsiElement psiElement;
            Declaration baseTypeDeclaration;
            Object object4 = ((SubstitutionType)tscType).getBaseType().getSymbol();
            Declaration declaration = baseTypeDeclaration = object4 != null && (object4 = object4.getDeclarations()) != null ? (Declaration)CollectionsKt.firstOrNull((List)object4) : null;
            if (declaration != null) {
                Declaration it = declaration;
                boolean bl = false;
                psiElement = this.findPsiElement(it);
            } else {
                psiElement = null;
            }
            PsiElement baseTypePsi = psiElement;
            object = this.getTypeFromGenericParameter(baseTypePsi, null);
        } else if (n == TypeFlagsValues.INSTANCE.getNonPrimitive()) {
            object = Intrinsics.areEqual((Object)((IntrinsicType)tscType).getIntrinsicName(), (Object)"object") ? new TypeScriptObjectJSTypeImpl(this.buildJSTypeSource(tscType), JSTypeContext.INSTANCE) : null;
        } else if (n == TypeFlagsValues.INSTANCE.getTemplateLiteral()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable baseTypeDeclaration = ((TemplateLiteralType)tscType).getTypes();
            List<String> list = ((TemplateLiteralType)tscType).getTexts();
            boolean $i$f$mapNotNull = false;
            void genericTypeWithThis = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JSType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Type it = (Type)element$iv$iv;
                boolean bl7 = false;
                if (this.toJSType(it) == null) continue;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = TypeScriptTemplateLiteralJSTypeImpl.createType(list, (List)destination$iv$iv, false, this.buildJSTypeSource(tscType));
        } else if (n == TypeFlagsValues.INSTANCE.getStringMapping()) {
            object = null;
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TypeScriptCompilerTypeConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown TypeScript compiler type with flags " + tscType.getFlags());
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final TypeScriptGenericParameterImpl getTypeFromGenericParameter(PsiElement declaration, JSType constraintType) {
        void $this$filterIsInstance$iv;
        Sequence sequence = new PsiElement[2];
        sequence[0] = declaration;
        PsiElement psiElement = declaration;
        sequence[1] = psiElement != null ? psiElement.getParent() : null;
        sequence = SequencesKt.sequenceOf((Object[])sequence);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getTypeFromGenericParameter$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        TypeScriptGenericOrMappedTypeParameter typeScriptGenericOrMappedTypeParameter = (TypeScriptGenericOrMappedTypeParameter)SequencesKt.firstOrNull((Sequence)sequence2);
        if (typeScriptGenericOrMappedTypeParameter == null) {
            return null;
        }
        TypeScriptGenericOrMappedTypeParameter typeParameter = typeScriptGenericOrMappedTypeParameter;
        TypeScriptTypeParameter typeScriptTypeParameter = typeParameter instanceof TypeScriptTypeParameter ? (TypeScriptTypeParameter)typeParameter : null;
        return new TypeScriptGenericParameterImpl(typeParameter.getGenericId(), JSTypeSourceFactory.createTypeSource((PsiElement)typeParameter), constraintType, typeScriptTypeParameter != null ? typeScriptTypeParameter.isConst() : false);
    }

    private final Pair<String, String> getEnumAndFieldNames(Type tscType) {
        Intrinsics.checkNotNull((Object)tscType, (String)"null cannot be cast to non-null type com.intellij.lang.typescript.tsc.gen.TypeBase");
        Object object = ((TypeBase)tscType).getData().get(TypeObjectProperty.nameType);
        String enumQualifiedName = object instanceof String ? (String)object : null;
        Symbol symbol = ((TypeBase)tscType).getSymbol();
        String fieldName = symbol != null ? symbol.getEscapedName() : null;
        CharSequence charSequence = enumQualifiedName;
        return charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)fieldName) == null || charSequence.length() == 0 ? null : TuplesKt.to((Object)enumQualifiedName, (Object)fieldName);
    }

    /*
     * Unable to fully structure code
     */
    @RequiresReadLock
    @Nullable
    public final PsiElement findPsiElement(@NotNull Declaration declaration) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            var5_2 = SequencesKt.generateSequence((Object)declaration, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, findPsiElement$lambda$9(com.intellij.lang.typescript.tsc.gen.Node ), (Lcom/intellij/lang/typescript/tsc/gen/Node;)Lcom/intellij/lang/typescript/tsc/gen/Node;)());
            $i$f$firstOrNull = false;
            var7_4 = $this$firstOrNull$iv.iterator();
            while (var7_4.hasNext()) {
                element$iv = var7_4.next();
                it = (Node)element$iv;
                $i$a$-firstOrNull-TypeScriptCompilerTypeConverter$findPsiElement$sourceFile$2 = false;
                if (!TscElementFactoriesKt.isSourceFile(it)) continue;
                v0 = (TypeScriptServiceEvaluationSupportBase)element$iv;
                break block13;
            }
            v0 = null;
        }
        var4_10 = v0;
        v1 = var4_10 instanceof SourceFile != false ? (SourceFile)var4_10 : null;
        if (v1 == null) {
            return TypeScriptCompilerTypeConverter.findPsiElement$logErrorAndReturnNull(this, declaration, "Cannot find SourceFile.");
        }
        sourceFile = v1;
        $this$firstOrNull$iv = TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext(sourceFile).getService().getTypeEvaluationSupport();
        var4_10 = $this$firstOrNull$iv instanceof TypeScriptServiceEvaluationSupportBase != false ? (TypeScriptServiceEvaluationSupportBase)$this$firstOrNull$iv : null;
        virtualFile = (VirtualFile)ComputeInCoroutineKt.awaitFutureShort(var4_10 != null ? var4_10.findLocalFileByPath$intellij_javascript_impl(sourceFile.getFileName()) : null);
        if (virtualFile == null) {
            if (StringsKt.contains$default((CharSequence)sourceFile.getFileName(), (CharSequence)".zip/", (boolean)false, (int)2, null)) {
                return null;
            }
            return TypeScriptCompilerTypeConverter.findPsiElement$logErrorAndReturnNull(this, declaration, "Cannot locate VirtualFile.");
        }
        v2 = PsiManager.getInstance((Project)this.project).findFile(virtualFile);
        if (v2 == null) {
            return TypeScriptCompilerTypeConverter.findPsiElement$logErrorAndReturnNull(this, declaration, "Cannot find PsiFile.");
        }
        psiFile = v2;
        if (TscElementFactoriesKt.isSourceFile(declaration)) {
            return (PsiElement)psiFile;
        }
        v3 = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile);
        if (v3 == null) {
            return TypeScriptCompilerTypeConverter.findPsiElement$logErrorAndReturnNull(this, declaration, "Cannot load document.");
        }
        document = v3;
        convertedPos = this.getDocumentOffsetsManager().getConvertedOffset(document, declaration.getPos());
        convertedEnd = this.getDocumentOffsetsManager().getConvertedOffset(document, declaration.getEnd());
        injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.project);
        elementAtStartPos = new Ref.ObjectRef();
        elementAtEndPos = new Ref.ObjectRef();
        AstLoadingFilter.forceAllowTreeLoading((PsiFile)psiFile, (ThrowableRunnable)(ThrowableRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, findPsiElement$lambda$11(com.intellij.lang.injection.InjectedLanguageManager com.intellij.psi.PsiFile int int kotlin.jvm.internal.Ref$ObjectRef kotlin.jvm.internal.Ref$ObjectRef ), ()V)((InjectedLanguageManager)injectedLanguageManager, (PsiFile)psiFile, (int)convertedPos, (int)convertedEnd, (Ref.ObjectRef)elementAtStartPos, (Ref.ObjectRef)elementAtEndPos));
        var12_13 = (PsiElement)elementAtStartPos.element;
        if (var12_13 != null) {
            it = var12_13;
            $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$startEl$1 = false;
            v4 = it instanceof PsiWhiteSpace || it instanceof PsiComment ? PsiTreeUtil.nextCodeLeaf((PsiElement)it) : it;
        } else {
            v4 = null;
        }
        startEl = v4;
        var13_18 = (PsiElement)elementAtEndPos.element;
        if (var13_18 == null) ** GOTO lbl-1000
        it = var13_18;
        $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$endEl$1 = false;
        it = (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)JSTokenTypes.SEMICOLON) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)JSTokenTypes.COMMA)) && it.getPrevSibling() != null ? it.getPrevSibling() : it;
        if (it == null) ** GOTO lbl-1000
        it = it;
        $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$endEl$2 = false;
        var15_16 = it instanceof PsiWhiteSpace || it instanceof PsiComment ? PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)it) : it;
        if (var15_16 != null) {
            it = var15_16;
            $i$a$-let-TypeScriptCompilerTypeConverter$findPsiElement$endEl$3 = false;
            v5 = PsiTreeUtil.getDeepestLast((PsiElement)it);
        } else lbl-1000:
        // 3 sources

        {
            v5 = null;
        }
        endEl = v5;
        it = new PsiElement[]{startEl, endEl};
        commonParent = PsiTreeUtil.findCommonParent((PsiElement[])it);
        while (commonParent != null && Intrinsics.areEqual((Object)(commonParentParent = commonParent.getParent()).getTextRange(), (Object)commonParent.getTextRange()) && (commonParentParent instanceof JSReferenceExpression || commonParentParent instanceof JSProperty || commonParentParent instanceof JSFieldVariable)) {
            commonParent = commonParentParent;
        }
        v6 = commonParent;
        if (v6 == null) {
            v6 = TypeScriptCompilerTypeConverter.findPsiElement$logErrorAndReturnNull(this, declaration, "Cannot locate PsiElement.");
        }
        return v6;
    }

    private final DocumentOffsetsManager getDocumentOffsetsManager() {
        Object object = this.project.getService(DocumentOffsetsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (DocumentOffsetsManager)object;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final JSType toJSType(@NotNull Signature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        v0 = signature.getDeclaration();
        if (v0 == null) ** GOTO lbl-1000
        $this$asSafely$iv = v0;
        $i$f$asSafely = false;
        v1 = $this$asSafely$iv;
        if (!(v1 instanceof Declaration)) {
            v1 = null;
        }
        if ((v0 = (Declaration)v1) != null) {
            it = v0;
            $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$declaration$1 = false;
            v2 = this.findPsiElement((Declaration)it);
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        declaration = v2;
        $this$map$iv = signature.getParameters();
        $i$f$map = false;
        it = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_16 = (Symbol)item$iv$iv;
            var30_32 = destination$iv$iv;
            $i$a$-map-TypeScriptCompilerTypeConverter$toJSType$parameters$1 = false;
            declarations = it.getDeclarations();
            isOptional = false;
            isRest = false;
            if (declarations != null && declarations.size() == 1 && (psiElement = this.findPsiElement(declarations.get(0))) instanceof JSParameter) {
                isOptional = ((JSParameter)psiElement).isOptional();
                isRest = ((JSParameter)psiElement).isRest();
            }
            compilerType = new TypeScriptCompilerSymbolType((Symbol)it, this.project);
            $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$parameters$1$parameterType$1 = false;
            parameterType = isRest ? (JSTypeBaseImpl)new JSRestTypeImpl(compilerType, compilerType.getSource()) : (JSTypeBaseImpl)compilerType;
            var30_32.add(new JSParameterTypeDecoratorImpl(it.getEscapedName(), parameterType, isOptional, isRest, true));
        }
        parameters = (List)destination$iv$iv;
        v3 = signature.getTypeParameters();
        if (v3 != null) {
            $this$mapNotNull$iv = v3;
            $i$f$mapNotNull = false;
            var9_13 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var14_23 = $this$forEach$iv$iv$iv.iterator();
            while (var14_23.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var14_23.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                typeParam = (TypeParameter)element$iv$iv;
                $i$a$-mapNotNull-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1 = false;
                var20_35 = this.toJSType(typeParam);
                if ((var20_35 instanceof TypeScriptGenericParameterImpl != false ? (TypeScriptGenericParameterImpl)var20_35 : null) != null) {
                    it = it;
                    $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1$1 = false;
                    v4 = it.getGenericId();
                    if (it.getConstraintType() != null) {
                        var24_39 = v4;
                        $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1$1$1 = false;
                        v5 = NotNullLazyValue.createConstantValue((Object)type);
                        v4 = var24_39;
                    } else {
                        v5 = null;
                    }
                    if ((v6 = typeParam.getResolvedDefaultType()) == null) {
                        v6 = typeParam.getDefault();
                    }
                    if (v6 != null) {
                        type = v6;
                        var26_41 = v5;
                        var24_39 = v4;
                        $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$typeParameters$1$1$2 = false;
                        var27_42 = NotNullLazyValue.atomicLazy((Supplier<JSType>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toJSType$lambda$23$lambda$22$lambda$21$lambda$20(com.intellij.lang.typescript.tsc.TypeScriptCompilerTypeConverter com.intellij.lang.typescript.tsc.gen.Type com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl ), ()Lcom/intellij/lang/javascript/psi/JSType;)((TypeScriptCompilerTypeConverter)this, (Type)type, (TypeScriptGenericParameterImpl)it));
                        v4 = var24_39;
                        v5 = var26_41;
                        v7 = var27_42;
                    } else {
                        v7 = null;
                    }
                    var31_45 = it.isConst();
                    var32_46 = JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
                    var33_47 = v7;
                    var34_48 = v5;
                    var35_49 = v4;
                    v8 = new TypeScriptGenericDeclarationTypeImpl(var35_49, (NotNullLazyValue<? extends JSType>)var34_48, (NotNullLazyValue<? extends JSType>)var33_47, var32_46, var31_45);
                } else {
                    v8 = null;
                }
                if (v8 == null) continue;
                it$iv$iv = v8;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v9 = (List)destination$iv$iv;
        } else {
            v9 = CollectionsKt.emptyList();
        }
        typeParameters = v9;
        source = declaration != null ? JSTypeSourceFactory.createTypeSource(declaration, true) : JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
        v10 = signature.getResolvedReturnType();
        if (v10 != null) {
            it = v10;
            $i$a$-let-TypeScriptCompilerTypeConverter$toJSType$returnType$1 = false;
            v11 = this.toJSType(it);
        } else {
            v11 = returnType = null;
        }
        if (((Collection)typeParameters).isEmpty() == false) {
            return new TypeScriptJSFunctionTypeImpl(source, typeParameters, parameters, null, returnType);
        }
        return new JSFunctionTypeImpl(source, parameters, returnType);
    }

    public final void loadTypeProperties(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext(type).getService().getTypeEvaluationSupport().loadTypeProperties(type);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JSType> convertTypeArguments(@NotNull List<? extends Type> typeArguments) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        Iterable $this$map$iv = typeArguments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JSType jSType = this.toJSType((Type)it);
            if (jSType == null) {
                return CollectionsKt.emptyList();
            }
            collection.add(jSType);
        }
        return (List)destination$iv$iv;
    }

    private static final PsiElement findPsiElement$logErrorAndReturnNull(TypeScriptCompilerTypeConverter this$0, Declaration $declaration, String cause) {
        TypeScriptCompilerTypeConverter $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TypeScriptCompilerTypeConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Failed to find PsiElement for declaration:\n" + $declaration + "\n" + cause);
        return null;
    }

    private static final Node findPsiElement$lambda$9(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final void findPsiElement$lambda$11(InjectedLanguageManager $injectedLanguageManager, PsiFile $psiFile, int $convertedPos, int $convertedEnd, Ref.ObjectRef $elementAtStartPos, Ref.ObjectRef $elementAtEndPos) {
        PsiElement injectedAtStartPos = $injectedLanguageManager.findInjectedElementAt($psiFile, $convertedPos);
        PsiElement injectedAtEndPos = $injectedLanguageManager.findInjectedElementAt($psiFile, $convertedEnd);
        if (injectedAtStartPos != null && injectedAtEndPos != null && Intrinsics.areEqual((Object)injectedAtStartPos.getContainingFile(), (Object)injectedAtEndPos.getContainingFile())) {
            $elementAtStartPos.element = injectedAtStartPos;
            $elementAtEndPos.element = injectedAtEndPos;
        } else {
            $elementAtStartPos.element = $psiFile.findElementAt($convertedPos);
            $elementAtEndPos.element = $psiFile.findElementAt($convertedEnd - 1);
        }
    }

    private static final JSType toJSType$lambda$23$lambda$22$lambda$21$lambda$20(TypeScriptCompilerTypeConverter this$0, Type $type, TypeScriptGenericParameterImpl $it) {
        JSType jSType = this$0.toJSType($type);
        if (jSType == null) {
            JSAnyType jSAnyType = JSAnyType.get($it.getSource());
            Intrinsics.checkNotNullExpressionValue((Object)jSAnyType, (String)"get(...)");
            jSType = jSAnyType;
        }
        return jSType;
    }
}

