/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc.gen;

import com.intellij.lang.typescript.tsc.gen.AbstractCompactValueMap;
import com.intellij.lang.typescript.tsc.gen.DoubleEntryCompactMap;
import com.intellij.lang.typescript.tsc.gen.EmptyCompactMap;
import com.intellij.lang.typescript.tsc.gen.SingleEntryCompactMap;
import com.intellij.lang.typescript.tsc.gen.SmallCompactEnumMap;
import com.intellij.lang.typescript.tsc.gen.TscDataMapKt;
import com.intellij.lang.typescript.tsc.gen.TscDataMapModifier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\u0012\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u001d\u0010\u0013\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0004\u0012\u00020\u00110\u0014\u00a2\u0006\u0002\b\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bH\u0007J\b\u0010 \u001a\u00020\u001eH\u0007R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/lang/typescript/tsc/gen/TscDataMap;", "P", "", "Lcom/intellij/lang/typescript/tsc/gen/TscObjectProperty;", "", "<init>", "()V", "map", "", "getMap$annotations", "enumClass", "Ljava/lang/Class;", "getEnumClass", "()Ljava/lang/Class;", "enumSize", "", "update", "", "maxNewEntries", "updater", "Lkotlin/Function1;", "Lcom/intellij/lang/typescript/tsc/gen/TscDataMapModifier;", "Lkotlin/ExtensionFunctionType;", "containsKey", "", "key", "(Ljava/lang/Enum;)Z", "get", "(Ljava/lang/Enum;)Ljava/lang/Object;", "toString", "", "copyAsMap", "getInternalMapKind", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTscDataMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TscDataMap.kt\ncom/intellij/lang/typescript/tsc/gen/TscDataMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n1863#2,2:367\n*S KotlinDebug\n*F\n+ 1 TscDataMap.kt\ncom/intellij/lang/typescript/tsc/gen/TscDataMap\n*L\n60#1:367,2\n*E\n"})
public abstract class TscDataMap<P extends Enum<P>> {
    @NotNull
    private volatile Map<P, ? extends Object> map;
    private final int enumSize;

    public TscDataMap() {
        EmptyCompactMap emptyCompactMap = EmptyCompactMap.INSTANCE;
        Intrinsics.checkNotNull((Object)emptyCompactMap, (String)"null cannot be cast to non-null type kotlin.collections.Map<P of com.intellij.lang.typescript.tsc.gen.TscDataMap, kotlin.Any?>");
        this.map = emptyCompactMap;
        this.enumSize = this.getEnumClass().getEnumConstants().length;
    }

    private static /* synthetic */ void getMap$annotations() {
    }

    @NotNull
    public abstract Class<P> getEnumClass();

    public final void update(int maxNewEntries, @NotNull Function1<? super TscDataMapModifier<P>, Unit> updater) {
        Map newMap;
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        if (maxNewEntries < 0) {
            throw new IllegalArgumentException("maxNewEntries must not be negative, encountered: " + maxNewEntries);
        }
        Map<P, Object> oldMap = this.map;
        int newSize = oldMap.size() + maxNewEntries;
        if (newSize == 0) {
            EmptyCompactMap emptyCompactMap = EmptyCompactMap.INSTANCE;
            Intrinsics.checkNotNull((Object)emptyCompactMap, (String)"null cannot be cast to non-null type kotlin.collections.Map<P of com.intellij.lang.typescript.tsc.gen.TscDataMap, kotlin.Any?>");
            v1 = emptyCompactMap;
        } else {
            v1 = newSize == 1 ? (Map)new SingleEntryCompactMap() : (newSize == 2 ? (Map)new DoubleEntryCompactMap() : (newSize <= 4 ? (Map)new SmallCompactEnumMap(newSize) : (newMap = 100 * newSize / this.enumSize > 20 ? (Map)new EnumMap(this.getEnumClass()) : (Map)new HashMap())));
        }
        if (oldMap instanceof AbstractCompactValueMap) {
            ((AbstractCompactValueMap)oldMap).copyTo(newMap);
        } else {
            Iterable $this$forEach$iv = oldMap.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                TscDataMapKt.access$putToMap(newMap, it.getKey(), it.getValue());
            }
        }
        updater.invoke((Object)new TscDataMapModifier<P>(newMap){
            final /* synthetic */ Map<P, Object> $newMap;
            {
                this.$newMap = $newMap;
            }

            public void set(P key, Object value) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                TscDataMapKt.access$putToMap(this.$newMap, key, value);
            }

            public Set<Map.Entry<P, Object>> getEntries() {
                Set<Map.Entry<Object, Object>> set;
                if (this.$newMap instanceof AbstractCompactValueMap) {
                    set = ((AbstractCompactValueMap)this.$newMap).getWritableEntries();
                } else {
                    Map<P, Object> map2 = this.$newMap;
                    Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<P of com.intellij.lang.typescript.tsc.gen.TscDataMap, kotlin.Any?>");
                    set = TypeIntrinsics.asMutableMap(map2).entrySet();
                }
                return set;
            }
        });
        this.map = newMap;
    }

    public final boolean containsKey(@NotNull P key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.map.containsKey(key);
    }

    @Nullable
    public final Object get(@NotNull P key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.map.get(key);
    }

    @NotNull
    public String toString() {
        return this.map.toString();
    }

    @TestOnly
    @NotNull
    public final Map<P, Object> copyAsMap() {
        return new HashMap<P, Object>(this.map);
    }

    @TestOnly
    @NotNull
    public final String getInternalMapKind() {
        String string;
        if (this.map == EmptyCompactMap.INSTANCE) {
            string = "empty";
        } else if (this.map instanceof SingleEntryCompactMap) {
            string = "single";
        } else if (this.map instanceof DoubleEntryCompactMap) {
            string = "double";
        } else if (this.map instanceof SmallCompactEnumMap) {
            string = "small";
        } else if (this.map instanceof EnumMap) {
            string = "enum";
        } else if (this.map instanceof HashMap) {
            string = "hash";
        } else {
            throw new IllegalStateException(this.map.toString());
        }
        return string;
    }
}

