/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions;

import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParametersSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServers;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterServersKt;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.connections.settings.ManagedServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpecBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0006\u0010\b\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"getMostSuitableKernelSpec", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "module", "Lcom/intellij/openapi/module/Module;", "getKernelSpecForPythonSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getPython2KernelSpec", "getPython3KernelSpec", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterKernelSpecGuesser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterKernelSpecGuesser.kt\ncom/intellij/jupyter/py/actions/JupyterKernelSpecGuesserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class JupyterKernelSpecGuesserKt {
    @Nullable
    public static final JupyterKernelSpec getMostSuitableKernelSpec(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Module it = module;
        boolean bl = false;
        Sdk sdk = PythonSdkUtil.findPythonSdk((Module)it);
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        String string = sdk2.getHomePath();
        if (string == null) {
            return null;
        }
        String sdkHomePath = string;
        if (PythonSdkUtil.isRemote((Sdk)sdk2)) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterModuleConnectionSettings connectionSettings = JupyterConnectionParametersSettings.Companion.getInstance(project).getConnectionParametersForModule(module);
        if (connectionSettings instanceof ManagedServerJupyterModuleConnectionSettings) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        JupyterConnectionParameters jupyterConnectionParameters = connectionSettings.getConnectionParameters(module);
        if (jupyterConnectionParameters == null) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        JupyterConnectionParameters connectionParameters = jupyterConnectionParameters;
        if (!JupyterConnectionSettingsUtilKt.isLocal((JupyterConnectionParameters)connectionParameters)) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        JupyterServer server = JupyterServers.Companion.getInstance().getServer(connectionParameters);
        JupyterKernelSpec jupyterKernelSpec = (JupyterKernelSpec)CollectionsKt.firstOrNull((List)JupyterServersKt.getProjectInterpreterKernelSpecs((JupyterServer)server, (String)sdkHomePath));
        if (jupyterKernelSpec == null) {
            jupyterKernelSpec = JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        return jupyterKernelSpec;
    }

    private static final JupyterKernelSpec getKernelSpecForPythonSdk(Sdk sdk) {
        PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor((Sdk)sdk);
        if (pythonSdkFlavor == null || (pythonSdkFlavor = pythonSdkFlavor.getLanguageLevel(sdk)) == null) {
            return null;
        }
        PythonSdkFlavor languageLevel = pythonSdkFlavor;
        return languageLevel.isPython2() ? JupyterKernelSpecGuesserKt.getPython2KernelSpec() : JupyterKernelSpecGuesserKt.getPython3KernelSpec();
    }

    private static final JupyterKernelSpec getPython2KernelSpec() {
        return (JupyterKernelSpec)new JupyterKernelSpecBase("Python 2", "python", "python2", null, null, 24, null);
    }

    @NotNull
    public static final JupyterKernelSpec getPython3KernelSpec() {
        return (JupyterKernelSpec)new JupyterKernelSpecBase("Python 3", "python", "python3", null, null, 24, null);
    }
}

