/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.debugger.CellSourcePosition;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"isPythonNotebook", "", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getCellPositionForJupyterCell", "Lcom/intellij/jupyter/py/debugger/CellSourcePosition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "intellij.jupyter.py"})
public final class JupyterFileUtilKt {
    public static final boolean isPythonNotebook(@Nullable BackedNotebookVirtualFile virtualFile) {
        BackedNotebookVirtualFile backedNotebookVirtualFile = virtualFile;
        return backedNotebookVirtualFile != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getNotebookOrNull()) != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getLanguage()) != null ? backedNotebookVirtualFile.isKindOf((Language)PythonLanguage.INSTANCE) : false;
    }

    @Nullable
    public static final CellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file, @NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPosition(file, cell.getLines().getFirst());
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition startSourcePosition = xSourcePosition;
        return new CellSourcePosition(startSourcePosition);
    }

    @Nullable
    public static final CellSourcePosition getCellPositionForJupyterCell(@NotNull VirtualFile file, @NotNull JupyterPsiCell cell) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Editor editor = JupyterHelper.INSTANCE.getJupyterEditorByOriginalVirtualFile(file);
        Editor editor2 = editor;
        if (editor2 == null || (editor2 = editor2.offsetToLogicalPosition(cell.getTextRange().getStartOffset())) == null) {
            return null;
        }
        int line = editor2.line;
        XSourcePosition startSourcePosition = XDebuggerUtil.getInstance().createPosition(file, line);
        return startSourcePosition != null ? new CellSourcePosition(startSourcePosition) : null;
    }
}

