/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.psi;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFileSystem;
import com.intellij.jupyter.core.jupyter.index.JupyterIndexRegistry;
import com.intellij.notebook.editor.BackFileViewProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/py/psi/JupyterBackFileViewProvider;", "Lcom/intellij/psi/SingleRootFileViewProvider;", "Lcom/intellij/notebook/editor/BackFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFrontVirtualFile", "getFrontPsiFile", "Lcom/intellij/psi/PsiFile;", "intellij.jupyter.py"})
public final class JupyterBackFileViewProvider
extends SingleRootFileViewProvider
implements BackFileViewProvider {
    public JupyterBackFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(manager, file);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        file.putCopyableUserData(BackFileViewProvider.FRONT_FILE_SIZE_RATIO_KEY, (Object)Float.valueOf(0.01f));
    }

    @Nullable
    public VirtualFile getFrontVirtualFile() {
        if (!JupyterIndexRegistry.INSTANCE.isEnabled()) {
            return null;
        }
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return this.getVirtualFile();
        }
        VirtualFile virtualFile = this.getVirtualFile();
        VirtualFileImpl virtualFileImpl = virtualFile instanceof VirtualFileImpl ? (VirtualFileImpl)virtualFile : null;
        if (virtualFileImpl == null) {
            return null;
        }
        VirtualFileImpl backFile = virtualFileImpl;
        BackedNotebookVirtualFile cached = NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem().getCached((VirtualFileWithId)backFile);
        if (cached != null) {
            return cached.getFile();
        }
        return NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem().getOrCreateIndexFile(backFile).getFile();
    }

    @Nullable
    public PsiFile getFrontPsiFile() {
        VirtualFile virtualFile = this.getFrontVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile frontFile = virtualFile;
        PsiFile psiFile2 = this.getManager().getFileManager().findFile(frontFile);
        return psiFile2;
    }
}

