/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.util.paths.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope
implements VcsDirtyScopeBuilder {
    private final Map<VirtualFile, Set<FilePath>> myDirtyFiles;
    private final Map<VirtualFile, RecursiveFilePathSet> myDirtyDirectoriesRecursively;
    private final Set<FilePath> myAllVcsRoots;
    private final Set<VirtualFile> myAffectedVcsRoots;
    @NotNull
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final AbstractVcs myVcs;
    private boolean myWasEverythingDirty;
    @Nullable
    private final HashingStrategy<FilePath> myHashingStrategy;
    private final boolean myCaseSensitive;

    public VcsDirtyScopeImpl(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(0);
        }
        this.myDirtyFiles = new HashMap<VirtualFile, Set<FilePath>>();
        this.myDirtyDirectoriesRecursively = new HashMap<VirtualFile, RecursiveFilePathSet>();
        this.myAllVcsRoots = new HashSet<FilePath>();
        this.myAffectedVcsRoots = new HashSet<VirtualFile>();
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myHashingStrategy = VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(this.myVcs);
        this.myCaseSensitive = this.myVcs.needsCaseSensitiveDirtyScope() || SystemInfo.isFileSystemCaseSensitive;
        this.myAllVcsRoots.addAll(ContainerUtil.map((Collection)this.myVcsManager.getRootsUnderVcsWithoutFiltering(this.myVcs), root -> VcsUtil.getFilePath((VirtualFile)root)));
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedVcsRoots;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(1);
        }
        return project;
    }

    @NotNull
    public AbstractVcs getVcs() {
        AbstractVcs abstractVcs = this.myVcs;
        if (abstractVcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(2);
        }
        return abstractVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        Set<FilePath> result2 = this.newFilePathsSet();
        for (Set<FilePath> paths : this.myDirtyFiles.values()) {
            result2.addAll(paths);
        }
        for (Set<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    result2.add(VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
        return result2;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        Set<FilePath> paths = this.newFilePathsSet();
        for (Set<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        Set<FilePath> result2 = this.newFilePathsSet();
        for (RecursiveFilePathSet dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result2.addAll(dirsByRoot.filePaths());
        }
        return result2;
    }

    public void addDirtyPathFast(@NotNull VirtualFile vcsRoot, @NotNull FilePath filePath, boolean recursively) {
        if (vcsRoot == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(4);
        }
        this.myAffectedVcsRoots.add(vcsRoot);
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && dirsByRoot.hasAncestor(filePath)) {
            return;
        }
        if (recursively) {
            if (dirsByRoot == null) {
                dirsByRoot = this.newRecursiveFilePathSet();
                this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
            }
            dirsByRoot.add(filePath);
        } else {
            Set<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
            if (dirtyFiles == null) {
                dirtyFiles = this.newFilePathsSet();
                this.myDirtyFiles.put(vcsRoot, dirtyFiles);
            }
            dirtyFiles.add(filePath);
        }
    }

    public void markEverythingDirty() {
        this.myWasEverythingDirty = true;
    }

    @NotNull
    public VcsDirtyScopeImpl pack() {
        VcsDirtyScopeImpl copy = new VcsDirtyScopeImpl(this.myVcs);
        copy.myWasEverythingDirty = this.myWasEverythingDirty;
        for (VirtualFile root : this.myAffectedVcsRoots) {
            RecursiveFilePathSet rootDirs = this.myDirtyDirectoriesRecursively.get(root);
            Set rootFiles = ContainerUtil.notNullize(this.myDirtyFiles.get(root));
            RecursiveFilePathSet filteredDirs = this.removeAncestorsRecursive(rootDirs);
            Set<FilePath> filteredFiles = this.removeAncestorsNonRecursive(filteredDirs, rootFiles);
            copy.myAffectedVcsRoots.add(root);
            copy.myDirtyDirectoriesRecursively.put(root, filteredDirs);
            copy.myDirtyFiles.put(root, filteredFiles);
        }
        VcsDirtyScopeImpl vcsDirtyScopeImpl = copy;
        if (vcsDirtyScopeImpl == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(5);
        }
        return vcsDirtyScopeImpl;
    }

    @NotNull
    private RecursiveFilePathSet removeAncestorsRecursive(@Nullable RecursiveFilePathSet dirs) {
        RecursiveFilePathSet result2 = this.newRecursiveFilePathSet();
        if (dirs == null) {
            RecursiveFilePathSet recursiveFilePathSet = result2;
            if (recursiveFilePathSet == null) {
                VcsDirtyScopeImpl.$$$reportNull$$$0(6);
            }
            return recursiveFilePathSet;
        }
        List paths = ContainerUtil.sorted(dirs.filePaths(), Comparator.comparingInt(it -> it.getPath().length()));
        for (FilePath path : paths) {
            if (result2.hasAncestor(path)) continue;
            result2.add(path);
        }
        RecursiveFilePathSet recursiveFilePathSet = result2;
        if (recursiveFilePathSet == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(7);
        }
        return recursiveFilePathSet;
    }

    @NotNull
    private Set<FilePath> removeAncestorsNonRecursive(@NotNull RecursiveFilePathSet dirs, @NotNull Set<? extends FilePath> files) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(8);
        }
        if (files == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(9);
        }
        Set<FilePath> result2 = this.newFilePathsSet();
        for (FilePath filePath : files) {
            if (dirs.hasAncestor(filePath) || !filePath.isDirectory() && files.contains(filePath.getParentPath())) continue;
            result2.add(filePath);
        }
        Set<FilePath> set = result2;
        if (set == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private Set<FilePath> newFilePathsSet() {
        Set set = this.myHashingStrategy == null ? new HashSet() : CollectionFactory.createCustomHashingStrategySet(this.myHashingStrategy);
        if (set == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    private RecursiveFilePathSet newRecursiveFilePathSet() {
        return new RecursiveFilePathSet(this.myCaseSensitive);
    }

    public void addDirtyDirRecursively(FilePath newcomer) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedVcsRoots.add(vcsRoot);
        for (Map.Entry<VirtualFile, Set<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            Set<FilePath> files;
            VirtualFile groupRoot = entry.getKey();
            if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files = entry.getValue()) == null) continue;
            Iterator<FilePath> it = files.iterator();
            while (it.hasNext()) {
                FilePath oldBoy2 = it.next();
                if (!VcsFileUtil.isAncestor(newcomer, oldBoy2, false)) continue;
                it.remove();
            }
        }
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot == null) {
            dirsByRoot = this.newRecursiveFilePathSet();
            this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
        } else {
            if (dirsByRoot.hasAncestor(newcomer)) {
                return;
            }
            List toRemove = ContainerUtil.filter(dirsByRoot.filePaths(), oldBoy -> VcsFileUtil.isAncestor(newcomer, oldBoy, false));
            for (FilePath path : toRemove) {
                dirsByRoot.remove(path);
            }
        }
        dirsByRoot.add(newcomer);
    }

    public void addDirtyFile(FilePath newcomer) {
        FilePath parent;
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedVcsRoots.add(vcsRoot);
        RecursiveFilePathSet dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && dirsByRoot.hasAncestor(newcomer)) {
            return;
        }
        Set<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
        if (dirtyFiles == null) {
            dirtyFiles = this.newFilePathsSet();
            this.myDirtyFiles.put(vcsRoot, dirtyFiles);
        } else if (newcomer.isDirectory()) {
            Iterator<FilePath> iterator = dirtyFiles.iterator();
            while (iterator.hasNext()) {
                FilePath oldBoy = iterator.next();
                if (oldBoy.isDirectory() || !(this.myHashingStrategy == null ? Objects.equals(oldBoy.getParentPath(), newcomer) : this.myHashingStrategy.equals((Object)oldBoy.getParentPath(), (Object)newcomer))) continue;
                iterator.remove();
            }
        } else if (!dirtyFiles.isEmpty() && (parent = newcomer.getParentPath()) != null && dirtyFiles.contains(parent)) {
            return;
        }
        dirtyFiles.add(newcomer);
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(FilePath path) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path);
        if (rootObject == null || rootObject.getVcs() != this.myVcs) {
            return false;
        }
        VirtualFile vcsRoot = rootObject.getPath();
        boolean pathIsRoot = this.myAllVcsRoots.contains(path);
        for (VirtualFile otherRoot : this.myDirtyDirectoriesRecursively.keySet()) {
            RecursiveFilePathSet dirsByRoot;
            boolean strict;
            if (!VfsUtilCore.isAncestor((VirtualFile)otherRoot, (VirtualFile)vcsRoot, (boolean)(strict = pathIsRoot && !this.myVcs.areDirectoriesVersionedItems())) || !(dirsByRoot = this.myDirtyDirectoriesRecursively.get(otherRoot)).hasAncestor(path)) continue;
            return true;
        }
        if (!this.myDirtyFiles.isEmpty()) {
            if (this.isInDirtyFiles(path, vcsRoot)) {
                return true;
            }
            FilePath parent = path.getParentPath();
            if (parent != null && (pathIsRoot ? this.isInDirtyFiles(parent) : this.isInDirtyFiles(parent, vcsRoot))) {
                return true;
            }
        }
        return false;
    }

    private boolean isInDirtyFiles(@NotNull FilePath path) {
        VcsRoot rootObject;
        if (path == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(12);
        }
        if ((rootObject = this.myVcsManager.getVcsRootObjectFor(path)) == null || !this.myVcs.equals((Object)rootObject.getVcs())) {
            return false;
        }
        return this.isInDirtyFiles(path, rootObject.getPath());
    }

    private boolean isInDirtyFiles(@NotNull FilePath path, @NotNull VirtualFile vcsRoot) {
        Set<FilePath> files;
        if (path == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(13);
        }
        if (vcsRoot == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(14);
        }
        return (files = this.myDirtyFiles.get(vcsRoot)) != null && files.contains(path);
    }

    @NonNls
    public String toString() {
        @NonNls StringBuilder result2 = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result2.append(" files: ");
            for (Set<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file : paths) {
                    result2.append(file).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result2.append("\ndirs: ");
            for (RecursiveFilePathSet dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file : dirsByRoot.filePaths()) {
                    result2.append(file).append(" ");
                }
            }
        }
        result2.append("\naffected roots: ");
        for (VirtualFile root : this.myAffectedVcsRoots) {
            result2.append(root.getPath()).append(" ");
        }
        result2.append("]");
        return result2.toString();
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "pack";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsRecursive";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsNonRecursive";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newFilePathsSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDirtyPathFast";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeAncestorsNonRecursive";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInDirtyFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 7, 10, 11 -> new IllegalStateException(string);
        };
    }
}

