/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CodeAnalysisBeforeCheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0016\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/checkin/CodeAnalysisCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "codeSmells", "", "Lcom/intellij/codeInsight/CodeSmellInfo;", "errors", "", "warnings", "<init>", "(Ljava/util/List;II)V", "text", "", "getText", "()Ljava/lang/String;", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "showDetailsAction", "getShowDetailsAction", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class CodeAnalysisCommitProblem
implements CommitProblemWithDetails {
    @NotNull
    private final List<CodeSmellInfo> codeSmells;
    private final int errors;
    private final int warnings;

    public CodeAnalysisCommitProblem(@NotNull List<CodeSmellInfo> codeSmells2, int errors, int warnings) {
        Intrinsics.checkNotNullParameter(codeSmells2, (String)"codeSmells");
        this.codeSmells = codeSmells2;
        this.errors = errors;
        this.warnings = warnings;
    }

    @NotNull
    public String getText() {
        String errorsText = this.errors > 0 ? HighlightSeverity.ERROR.getCountMessage(this.errors) : null;
        String warningsText = this.warnings > 0 ? HighlightSeverity.WARNING.getCountMessage(this.warnings) : null;
        Object[] objectArray = new String[]{errorsText, warningsText};
        String string = NlsMessages.formatAndList((Collection)CollectionsKt.listOfNotNull((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatAndList(...)");
        return string;
    }

    public void showDetails(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CodeSmellDetector.getInstance(project).showCodeSmellErrors(this.codeSmells);
    }

    @NotNull
    public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
        return CodeAnalysisBeforeCheckinHandler.Companion.processFoundCodeSmells$intellij_platform_vcs_impl(project, this.codeSmells, commitInfo.getCommitActionText());
    }

    @NotNull
    public String getShowDetailsAction() {
        String string = VcsBundle.message((String)"code.smells.review.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

