/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add.v1;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0005H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/python/sdk/add/v1/PyAddExistingCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getSdkComboBox", "()Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "layoutComponents", "", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getOrCreateSdk", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyAddExistingCondaEnvPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyAddExistingCondaEnvPanel.kt\ncom/jetbrains/python/sdk/add/v1/PyAddExistingCondaEnvPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,86:1\n24#2:87\n*S KotlinDebug\n*F\n+ 1 PyAddExistingCondaEnvPanel.kt\ncom/jetbrains/python/sdk/add/v1/PyAddExistingCondaEnvPanel\n*L\n82#1:87\n*E\n"})
public class PyAddExistingCondaEnvPanel
extends PyAddSdkPanel {
    @Nullable
    private final Project project;
    @NotNull
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;
    @NotNull
    private final Icon icon;
    @NotNull
    private final PySdkPathChoosingComboBox sdkComboBox;
    @NotNull
    private final TextFieldWithBrowseButton condaPathField;
    @NotNull
    private final JBCheckBox makeSharedField;

    /*
     * WARNING - void declaration
     */
    public PyAddExistingCondaEnvPanel(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath) {
        void $this$condaPathField_u24lambda_u240;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        this.project = project;
        this.existingSdks = existingSdks;
        this.newProjectPath = newProjectPath;
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Anaconda");
        this.icon = icon;
        this.sdkComboBox = new PySdkPathChoosingComboBox(null, null, null, null, 15, null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        PyAddExistingCondaEnvPanel pyAddExistingCondaEnvPanel = this;
        boolean bl = false;
        String path2 = PyCondaPackageService.Companion.getCondaExecutable(null);
        if (path2 != null) {
            $this$condaPathField_u24lambda_u240.setText(path2);
        }
        $this$condaPathField_u24lambda_u240.addBrowseFolderListener(this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor().withTitle(PyBundle.message("python.sdk.select.conda.path.title", new Object[0])));
        pyAddExistingCondaEnvPanel.condaPathField = textFieldWithBrowseButton;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        ((ComboBoxWithWidePopup)this.sdkComboBox.getChildComponent()).addItemListener(arg_0 -> PyAddExistingCondaEnvPanel._init_$lambda$1(this, arg_0));
        if (PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault()) {
            this.makeSharedField.setSelected(true);
        }
        this.layoutComponents();
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.existing.environment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected final PySdkPathChoosingComboBox getSdkComboBox() {
        return this.sdkComboBox;
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent(PySdkBundle.message("python.interpreter.label", new Object[0]), (JComponent)((Object)this.sdkComboBox)).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField).getPanel();
        this.add((Component)formPanel, "North");
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object)PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox, this));
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk2;
        Sdk sdk3 = this.sdkComboBox.getSelectedSdk();
        String string = this.condaPathField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        PyCondaPackageService.Companion.onCondaEnvCreated(string);
        if (sdk3 instanceof PyDetectedSdk) {
            PyDetectedSdk pyDetectedSdk = (PyDetectedSdk)sdk3;
            String string2 = this.getNewProjectPath();
            if (string2 == null) {
                Project project = this.project;
                string2 = project != null ? project.getBasePath() : null;
            }
            Object object = PySdkExtKt.setupAssociated(pyDetectedSdk, this.existingSdks, string2, !this.makeSharedField.isSelected());
            PyAddExistingCondaEnvPanel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PyAddExistingCondaEnvPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            sdk2 = (Sdk)LoggerKt.getOrLogException((Object)object, (Logger)logger);
        } else {
            sdk2 = sdk3;
        }
        return sdk2;
    }

    private static final void _init_$lambda$1(PyAddExistingCondaEnvPanel this$0, ItemEvent it) {
        if (it.getStateChange() == 1) {
            String respectiveCondaExecutable = PyCondaPackageService.Companion.getCondaExecutable(this$0.sdkComboBox.getSelectedSdk().getHomePath());
            TextFieldWithBrowseButton textFieldWithBrowseButton = this$0.condaPathField;
            String string = respectiveCondaExecutable;
            if (string == null) {
                string = "";
            }
            textFieldWithBrowseButton.setText(string);
        }
    }
}

