/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.fix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.XmlUnknownAttributeQuickFixProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.frameworks.jsx.JSXComponent;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.react.ReactBundle;
import com.intellij.react.fix.ReactUnresolvedPropFix;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/react/fix/ReactUnresolvedPropFixProvider;", "Lcom/intellij/codeInspection/htmlInspections/XmlUnknownAttributeQuickFixProvider;", "<init>", "()V", "getOrRegisterAttributeFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "name", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isFixRequired", "", "registerProblem", "", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "intellij.react"})
@SourceDebugExtension(value={"SMAP\nReactUnresolvedPropFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactUnresolvedPropFixProvider.kt\ncom/intellij/react/fix/ReactUnresolvedPropFixProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n2632#2,3:69\n*S KotlinDebug\n*F\n+ 1 ReactUnresolvedPropFixProvider.kt\ncom/intellij/react/fix/ReactUnresolvedPropFixProvider\n*L\n37#1:69,3\n*E\n"})
public final class ReactUnresolvedPropFixProvider
implements XmlUnknownAttributeQuickFixProvider {
    @NotNull
    public Collection<LocalQuickFix> getOrRegisterAttributeFixes(@NotNull XmlTag tag, @NotNull String name, @NotNull ProblemsHolder holder, boolean isFixRequired) {
        boolean bl;
        XmlAttribute attribute;
        block8: {
            PsiElement declaration;
            XmlAttributeDescriptor descriptor;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (!DialectDetector.isTypeScript((PsiElement)((PsiElement)tag))) {
                return CollectionsKt.emptyList();
            }
            String string = tag.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String tagName = string;
            if (!JSXResolveUtil.isComponentName((String)tagName)) {
                return CollectionsKt.emptyList();
            }
            XmlAttribute xmlAttribute = tag.getAttribute(name);
            if (xmlAttribute == null) {
                return CollectionsKt.emptyList();
            }
            attribute = xmlAttribute;
            XmlAttributeDescriptor xmlAttributeDescriptor = descriptor = attribute.getDescriptor();
            Object object = declaration = xmlAttributeDescriptor != null ? xmlAttributeDescriptor.getDeclaration() : null;
            if (descriptor != null && declaration != null && !(declaration instanceof JSImplicitElement)) {
                return CollectionsKt.emptyList();
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)tag.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
            GlobalSearchScope projectScope = globalSearchScope;
            PsiFile psiFile = tag.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            JSXComponent jsxComponent = JSXImplementation.Companion.getImplementation((PsiElement)psiFile).resolveComponent(tag);
            Collection collection = jsxComponent.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getElements(...)");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!projectScope.accept(it.getContainingFile().getVirtualFile())) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return CollectionsKt.emptyList();
        }
        this.registerProblem(tag, holder, attribute, name);
        return CollectionsKt.emptyList();
    }

    private final void registerProblem(XmlTag tag, ProblemsHolder holder, XmlAttribute attribute, String name) {
        TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)((PsiElement)tag.getContainingFile()));
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptAnnotatorCheckerProvider, (String)"getCheckerProvider(...)");
        TypeScriptAnnotatorCheckerProvider provider = typeScriptAnnotatorCheckerProvider;
        JSProblemReporter jSProblemReporter = provider.getTypeCheckProblemReporter((arg_0, arg_1, arg_2, arg_3, arg_4) -> ReactUnresolvedPropFixProvider.registerProblem$lambda$1(holder, arg_0, arg_1, arg_2, arg_3, arg_4));
        Intrinsics.checkNotNullExpressionValue((Object)jSProblemReporter, (String)"getTypeCheckProblemReporter(...)");
        JSProblemReporter problemReporter = jSProblemReporter;
        Object[] objectArray = new Object[]{name};
        String string = ReactBundle.message("react.inspection.unresolved.component.prop", objectArray);
        objectArray = new LocalQuickFix[]{new ReactUnresolvedPropFix(attribute)};
        problemReporter.registerProblem((PsiElement)attribute, null, string, ProblemHighlightType.ERROR, (LocalQuickFix[])objectArray);
    }

    private static final Unit registerProblem$lambda$1(ProblemsHolder $holder, PsiElement place, TextRange textRange, String message, ProblemHighlightType highlightType, LocalQuickFix[] fixes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
        if (highlightType == null) {
            return Unit.INSTANCE;
        }
        if (highlightType == ProblemHighlightType.INFORMATION && !$holder.isOnTheFly()) {
            return Unit.INSTANCE;
        }
        $holder.registerProblem(place, message, highlightType, Arrays.copyOf(fixes, fixes.length));
        return Unit.INSTANCE;
    }
}

