/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.diff.extensions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.diff.extensions.JupyterDiffRequestWrapper;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J$\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/diff/extensions/RequestSubstitutors;", "", "<init>", "()V", "substituteDiffRequest", "Lcom/intellij/diff/requests/DiffRequest;", "context", "Lcom/intellij/diff/DiffContext;", "oldRequest", "substituteContent", "Lcom/intellij/diff/contents/DiffContent;", "content", "Lcom/intellij/diff/contents/DocumentContent;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "intellij.jupyter.diff"})
@SourceDebugExtension(value={"SMAP\nRequestSubstitutors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestSubstitutors.kt\ncom/intellij/jupyter/diff/extensions/RequestSubstitutors\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class RequestSubstitutors {
    @NotNull
    public static final RequestSubstitutors INSTANCE = new RequestSubstitutors();

    private RequestSubstitutors() {
    }

    @Nullable
    public final DiffRequest substituteDiffRequest(@NotNull DiffContext context, @NotNull DiffRequest oldRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)oldRequest, (String)"oldRequest");
        ContentDiffRequest cfr_ignored_0 = (ContentDiffRequest)oldRequest;
        List newContents = new ArrayList();
        List list = ((ContentDiffRequest)oldRequest).getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        Iterable iterable = list;
        List list2 = ((ContentDiffRequest)oldRequest).getContentTitles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContentTitles(...)");
        for (Pair pair : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
            DiffContent newContent;
            DiffContent content = (DiffContent)pair.component1();
            String title = (String)pair.component2();
            if (content instanceof EmptyContent) {
                v3 = content;
            } else {
                Intrinsics.checkNotNull((Object)content, (String)"null cannot be cast to non-null type com.intellij.diff.contents.DocumentContent");
                DocumentContent documentContent = (DocumentContent)content;
                Project project = context.getProject();
                Intrinsics.checkNotNull((Object)project);
                v3 = newContent = this.substituteContent(documentContent, project, title);
            }
            if (newContent == null) {
                return null;
            }
            newContents.add(newContent);
        }
        return (DiffRequest)new JupyterDiffRequestWrapper(newContents, (ContentDiffRequest)oldRequest);
    }

    @Nullable
    public final DiffContent substituteContent(@NotNull DocumentContent content, @NotNull Project project, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DiffContentFactory diffContentFactory = DiffContentFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)diffContentFactory, (String)"getInstance(...)");
        DiffContentFactory contentFactory = diffContentFactory;
        if (content instanceof FileContent && ((FileContent)content).getFile().isInLocalFileSystem()) {
            VirtualFile virtualFile = ((FileContent)content).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.find(virtualFile);
            if (backedNotebookVirtualFile != null) {
                BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
                boolean bl = false;
                return contentFactory.create(project, notebookFile.getFile());
            }
        }
        String string = content.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String oldContent = string;
        JupyterNotebookBase jupyterNotebookBase = JupyterFileUtils.readNotebookOrNull$default((JupyterFileUtils)JupyterFileUtils.INSTANCE, (CharSequence)oldContent, null, (int)2, null);
        if (jupyterNotebookBase == null) {
            return null;
        }
        JupyterNotebookBase notebook = jupyterNotebookBase;
        Object object = content.getHighlightFile();
        if (object == null || (object = object.getName()) == null) {
            Object object2 = title;
            if (object2 == null) {
                object2 = "DiffContent" + oldContent.hashCode();
            }
            object = (String)object2 + "." + JupyterFileType.INSTANCE.getDefaultExtension();
        }
        Object fileName = object;
        CharSequence newContent = JupyterFileRegistry.INSTANCE.getUseSingleFile() ? notebook.asSource() : (CharSequence)oldContent;
        LightVirtualFile file = new LightVirtualFile((String)fileName, (FileType)JupyterFileType.INSTANCE, newContent);
        BackedNotebookVirtualFile notebookFile = BackedNotebookVirtualFile.Companion.createWithNotebook((VirtualFile)file, (JupyterNotebook)notebook);
        Document document = FileDocumentManager.getInstance().getDocument(notebookFile.getFile());
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        document2.setReadOnly(true);
        return (DiffContent)contentFactory.create(project, document2, content.getHighlightFile());
    }

    public static /* synthetic */ DiffContent substituteContent$default(RequestSubstitutors requestSubstitutors, DocumentContent documentContent, Project project, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return requestSubstitutors.substituteContent(documentContent, project, string);
    }
}

