/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.ExasolExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.ExasolIntermediateFacade;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExaJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> EXA_UNLIMITED_TYPES = JdbcNativeUtil.addAll(new HashSet(), "integer", "clob", "blob", "boolean", "timestamp", "date", "double precision");

    public ExaJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("EXASOL", version, connection);
    }

    public ExaJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return ExaJdbcHelper.extractVersion(version);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new ExaJdbcHelper(version, connection);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            ExaJdbcHelper.$$$reportNull$$$0(0);
        }
        return new ExasolIntermediateFacade(ds, ExasolExceptionRecognizer.INSTANCE, this);
    }

    @Override
    public JdbcHelper.LikeSupport getLikeSupport() {
        return JdbcHelper.LikeSupport.SELECTS_ONLY;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            ExaJdbcHelper.$$$reportNull$$$0(1);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (EXA_UNLIMITED_TYPES.contains(t)) {
            e.length = -1;
        } else if (t.startsWith("interval")) {
            e.length = e.scale == 0 ? -1 : e.scale;
            e.scale = 0;
        }
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) {
        if (!JdbcNativeUtil.detectString(product, "exasol")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return ExaJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            ExaJdbcHelper.$$$reportNull$$$0(2);
        }
        return ExaJdbcHelper.classNameContains(driver, "com.exasol.");
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        if (level != null) {
            ExaJdbcHelper.setIfEmpty(properties, "debug", level == Level.OFF ? "0" : "1");
        }
        if (logPath != null) {
            ExaJdbcHelper.setIfEmpty(properties, "logdir", logPath);
        }
    }

    @Override
    @Nullable
    protected JdbcHelperImpl.TemporalGetter getTemporalGetter(@Nullable String typeName, int type) {
        if (type == 93) {
            return LOCAL_TIMESTAMP_GETTER;
        }
        return null;
    }

    @NotNull
    private static ExaJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new ExaJdbcHelper(ExaJdbcHelper.extractVersion(productVer), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/ExaJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

