/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u000bJ\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\t\u001a'\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache;", "", "<init>", "()V", "JUPYTER_NOTEBOOK_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "JUPYTER_PERSISTENT_COUNT", "Ljava/util/concurrent/atomic/AtomicInteger;", "notebookFileCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "registryForEditor", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "registryForDisposable", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "disposable", "Lcom/intellij/openapi/Disposable;", "get", "put", "notebook", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileModelCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n11#2:100\n12#2:102\n11#2:103\n12#2:105\n1#3:101\n1#3:104\n*S KotlinDebug\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache\n*L\n55#1:100\n55#1:102\n75#1:103\n75#1:105\n55#1:101\n75#1:104\n*E\n"})
public final class JupyterFileModelCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key<JupyterNotebook> JUPYTER_NOTEBOOK_KEY = new Key("JUPYTER_NOTEBOOK_KEY");
    @NotNull
    private final Key<AtomicInteger> JUPYTER_PERSISTENT_COUNT = new Key("JUPYTER_NOTEBOOK_USE_COUNT");
    @NotNull
    private final ConcurrentMap<VirtualFile, JupyterNotebook> notebookFileCache;

    public JupyterFileModelCache() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.notebookFileCache = concurrentMap;
    }

    public final void registryForEditor(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.isDisposed()) {
            return;
        }
        Disposable disposable = editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        Disposable disposable2 = disposable;
        this.registryForDisposable(JupyterEditorExtensionsKt.getNotebookFile((Editor)editor), disposable2);
    }

    private final void registryForDisposable(BackedNotebookVirtualFile virtualFile, Disposable disposable) {
        Object object;
        UserDataHolderEx userDataHolderEx;
        Key<AtomicInteger> key;
        Object object2;
        boolean bl;
        Object it$iv;
        UserDataHolderEx $this$getOrCreateUserData$iv;
        if (!JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return;
        }
        VirtualFile file = virtualFile.getFile();
        UserDataHolderEx userDataHolderEx2 = (UserDataHolderEx)file;
        Object key$iv = this.JUPYTER_PERSISTENT_COUNT;
        boolean $i$f$getOrCreateUserData = false;
        Object object3 = $this$getOrCreateUserData$iv.getUserData(key$iv);
        if (object3 != null) {
            it$iv = object3;
            bl = false;
            object2 = it$iv;
        } else {
            key = key$iv;
            userDataHolderEx = $this$getOrCreateUserData$iv;
            boolean bl2 = false;
            object = new AtomicInteger(0);
            object2 = userDataHolderEx.putUserDataIfAbsent(key, object);
        }
        AtomicInteger counter = (AtomicInteger)object2;
        Disposer.register((Disposable)disposable, () -> JupyterFileModelCache.registryForDisposable$lambda$3(counter, file, this));
        $this$getOrCreateUserData$iv = (UserDataHolderEx)file;
        key$iv = this.JUPYTER_NOTEBOOK_KEY;
        $i$f$getOrCreateUserData = false;
        Object object4 = $this$getOrCreateUserData$iv.getUserData(key$iv);
        if (object4 != null) {
            it$iv = object4;
            bl = false;
        } else {
            key = key$iv;
            userDataHolderEx = $this$getOrCreateUserData$iv;
            boolean bl3 = false;
            JupyterNotebook jupyterNotebook = this.get(file);
            if (jupyterNotebook == null) {
                jupyterNotebook = JupyterFileUtils.INSTANCE.readNotebook(file);
            }
            object = jupyterNotebook;
            userDataHolderEx.putUserDataIfAbsent(key, object);
        }
        counter.incrementAndGet();
    }

    @Nullable
    public final JupyterNotebook get(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        JupyterNotebook jupyterNotebook = (JupyterNotebook)this.notebookFileCache.get(virtualFile);
        if (jupyterNotebook != null) {
            return jupyterNotebook;
        }
        return (JupyterNotebook)virtualFile.getUserData(this.JUPYTER_NOTEBOOK_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(@NotNull VirtualFile virtualFile, @Nullable JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        JupyterFileModelCache jupyterFileModelCache = this;
        synchronized (jupyterFileModelCache) {
            boolean bl = false;
            ((Map)this.notebookFileCache).put(virtualFile, notebook);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Unit registryForDisposable$lambda$3$lambda$2$lambda$1(FileDocumentManager $fileDocumentManager, Document $cachedDocument) {
        $fileDocumentManager.saveDocument($cachedDocument);
        return Unit.INSTANCE;
    }

    private static final Unit registryForDisposable$lambda$3$lambda$2(FileDocumentManager $fileDocumentManager, Document $cachedDocument) {
        ActionsKt.runWriteAction(() -> JupyterFileModelCache.registryForDisposable$lambda$3$lambda$2$lambda$1($fileDocumentManager, $cachedDocument));
        return Unit.INSTANCE;
    }

    private static final void registryForDisposable$lambda$3(AtomicInteger $counter, VirtualFile $file, JupyterFileModelCache this$0) {
        int count = $counter.decrementAndGet();
        if (count == 0) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            FileDocumentManager fileDocumentManager2 = fileDocumentManager;
            Document cachedDocument = fileDocumentManager2.getCachedDocument($file);
            if (cachedDocument != null) {
                ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.nonModal(), () -> JupyterFileModelCache.registryForDisposable$lambda$3$lambda$2(fileDocumentManager2, cachedDocument));
            }
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$file), this$0.JUPYTER_NOTEBOOK_KEY);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache$Companion;", "", "<init>", "()V", "getForFile", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "putCacheForFile", "", "notebook", "registryForEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "registryForDisposable", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterFileModelCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,99:1\n40#2,3:100\n40#2,3:103\n40#2,3:106\n40#2,3:109\n*S KotlinDebug\n*F\n+ 1 JupyterFileModelCache.kt\ncom/intellij/jupyter/core/core/impl/file/singleFile/JupyterFileModelCache$Companion\n*L\n94#1:100,3\n95#1:103,3\n96#1:106,3\n97#1:109,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final JupyterNotebook getForFile(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            boolean $i$f$service = false;
            Class<JupyterFileModelCache> serviceClass$iv = JupyterFileModelCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return ((JupyterFileModelCache)object).get(virtualFile);
        }

        public final void putCacheForFile(@NotNull VirtualFile virtualFile, @Nullable JupyterNotebook notebook) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            boolean $i$f$service = false;
            Class<JupyterFileModelCache> serviceClass$iv = JupyterFileModelCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((JupyterFileModelCache)object).put(virtualFile, notebook);
        }

        public final void registryForEditor(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            boolean $i$f$service = false;
            Class<JupyterFileModelCache> serviceClass$iv = JupyterFileModelCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((JupyterFileModelCache)object).registryForEditor((EditorImpl)editor);
        }

        public final void registryForDisposable(@NotNull BackedNotebookVirtualFile virtualFile, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            boolean $i$f$service = false;
            Class<JupyterFileModelCache> serviceClass$iv = JupyterFileModelCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((JupyterFileModelCache)object).registryForDisposable(virtualFile, disposable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

