/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestAll;
import com.intellij.TestCaseLoader;
import com.intellij.tests.Retries;
import com.intellij.util.ThrowableRunnable;
import java.util.Enumeration;
import junit.extensions.TestDecorator;
import junit.framework.AssertionFailedError;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestAdapterCache;
import junit.framework.JUnit4TestCaseFacade;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

final class RetriesImpl {
    private RetriesImpl() {
    }

    static JUnit4TestAdapterCache maybeEnable(JUnit4TestAdapterCache cache) {
        if (Retries.NUMBER > 0) {
            return new JUnit4TestAdapterCacheDelegate(cache);
        }
        return cache;
    }

    static TestResult maybeEnable(TestResult testResult) {
        if (Retries.NUMBER > 0) {
            testResult = new RetryingTestResult(testResult);
        }
        return testResult;
    }

    private static <T extends Throwable> void retryTest(String description, ThrowableRunnable<T> test) {
        for (int i = 1; i <= Retries.NUMBER; ++i) {
            try {
                System.out.println(description + " failed, retrying attempt #" + i + " of " + Retries.NUMBER);
                test.run();
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
    }

    private static void retryTest(Failure failure, RunNotifier notifier) {
        Description testDescription = failure.getDescription();
        if (testDescription == Description.EMPTY || testDescription == Description.TEST_MECHANISM || !testDescription.isTest()) {
            return;
        }
        Class testClass = testDescription.getTestClass();
        if (testClass == null) {
            throw new IllegalStateException("No test class for " + testDescription.getDisplayName());
        }
        if (TestCase.class.isAssignableFrom(testClass) && "warning".equals(testDescription.getMethodName()) || TestCaseLoader.isPerformanceTest(null, testClass.getSimpleName())) {
            return;
        }
        Runner runner = Request.classWithoutSuiteMethod((Class)testClass).filterWith(testDescription).getRunner();
        RetryListener failureExposingListener = new RetryListener();
        notifier.addFirstListener((RunListener)failureExposingListener);
        RetriesImpl.retryTest(testDescription.getDisplayName(), () -> {
            failureExposingListener.failure = null;
            runner.run(notifier);
            if (failureExposingListener.failure != null) {
                throw failureExposingListener.failure.getException();
            }
        });
        notifier.removeListener((RunListener)failureExposingListener);
    }

    private static void retryTest(Test test, TestResult testResult) {
        if (test instanceof TestCase) {
            if ("warning".equals(((TestCase)test).getName())) {
                return;
            }
            TestResultDelegate testResultDelegate = new TestResultDelegate(testResult);
            RetryListener failureExposingListener = new RetryListener();
            testResultDelegate.addFirstListener(failureExposingListener);
            RetriesImpl.retryTest(test.toString(), () -> {
                TestResultDelegate testResultDelegate2 = testResultDelegate;
                synchronized (testResultDelegate2) {
                    failureExposingListener.throwable = null;
                }
                test.run((TestResult)testResultDelegate);
                testResultDelegate2 = testResultDelegate;
                synchronized (testResultDelegate2) {
                    if (failureExposingListener.throwable != null) {
                        throw failureExposingListener.throwable;
                    }
                }
            });
            testResultDelegate.removeListener(failureExposingListener);
        } else if (!(test instanceof TestAll || test instanceof TestSuite || test instanceof TestDecorator || test instanceof JUnit4TestAdapter || test instanceof JUnit4TestCaseFacade)) {
            String msg = "Unable to retry test " + test.getClass().getCanonicalName();
            System.out.println("##teamcity[message text='" + msg + "' status='ERROR']");
            throw new IllegalStateException(msg);
        }
    }

    private static class JUnit4TestAdapterCacheDelegate
    extends JUnit4TestAdapterCache {
        final JUnit4TestAdapterCache delegate;

        JUnit4TestAdapterCacheDelegate(JUnit4TestAdapterCache delegate) {
            this.delegate = delegate;
        }

        public RunNotifier getNotifier(TestResult result, JUnit4TestAdapter adapter) {
            return new RetryingRunNotifier(this.delegate.getNotifier(result, adapter));
        }
    }

    private static class RetryingTestResult
    extends TestResultDelegate {
        volatile Test failedTest;

        RetryingTestResult(TestResult delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startTest(Test test) {
            RetryingTestResult retryingTestResult = this;
            synchronized (retryingTestResult) {
                this.failedTest = null;
            }
            super.startTest(test);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void addError(Test test, Throwable e) {
            super.addError(test, e);
            if (!(e instanceof AssumptionViolatedException)) {
                RetryingTestResult retryingTestResult = this;
                synchronized (retryingTestResult) {
                    this.failedTest = test;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void addFailure(Test test, AssertionFailedError e) {
            super.addFailure(test, e);
            RetryingTestResult retryingTestResult = this;
            synchronized (retryingTestResult) {
                this.failedTest = test;
            }
        }

        @Override
        public void endTest(Test test) {
            super.endTest(test);
            if (this.failedTest != null && !Retries.shouldStop()) {
                RetriesImpl.retryTest(this.failedTest, this.delegate);
            }
        }
    }

    private static class RetryListener
    extends RunListener
    implements TestListener {
        Failure failure;
        Throwable throwable;

        private RetryListener() {
        }

        public void testFailure(Failure failure) throws Exception {
            this.failure = failure;
        }

        public void testFinished(Description description) throws Exception {
            Retries.testFinished(description, this.failure == null);
        }

        public void addError(Test test, Throwable e) {
            this.throwable = e;
        }

        public void addFailure(Test test, AssertionFailedError e) {
            this.throwable = e;
        }

        public void endTest(Test test) {
            Retries.testFinished(test, this.throwable == null);
        }

        public void startTest(Test test) {
        }
    }

    private static class TestResultDelegate
    extends TestResult {
        final TestResult delegate;

        TestResultDelegate(TestResult delegate) {
            this.delegate = delegate;
        }

        public void runProtected(Test test, Protectable p) {
            super.runProtected(test, p);
        }

        public void startTest(Test test) {
            this.delegate.startTest(test);
        }

        public synchronized void addError(Test test, Throwable e) {
            this.delegate.addError(test, e);
        }

        public synchronized void addFailure(Test test, AssertionFailedError e) {
            this.delegate.addFailure(test, e);
        }

        public void endTest(Test test) {
            this.delegate.endTest(test);
        }

        synchronized void addFirstListener(TestListener listener) {
            this.fListeners.add(0, listener);
        }

        public synchronized void addListener(TestListener listener) {
            this.delegate.addListener(listener);
        }

        public synchronized void removeListener(TestListener listener) {
            this.delegate.removeListener(listener);
        }

        public synchronized int errorCount() {
            return this.delegate.errorCount();
        }

        public synchronized Enumeration<TestFailure> errors() {
            return this.delegate.errors();
        }

        public synchronized int failureCount() {
            return this.delegate.failureCount();
        }

        public synchronized Enumeration<TestFailure> failures() {
            return this.delegate.failures();
        }

        public synchronized int runCount() {
            return this.delegate.runCount();
        }

        public synchronized boolean shouldStop() {
            return this.delegate.shouldStop();
        }

        public synchronized void stop() {
            this.delegate.stop();
        }

        public synchronized boolean wasSuccessful() {
            return this.delegate.wasSuccessful();
        }
    }

    private static class RetryingRunNotifier
    extends RunNotifier {
        final RunNotifier delegate;
        volatile Failure failure;

        RetryingRunNotifier(RunNotifier delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTestStarted(Description description) throws StoppedByUserException {
            RetryingRunNotifier retryingRunNotifier = this;
            synchronized (retryingRunNotifier) {
                this.failure = null;
            }
            this.delegate.fireTestStarted(description);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireTestFailure(Failure failure) {
            this.delegate.fireTestFailure(failure);
            if (!(failure.getException() instanceof AssumptionViolatedException)) {
                RetryingRunNotifier retryingRunNotifier = this;
                synchronized (retryingRunNotifier) {
                    this.failure = failure;
                }
            }
        }

        public void fireTestFinished(Description description) {
            this.delegate.fireTestFinished(description);
            if (this.failure != null && !Retries.shouldStop()) {
                RetriesImpl.retryTest(this.failure, this.delegate);
            }
        }

        public void addListener(RunListener listener) {
            this.delegate.addListener(listener);
        }

        public void removeListener(RunListener listener) {
            this.delegate.removeListener(listener);
        }

        public void fireTestRunStarted(Description description) {
            this.delegate.fireTestRunStarted(description);
        }

        public void fireTestRunFinished(Result result) {
            this.delegate.fireTestRunFinished(result);
        }

        public void fireTestAssumptionFailed(Failure failure) {
            this.delegate.fireTestAssumptionFailed(failure);
        }

        public void fireTestIgnored(Description description) {
            this.delegate.fireTestIgnored(description);
        }

        public void pleaseStop() {
            this.delegate.pleaseStop();
        }

        public void addFirstListener(RunListener listener) {
            this.delegate.addFirstListener(listener);
        }
    }
}

