/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vscode;

import com.intellij.icons.AllIcons;
import com.intellij.ide.startup.importSettings.TransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vscode.VSCodeSettingsProcessor;
import com.intellij.ide.startup.importSettings.providers.vscode.VSCodeTransferSettingsRightPanelChooser;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRightPanelChooser;
import com.intellij.util.SmartList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0019\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeTransferSettingsProvider;", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "transferableIdeId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "getTransferableIdeId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "processor", "Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeSettingsProcessor;", "name", "", "getName", "()Ljava/lang/String;", "isAvailable", "", "hasDataToImport", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIdeVersions", "Lcom/intellij/util/SmartList;", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "skipIds", "", "cachedIdeVersion", "getCachedIdeVersion", "()Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "cachedIdeVersion$delegate", "Lkotlin/Lazy;", "getIdeVersion", "isVSCodeDetected", "getRightPanel", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRightPanelChooser;", "ideV", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "intellij.ide.startup.importSettings"})
public final class VSCodeTransferSettingsProvider
implements TransferSettingsProvider {
    @NotNull
    private final TransferableIdeId transferableIdeId;
    @NotNull
    private final VSCodeSettingsProcessor processor;
    @NotNull
    private final Lazy cachedIdeVersion$delegate;

    public VSCodeTransferSettingsProvider(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.transferableIdeId = TransferableIdeId.VSCode;
        this.processor = new VSCodeSettingsProcessor(scope);
        this.cachedIdeVersion$delegate = LazyKt.lazy(() -> VSCodeTransferSettingsProvider.cachedIdeVersion_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    public TransferableIdeId getTransferableIdeId() {
        return this.transferableIdeId;
    }

    @Override
    @NotNull
    public String getName() {
        return "Visual Studio Code";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @Nullable
    public Object hasDataToImport(@NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ VSCodeTransferSettingsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Boxing.boxBoolean((boolean)VSCodeTransferSettingsProvider.access$isVSCodeDetected(this.this$0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public SmartList<IdeVersion> getIdeVersions(@NotNull List<String> skipIds) {
        SmartList smartList;
        Intrinsics.checkNotNullParameter(skipIds, (String)"skipIds");
        boolean bl = this.isVSCodeDetected();
        if (bl) {
            smartList = new SmartList((Object)this.getIdeVersion());
        } else if (!bl) {
            smartList = new SmartList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return smartList;
    }

    private final IdeVersion getCachedIdeVersion() {
        Lazy lazy = this.cachedIdeVersion$delegate;
        return (IdeVersion)lazy.getValue();
    }

    private final IdeVersion getIdeVersion() {
        return this.getCachedIdeVersion();
    }

    private final boolean isVSCodeDetected() {
        return Files.isDirectory(Paths.get(VSCodeSettingsProcessor.Companion.getVsCodeHome$intellij_ide_startup_importSettings(), new String[0]), new LinkOption[0]) && this.processor.isInstanceRecentEnough() && this.processor.willDetectAtLeastSomething();
    }

    @Override
    @NotNull
    public TransferSettingsRightPanelChooser getRightPanel(@NotNull IdeVersion ideV, @NotNull TransferSettingsConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)ideV, (String)"ideV");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new VSCodeTransferSettingsRightPanelChooser(ideV, config);
    }

    private static final Settings cachedIdeVersion_delegate$lambda$1$lambda$0(VSCodeTransferSettingsProvider this$0) {
        return this$0.processor.getProcessedSettings();
    }

    private static final IdeVersion cachedIdeVersion_delegate$lambda$1(VSCodeTransferSettingsProvider this$0) {
        Icon icon = AllIcons.TransferSettings.Vscode;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vscode");
        return new IdeVersion(TransferableIdeId.VSCode, null, "VSCode", icon, "Visual Studio Code", null, () -> VSCodeTransferSettingsProvider.cachedIdeVersion_delegate$lambda$1$lambda$0(this$0), null, this$0, 0, 672, null);
    }

    public static final /* synthetic */ boolean access$isVSCodeDetected(VSCodeTransferSettingsProvider $this) {
        return $this.isVSCodeDetected();
    }
}

