/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.devmode;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class AnalyzeReturnsAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AnalyzeReturnsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeReturnsAction.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(psiFile != null && psiFile.getFileType() instanceof PythonFileType);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeReturnsAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && vFile != null) {
            new ReturnTypeAnalyzer(project, vFile).run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/devmode/AnalyzeReturnsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/devmode/AnalyzeReturnsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReturnTypeAnalyzer
    extends PyRecursiveElementVisitor {
        private final Project myProject;
        private final VirtualFile myRoot;
        private int myTotalFunctions;
        private int myKnownReturns;
        private int myUnknownReturns;
        private int myNoneReturns;
        private int myFailures;
        private long myDuration;

        ReturnTypeAnalyzer(Project project, VirtualFile vFile) {
            this.myProject = project;
            this.myRoot = vFile;
        }

        public void run() {
            long startTime = System.nanoTime();
            this.analyze(this.myRoot);
            long endTime = System.nanoTime();
            this.myDuration = (endTime - startTime) / 1000000L;
            this.reportResults();
        }

        private void analyze(VirtualFile root) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    PsiFile psiFile;
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!file.isDirectory() && (psiFile = PsiManager.getInstance((Project)myProject).findFile(file)) instanceof PyFile) {
                        System.out.println(file.getName());
                        psiFile.accept((PsiElementVisitor)this);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/python/pro/devmode/AnalyzeReturnsAction$ReturnTypeAnalyzer$1", "visitFile"));
                }
            });
        }

        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                ReturnTypeAnalyzer.$$$reportNull$$$0(0);
            }
            super.visitPyFunction(node);
            this.accountFor((PyCallable)node);
        }

        public void visitPyLambdaExpression(@NotNull PyLambdaExpression node) {
            if (node == null) {
                ReturnTypeAnalyzer.$$$reportNull$$$0(1);
            }
            super.visitPyLambdaExpression(node);
            this.accountFor((PyCallable)node);
        }

        private void accountFor(PyCallable node) {
            ++this.myTotalFunctions;
            try {
                TypeEvalContext context = TypeEvalContext.userInitiated((Project)node.getProject(), (PsiFile)node.getContainingFile());
                PyType returnType = context.getReturnType(node);
                if (returnType == null) {
                    ++this.myUnknownReturns;
                } else if (returnType instanceof PyNoneType) {
                    ++this.myNoneReturns;
                } else {
                    ++this.myKnownReturns;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ++this.myFailures;
            }
        }

        private void reportResults() {
            System.out.println("Total functions: " + this.myTotalFunctions);
            System.out.println("Known returns: " + this.myKnownReturns);
            System.out.println("Unknown returns: " + this.myUnknownReturns);
            System.out.println("None returns: " + this.myNoneReturns);
            System.out.println("Failures: " + this.myFailures);
            System.out.println("Duration: " + this.myDuration + " ms");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/intellij/python/pro/devmode/AnalyzeReturnsAction$ReturnTypeAnalyzer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyLambdaExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

