/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.Result;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PySyncDirection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyServerBasedRemoteProjectSynchronizer
implements PyProjectSynchronizer {
    protected final Sdk mySdk;
    protected final PyRemoteSdkAdditionalData myAdditionalData;

    protected PyServerBasedRemoteProjectSynchronizer(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(0);
        }
        this.mySdk = sdk;
        this.myAdditionalData = PyServerBasedRemoteProjectSynchronizer.getAdditionalData(this.mySdk);
    }

    @NotNull
    static PyRemoteSdkAdditionalData getAdditionalData(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(1);
        }
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        assert (data instanceof PyRemoteSdkAdditionalData) : String.format("sdk is not remote: %s", sdk);
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = (PyRemoteSdkAdditionalData)data;
        if (pyRemoteSdkAdditionalData == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(2);
        }
        return pyRemoteSdkAdditionalData;
    }

    @Nullable
    public final String mapFilePath(@NotNull Project project, @NotNull PySyncDirection direction, @NotNull String filePath2) {
        List<PathMappingSettings.PathMapping> mappings;
        if (project == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(3);
        }
        if (direction == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(4);
        }
        if (filePath2 == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(5);
        }
        if ((mappings = this.getPathMappingsIgnoreError(project)) == null) {
            return null;
        }
        for (PathMappingSettings.PathMapping mapping2 : mappings) {
            if (direction == PySyncDirection.REMOTE_TO_LOCAL && mapping2.canReplaceRemote(filePath2)) {
                return mapping2.mapToLocal(filePath2);
            }
            if (direction != PySyncDirection.LOCAL_TO_REMOTE || !mapping2.canReplaceLocal(filePath2)) continue;
            return mapping2.mapToRemote(filePath2);
        }
        return null;
    }

    @Nullable
    protected abstract Result<List<PathMappingSettings.PathMapping>, String> getPathMappings(@NotNull Project var1);

    @Nullable
    protected final List<PathMappingSettings.PathMapping> getPathMappingsIgnoreError(@NotNull Project project) {
        Result<List<PathMappingSettings.PathMapping>, String> result2;
        if (project == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(6);
        }
        return (result2 = this.getPathMappings(project)) == null ? null : (List)result2.getSuccessOrNull();
    }

    @Nullable
    public String getDefaultRemotePath() {
        return null;
    }

    @NotNull
    protected final RemoteCredentials getCredentials() throws ExecutionException, InterruptedException {
        RemoteCredentials remoteCredentials = this.myAdditionalData.getRemoteCredentials(null, false);
        if (remoteCredentials == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(7);
        }
        return remoteCredentials;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PyServerBasedRemoteProjectSynchronizer";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyServerBasedRemoteProjectSynchronizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalData";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingsIgnoreError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }
}

