/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer;

import com.intellij.icons.AllIcons;
import com.intellij.python.scientific.powerfuldataviewer.DataViewTableImpl;
import com.intellij.python.scientific.powerfuldataviewer.HeaderClickable;
import com.intellij.python.scientific.powerfuldataviewer.actions.SetFilterAction;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class HeaderCellComponent
extends JPanel {
    private final DataViewTableImpl myTable;
    private final JLabel myMainLabel;
    private final HeaderButton myFilterButton;
    public static final Icon ACTIVE_FILTER_ICON = AllIcons.General.Filter;

    public HeaderCellComponent(DataViewTableImpl table, JLabel mainLabel) {
        super(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        this.myTable = table;
        this.myMainLabel = mainLabel;
        this.myMainLabel.setOpaque(false);
        this.myMainLabel.setHorizontalAlignment(2);
        this.myFilterButton = new HeaderButton(AllIcons.General.Filter);
        this.myFilterButton.setOpaque(false);
        this.myFilterButton.setAction(() -> new SetFilterAction(this.myTable, this.myFilterButton.getColumn()).doAction());
        NonOpaquePanel tp = new NonOpaquePanel((LayoutManager)new BorderLayout());
        tp.add((Component)this.myMainLabel, "Center");
        NonOpaquePanel filterPanel = new NonOpaquePanel((JComponent)((Object)this.myFilterButton));
        filterPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        tp.add((Component)filterPanel, "East");
        this.add((Component)tp, "North");
    }

    public void init(boolean hovered, @Nullable ColumnFilter filter2) {
        this.myFilterButton.setVisible(hovered || filter2 != null);
        if (filter2 != null && !hovered) {
            this.myFilterButton.setIcon(ACTIVE_FILTER_ICON);
        } else {
            this.myFilterButton.setIcon(AllIcons.General.Filter);
        }
        this.setBackground(this.myMainLabel.getBackground());
        this.setForeground(this.myMainLabel.getForeground());
    }

    public static class HeaderButton
    extends InplaceButton
    implements HeaderClickable {
        private int myColumn;
        private MouseEvent myLastEvent;
        private Runnable myAction;

        public HeaderButton(Icon icon) {
            super("", icon, null);
        }

        @Override
        public void click(MouseEvent event, int column) {
            this.myLastEvent = event;
            this.myColumn = column;
            this.myAction.run();
        }

        public int getColumn() {
            return this.myColumn;
        }

        public MouseEvent getLastEvent() {
            return this.myLastEvent;
        }

        public void setAction(Runnable action) {
            this.myAction = action;
        }
    }
}

