/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.powerfuldataviewer.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.python.scientific.powerfuldataviewer.DataViewTableImpl;
import com.intellij.python.scientific.powerfuldataviewer.DataViewerProperties;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CopyAction
extends DumbAwareAction {
    private final DataViewTableImpl myTable;

    public CopyAction(DataViewTableImpl table) {
        super(PyBundle.message((String)"debugger.dataviewer.action.copy.name", (Object[])new Object[0]), null, AllIcons.Actions.Copy);
        this.myTable = table;
        this.registerCustomShortcutSet(CommonShortcuts.getCopy(), (JComponent)((Object)this.myTable));
    }

    private static void toClipboard(String data) {
        StringSelection stringSelection = new StringSelection(data);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyAction.$$$reportNull$$$0(0);
        }
        int r1 = this.myTable.getSelectionModel().getMinSelectionIndex();
        int r2 = this.myTable.getSelectionModel().getMaxSelectionIndex();
        int c1 = this.myTable.getColumnModel().getSelectionModel().getMinSelectionIndex();
        int c2 = this.myTable.getColumnModel().getSelectionModel().getMaxSelectionIndex();
        if (r1 != -1 && r2 != -1 && c1 != -1 && c2 != -1) {
            if (r1 == r2 && c1 == c2) {
                CopyAction.toClipboard(this.toCSV(new Object[][]{{this.myTable.getValueAt(r1, c1).toString()}}, r1, c1, o -> o.toString()));
            } else {
                this.tryCopy(r1, r2, c1, c2);
            }
        }
    }

    public void tryCopy(int r1, int r2, int c1, int c2) {
        AsyncArrayTableModel model2 = this.myTable.getAsyncModel();
        model2.loadValues(PyBundle.message((String)"debugger.dataviewer.action.copy.update.message", (Object[])new Object[0]), r1, r2, c1, c2, chunk -> {
            Object[][] data = chunk.getData();
            if (data.length == 0) {
                return;
            }
            CopyAction.toClipboard(this.toCSV(chunk.getData(), r1, c1, o -> model2.correctStringValue(o)));
        });
    }

    private String toCSV(Object[][] data, int rowOffset, int colOffset, Function<Object, String> formatter2) {
        StringBuilder builder = new StringBuilder();
        boolean includeHeader = DataViewerProperties.isCopyWithHeader();
        boolean includeIndices = DataViewerProperties.isCopyWithIndices();
        String separator = DataViewerProperties.getCopySeparator();
        if (includeHeader) {
            if (includeIndices) {
                builder.append(',');
            }
            for (int j = 0; j < data[0].length; ++j) {
                builder.append(this.myTable.getHeaderValueAt(colOffset + j));
                builder.append(j == data[0].length - 1 ? "\n" : separator);
            }
        }
        for (int i = 0; i < data.length; ++i) {
            if (includeIndices) {
                builder.append(this.myTable.getIndexValueAt(rowOffset + i)).append(separator);
            }
            for (int j = 0; j < data[0].length; ++j) {
                builder.append(formatter2.apply(data[i][j]));
                builder.append(j == data[0].length - 1 ? "\n" : separator);
            }
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/python/scientific/powerfuldataviewer/actions/CopyAction", "actionPerformed"));
    }
}

