/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.uml.ERDummyModelInit;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ERUmlElementManager
extends AbstractDiagramElementManager<PyClass> {
    @Nullable
    public PyClass findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            ERUmlElementManager.$$$reportNull$$$0(0);
        }
        Module module = this.getModule(context);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (module != null) {
            ERDummyModelInit umlElement = new ERDummyModelInit(module);
            PsiDirectory directory = null;
            if (element != null) {
                if (element instanceof PsiDirectory) {
                    directory = (PsiDirectory)element;
                } else if (element instanceof PsiFile) {
                    directory = ((PsiFile)element).getContainingDirectory();
                } else {
                    PsiFile file = element.getContainingFile();
                    if (file == null) {
                        return null;
                    }
                    directory = file.getContainingDirectory();
                }
            } else {
                PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
                if (psiFile != null) {
                    directory = psiFile.getContainingDirectory();
                }
            }
            if (directory != null) {
                umlElement.setElement(directory);
                return umlElement;
            }
        }
        return null;
    }

    @Nullable
    protected abstract Module getModule(DataContext var1);

    public String getElementTitle(PyClass element) {
        if (element instanceof ERDummyModelInit) {
            return "#" + ((ERDummyModelInit)element).getModule().getName();
        }
        return element.getQualifiedName();
    }

    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            ERUmlElementManager.$$$reportNull$$$0(1);
        }
        Object text2 = "";
        if (element instanceof ERDummyModelInit) {
            return new SimpleColoredText(((ERDummyModelInit)element).getModule().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (element instanceof PyClass) {
            PyClass parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)((PyClass)element), PyClass.class);
            while (parentClass != null) {
                text2 = (String)text2 + parentClass.getName() + ".";
                parentClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PyClass.class);
            }
            text2 = (String)text2 + ((PyClass)element).getName();
        } else if (element instanceof PyFunction) {
            text2 = (String)text2 + ((PyFunction)element).getName() + ((PyFunction)element).getParameterList().getText();
        } else if (element instanceof PyTargetExpression) {
            text2 = (String)text2 + ((PyTargetExpression)element).getName();
        } else if (element instanceof Map.Entry) {
            text2 = (String)((Map.Entry)element).getKey();
        }
        if (text2 == null) {
            text2 = "";
        }
        return new SimpleColoredText((String)text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Nullable
    public SimpleColoredText getItemType(@Nullable Object element) {
        if (element instanceof Map.Entry) {
            return new SimpleColoredText((String)((Map.Entry)element).getValue(), new SimpleTextAttributes(0, Color.GRAY));
        }
        return super.getItemType(element);
    }

    @Nullable
    @Nls
    public String getNodeTooltip(PyClass element) {
        return null;
    }

    @Nullable
    public Icon getItemIcon(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            ERUmlElementManager.$$$reportNull$$$0(2);
        }
        if (element instanceof Map.Entry) {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Field);
        }
        return super.getItemIcon(element, presentation);
    }

    public Object @NotNull [] getNodeItems(PyClass parent) {
        List<Map.Entry<String, String>> elements = this.getElements(parent);
        elements.sort((o, o1) -> {
            if (o instanceof Map.Entry && o1 instanceof Map.Entry) {
                return ((String)o.getKey()).compareTo((String)o1.getKey());
            }
            return 0;
        });
        Object[] objectArray = elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
        if (objectArray == null) {
            ERUmlElementManager.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    protected abstract List<Map.Entry<String, String>> getElements(PyClass var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/uml/ERUmlElementManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/uml/ERUmlElementManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

